/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Graphics2D;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Automation;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.DisplaySkin;

public final class Display
extends Container {
    private ApplicationContext.DisplayHost displayHost;

    public Display(ApplicationContext.DisplayHost displayHost) {
        this.displayHost = displayHost;
        super.setSkin(new DisplaySkin());
    }

    public ApplicationContext.DisplayHost getDisplayHost() {
        return this.displayHost;
    }

    public java.awt.Window getHostWindow() {
        java.awt.Container parent;
        for (parent = this.displayHost.getParent(); parent != null && !(parent instanceof java.awt.Window); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new IllegalArgumentException("Window does not have a native host.");
        }
        return (java.awt.Window)parent;
    }

    @Override
    protected void setSkin(Skin skin) {
        throw new UnsupportedOperationException("Can't replace Display skin.");
    }

    @Override
    protected void setParent(Container parent) {
        throw new UnsupportedOperationException("Display can't have a parent.");
    }

    @Override
    public void setLocation(int x, int y) {
        throw new UnsupportedOperationException("Can't change the location of the display.");
    }

    @Override
    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException("Can't change the visibility of the display.");
    }

    @Override
    public void setTooltipText(String tooltipText) {
        throw new UnsupportedOperationException("Can't set a tooltip on the display.");
    }

    @Override
    public void repaint(int x, int y, int width, int height, boolean immediate) {
        if (immediate) {
            Graphics2D graphics = (Graphics2D)this.displayHost.getGraphics();
            if (graphics != null) {
                double scale = this.displayHost.getScale();
                if (scale == 1.0) {
                    graphics.clipRect(x, y, width, height);
                } else {
                    graphics.clipRect((int)Math.floor((double)x * scale), (int)Math.floor((double)y * scale), (int)Math.ceil((double)width * scale) + 1, (int)Math.ceil((double)height * scale) + 1);
                }
                this.displayHost.paint(graphics);
                graphics.dispose();
            }
        } else {
            this.displayHost.repaint(x, y, width, height);
        }
    }

    @Override
    public void insert(Component component, int index) {
        if (!(component instanceof Window)) {
            throw new IllegalArgumentException("component must be an instance of " + Window.class);
        }
        super.insert(component, index);
    }

    @Override
    protected void descendantAdded(Component descendant) {
        super.descendantAdded(descendant);
        String automationID = descendant.getAutomationID();
        if (automationID != null) {
            Automation.add(automationID, descendant);
        }
    }

    @Override
    protected void descendantRemoved(Component descendant) {
        super.descendantRemoved(descendant);
        String automationID = descendant.getAutomationID();
        if (automationID != null) {
            Automation.remove(automationID);
        }
    }

    @Override
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return null;
    }
}

