/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Dimensions
implements Serializable {
    private static final long serialVersionUID = -3644511824857807902L;
    public final int width;
    public final int height;
    public static final String WIDTH_KEY = "width";
    public static final String HEIGHT_KEY = "height";

    public Dimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Dimensions(Dimensions dimensions) {
        if (dimensions == null) {
            throw new IllegalArgumentException("dimensions is null.");
        }
        this.width = dimensions.width;
        this.height = dimensions.height;
    }

    public Dimensions(Dictionary<String, ?> dimensions) {
        if (dimensions == null) {
            throw new IllegalArgumentException("dimensions is null.");
        }
        this.width = dimensions.containsKey((Object)WIDTH_KEY) ? (Integer)dimensions.get((Object)WIDTH_KEY) : 0;
        this.height = dimensions.containsKey((Object)HEIGHT_KEY) ? (Integer)dimensions.get((Object)HEIGHT_KEY) : 0;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof Dimensions) {
            Dimensions dimensions = (Dimensions)object;
            equals = this.width == dimensions.width && this.height == dimensions.height;
        }
        return equals;
    }

    public int hashCode() {
        return 31 * this.width + this.height;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.width + "x" + this.height + "]";
    }

    public static Dimensions decode(String value) {
        Dimensions dimensions;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        try {
            dimensions = new Dimensions((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        return dimensions;
    }
}

