/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableMap;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowListener;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.Picture;

public final class DesktopApplicationContext
extends ApplicationContext {
    private static String applicationClassName = null;
    private static HashMap<String, String> properties = null;
    private static Application application = null;
    private static ApplicationContext.DisplayHost primaryDisplayHost = null;
    private static HostFrame windowedHostFrame = null;
    private static HostFrame fullScreenHostFrame = null;
    public static final String DEFAULT_HOST_WINDOW_TITLE = "Apache Pivot";
    public static final String X_ARGUMENT = "x";
    public static final String Y_ARGUMENT = "y";
    public static final String WIDTH_ARGUMENT = "width";
    public static final String HEIGHT_ARGUMENT = "height";
    public static final String CENTER_ARGUMENT = "center";
    public static final String RESIZABLE_ARGUMENT = "resizable";
    public static final String MAXIMIZED_ARGUMENT = "maximized";
    public static final String UNDECORATED_ARGUMENT = "undecorated";
    public static final String FULL_SCREEN_ARGUMENT = "fullScreen";
    public static final String PRESERVE_SPLASH_SCREEN_ARGUMENT = "preserveSplashScreen";
    public static final String ORIGIN_ARGUMENT = "origin";
    private static final String INVALID_PROPERTY_FORMAT_MESSAGE = "\"%s\" is not a valid startup property (expected format is \"--name=value\").";
    private static final String INVALID_PROPERTY_VALUE_MESSAGE = "\"%s\" is not a valid value for startup property \"%s\".";

    public static boolean isActive() {
        return application != null;
    }

    public static void exit() {
        DesktopApplicationContext.exit(true);
    }

    public static boolean exit(boolean optional) {
        boolean cancelShutdown = false;
        if (application != null) {
            try {
                cancelShutdown = application.shutdown(optional);
            }
            catch (Exception exception) {
                DesktopApplicationContext.handleUncaughtException(exception);
            }
            if (!cancelShutdown) {
                applications.remove((Object)application);
            }
        }
        if (!cancelShutdown) {
            try {
                boolean maximized;
                Preferences preferences = Preferences.userNodeForPackage(DesktopApplicationContext.class);
                preferences = preferences.node(applicationClassName);
                boolean bl = maximized = (windowedHostFrame.getExtendedState() & 6) == 6;
                if (!maximized) {
                    preferences.putInt(X_ARGUMENT, windowedHostFrame.getX());
                    preferences.putInt(Y_ARGUMENT, windowedHostFrame.getY());
                    preferences.putInt(WIDTH_ARGUMENT, windowedHostFrame.getWidth());
                    preferences.putInt(HEIGHT_ARGUMENT, windowedHostFrame.getHeight());
                }
                preferences.putBoolean(MAXIMIZED_ARGUMENT, maximized);
                preferences.flush();
            }
            catch (SecurityException exception) {
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            windowedHostFrame.dispose();
            fullScreenHostFrame.dispose();
        }
        return cancelShutdown;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Application class name is required.");
            return;
        }
        applicationClassName = args[0];
        properties = new HashMap();
        int x = 0;
        int y = 0;
        int width = 800;
        int height = 600;
        boolean center = false;
        boolean resizable = true;
        boolean maximized = false;
        boolean undecorated = false;
        boolean fullScreen = false;
        boolean preserveSplashScreen = false;
        try {
            Preferences preferences = Preferences.userNodeForPackage(DesktopApplicationContext.class);
            preferences = preferences.node(applicationClassName);
            x = preferences.getInt(X_ARGUMENT, x);
            y = preferences.getInt(Y_ARGUMENT, y);
            width = preferences.getInt(WIDTH_ARGUMENT, width);
            height = preferences.getInt(HEIGHT_ARGUMENT, height);
            maximized = preferences.getBoolean(MAXIMIZED_ARGUMENT, maximized);
            GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            if (screenDevices.length == 1) {
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
            }
        }
        catch (SecurityException exception) {
            System.err.println("Unable to retrieve startup preferences: " + exception);
        }
        int n = args.length;
        for (int i = 1; i < n; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                String[] property = (arg = arg.substring(2)).split("=");
                if (property.length == 2) {
                    String key = property[0];
                    String value = property[1];
                    try {
                        if (key.equals(X_ARGUMENT)) {
                            x = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals(Y_ARGUMENT)) {
                            y = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals(WIDTH_ARGUMENT)) {
                            width = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals(HEIGHT_ARGUMENT)) {
                            height = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals(CENTER_ARGUMENT)) {
                            center = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals(RESIZABLE_ARGUMENT)) {
                            resizable = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals(MAXIMIZED_ARGUMENT)) {
                            maximized = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals(UNDECORATED_ARGUMENT)) {
                            undecorated = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals(FULL_SCREEN_ARGUMENT)) {
                            fullScreen = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals(PRESERVE_SPLASH_SCREEN_ARGUMENT)) {
                            preserveSplashScreen = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals(ORIGIN_ARGUMENT)) {
                            origin = new URL(value);
                            continue;
                        }
                        properties.put((Object)key, (Object)value);
                    }
                    catch (Exception exception) {
                        System.err.println(String.format(INVALID_PROPERTY_VALUE_MESSAGE, value, key));
                    }
                    continue;
                }
                System.err.println(String.format(INVALID_PROPERTY_FORMAT_MESSAGE, arg));
                continue;
            }
            System.err.println(String.format(INVALID_PROPERTY_FORMAT_MESSAGE, arg));
        }
        DesktopApplicationContext.createTimer();
        primaryDisplayHost = new DesktopDisplayHost();
        displays.add((Object)primaryDisplayHost.getDisplay());
        windowedHostFrame = new HostFrame();
        windowedHostFrame.add(primaryDisplayHost);
        windowedHostFrame.setUndecorated(undecorated);
        windowedHostFrame.setTitle(DEFAULT_HOST_WINDOW_TITLE);
        windowedHostFrame.setSize(width, height);
        windowedHostFrame.setResizable(resizable);
        if (center) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            windowedHostFrame.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        } else {
            windowedHostFrame.setLocation(x, y);
        }
        if (maximized) {
            windowedHostFrame.setExtendedState(6);
        }
        fullScreenHostFrame = new HostFrame();
        fullScreenHostFrame.setUndecorated(true);
        primaryDisplayHost.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 70 && (keyEvent.getModifiersEx() & 0x80) > 0 && (keyEvent.getModifiersEx() & 0x40) > 0) {
                    DesktopApplicationContext.setFullScreen(!DesktopApplicationContext.isFullScreen());
                }
            }
        });
        try {
            Class<?> applicationClass = Class.forName(applicationClassName);
            application = (Application)applicationClass.newInstance();
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        if (application != null) {
            applications.add((Object)application);
            DesktopApplicationContext.initializeOSExtensions();
            boolean visible = !preserveSplashScreen || SplashScreen.getSplashScreen() == null;
            DesktopApplicationContext.setFullScreen(fullScreen, visible);
            if (maximized && visible) {
                windowedHostFrame.setExtendedState(6);
            }
            DesktopApplicationContext.queueCallback(new Runnable(){

                @Override
                public void run() {
                    try {
                        application.startup(primaryDisplayHost.getDisplay(), (Map<String, String>)new ImmutableMap((Map)properties));
                    }
                    catch (Exception exception) {
                        ApplicationContext.handleUncaughtException(exception);
                    }
                }
            });
        }
    }

    private static void initializeOSExtensions() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase(Locale.ENGLISH).startsWith("mac os x")) {
            try {
                Class<?> eawtApplicationClass = Class.forName("com.apple.eawt.Application");
                Class<?> eawtApplicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
                Class<?> eawtApplicationEventClass = Class.forName("com.apple.eawt.ApplicationEvent");
                Method setEnabledAboutMenuMethod = eawtApplicationClass.getMethod("setEnabledAboutMenu", Boolean.TYPE);
                Method addApplicationListenerMethod = eawtApplicationClass.getMethod("addApplicationListener", eawtApplicationListenerClass);
                final Method setHandledMethod = eawtApplicationEventClass.getMethod("setHandled", Boolean.TYPE);
                InvocationHandler handler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        boolean handled = true;
                        String methodName = method.getName();
                        if (methodName.equals("handleAbout")) {
                            Application.AboutHandler aboutHandler = (Application.AboutHandler)((Object)application);
                            aboutHandler.aboutRequested();
                        } else if (methodName.equals("handleQuit")) {
                            handled = !DesktopApplicationContext.exit(true);
                        }
                        setHandledMethod.invoke(args[0], handled);
                        return null;
                    }
                };
                Object eawtApplication = eawtApplicationClass.newInstance();
                setEnabledAboutMenuMethod.invoke(eawtApplication, application instanceof Application.AboutHandler);
                Object eawtApplicationListener = Proxy.newProxyInstance(DesktopApplicationContext.class.getClassLoader(), new Class[]{eawtApplicationListenerClass}, handler);
                addApplicationListenerMethod.invoke(eawtApplication, eawtApplicationListener);
            }
            catch (Throwable throwable) {
                System.err.println("Unable to attach EAWT hooks: " + throwable);
            }
        }
    }

    public static boolean isFullScreen() {
        return fullScreenHostFrame.isVisible();
    }

    public static void setFullScreen(boolean fullScreen) {
        DesktopApplicationContext.setFullScreen(fullScreen, true);
    }

    private static void setFullScreen(boolean fullScreen, boolean visible) {
        GraphicsDevice graphicsDevice = windowedHostFrame.getGraphicsConfiguration().getDevice();
        if (fullScreen) {
            if (windowedHostFrame.isVisible()) {
                windowedHostFrame.remove(primaryDisplayHost);
            }
            windowedHostFrame.setVisible(false);
            if (visible) {
                graphicsDevice.setFullScreenWindow(fullScreenHostFrame);
            }
            fullScreenHostFrame.add(primaryDisplayHost);
            fullScreenHostFrame.setTitle(windowedHostFrame.getTitle());
            fullScreenHostFrame.setVisible(visible);
        } else {
            if (fullScreenHostFrame.isVisible()) {
                fullScreenHostFrame.remove(primaryDisplayHost);
            }
            fullScreenHostFrame.setVisible(false);
            graphicsDevice.setFullScreenWindow(null);
            windowedHostFrame.add(primaryDisplayHost);
            windowedHostFrame.setTitle(fullScreenHostFrame.getTitle());
            windowedHostFrame.setVisible(visible);
        }
        primaryDisplayHost.requestFocusInWindow();
    }

    public static void replaceSplashScreen(Display display) {
        java.awt.Window hostWindow = display.getHostWindow();
        GraphicsDevice device = windowedHostFrame.getGraphicsConfiguration().getDevice();
        if (hostWindow == fullScreenHostFrame && device.getFullScreenWindow() == null) {
            device.setFullScreenWindow(fullScreenHostFrame);
        }
        hostWindow.setVisible(true);
    }

    public static void sizeHostToFit(Window window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        if (DesktopApplicationContext.isFullScreen()) {
            throw new IllegalStateException();
        }
        Dimensions size = window.getPreferredSize();
        java.awt.Window hostWindow = window.getDisplay().getHostWindow();
        Insets frameInsets = hostWindow.getInsets();
        hostWindow.setSize(size.width + (frameInsets.left + frameInsets.right), size.height + (frameInsets.top + frameInsets.bottom));
    }

    public static Display createDisplay(int width, int height, int x, int y, boolean modal, boolean resizable, boolean undecorated, java.awt.Window owner, DisplayListener displayCloseListener) {
        if (DesktopApplicationContext.isFullScreen()) {
            throw new IllegalStateException();
        }
        final HostDialog hostDialog = new HostDialog(owner, modal, displayCloseListener);
        hostDialog.setLocation(x, y);
        hostDialog.setSize(width, height);
        hostDialog.setResizable(resizable);
        hostDialog.setUndecorated(undecorated);
        ApplicationContext.queueCallback(new Runnable(){

            @Override
            public void run() {
                hostDialog.setVisible(true);
            }
        });
        return hostDialog.getDisplay();
    }

    public static final void main(Class<? extends Application> applicationClass, String[] applicationArgs) {
        String[] args = new String[applicationArgs.length + 1];
        System.arraycopy(applicationArgs, 0, args, 1, applicationArgs.length);
        args[0] = applicationClass.getName();
        DesktopApplicationContext.main(args);
    }

    private static class HostDialog
    extends Dialog
    implements TitledWindow {
        private static final long serialVersionUID = 5340356674429280196L;
        private ApplicationContext.DisplayHost displayHost = new DesktopDisplayHost();
        private DisplayListener displayCloseListener;

        public HostDialog(java.awt.Window owner, boolean modal, DisplayListener displayCloseListener) {
            super(owner, modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
            this.displayCloseListener = displayCloseListener;
            this.enableEvents(64L);
            this.setFocusTraversalKeysEnabled(false);
            this.setBackground(null);
            this.add(this.displayHost);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public Display getDisplay() {
            return this.displayHost.getDisplay();
        }

        @Override
        public String getTitle() {
            return super.getTitle();
        }

        @Override
        public void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public void processWindowEvent(WindowEvent event) {
            super.processWindowEvent(event);
            switch (event.getID()) {
                case 200: {
                    Display display = this.displayHost.getDisplay();
                    ApplicationContext.displays.add((Object)display);
                    if (this.displayCloseListener != null) {
                        this.displayCloseListener.hostWindowOpened(display);
                    }
                    this.displayHost.requestFocus();
                    break;
                }
                case 201: {
                    this.dispose();
                    break;
                }
                case 202: {
                    Display display = this.displayHost.getDisplay();
                    ApplicationContext.displays.remove((Object)display);
                    if (this.displayCloseListener == null) break;
                    this.displayCloseListener.hostWindowClosed(display);
                    break;
                }
            }
        }
    }

    private static class HostFrame
    extends Frame
    implements TitledWindow {
        private static final long serialVersionUID = 5340356674429280196L;

        public HostFrame() {
            this.enableEvents(262208L);
            this.setFocusTraversalKeysEnabled(false);
            this.setBackground(null);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public String getTitle() {
            return super.getTitle();
        }

        @Override
        public void setTitle(String title) {
            super.setTitle(title);
        }

        @Override
        public void processWindowEvent(WindowEvent event) {
            super.processWindowEvent(event);
            switch (event.getID()) {
                case 201: {
                    DesktopApplicationContext.exit();
                    break;
                }
                case 202: {
                    System.exit(0);
                    break;
                }
            }
        }

        @Override
        protected void processWindowStateEvent(WindowEvent event) {
            super.processWindowStateEvent(event);
            switch (event.getID()) {
                case 203: {
                    try {
                        application.suspend();
                    }
                    catch (Exception exception) {
                        ApplicationContext.handleUncaughtException(exception);
                    }
                    break;
                }
                case 204: {
                    try {
                        application.resume();
                    }
                    catch (Exception exception) {
                        ApplicationContext.handleUncaughtException(exception);
                    }
                    break;
                }
            }
        }
    }

    private static interface TitledWindow {
        public String getTitle();

        public void setTitle(String var1);
    }

    private static class DesktopDisplayHost
    extends ApplicationContext.DisplayHost {
        private static final long serialVersionUID = 0L;
        private transient Window rootOwner = null;
        private transient Runnable updateHostWindowTitleBarCallback = null;
        private transient WindowListener rootOwnerListener = new WindowListener.Adapter(){

            @Override
            public void titleChanged(Window window, String previousTitle) {
                DesktopDisplayHost.this.updateFrameTitleBar();
            }

            @Override
            public void iconAdded(Window window, Image addedIcon) {
                DesktopDisplayHost.this.updateFrameTitleBar();
            }

            @Override
            public void iconsRemoved(Window window, int index, Sequence<Image> removed) {
                DesktopDisplayHost.this.updateFrameTitleBar();
            }
        };

        public DesktopDisplayHost() {
            Display display = this.getDisplay();
            display.getContainerListeners().add((Object)new ContainerListener.Adapter(){

                @Override
                public void componentInserted(Container container, int index) {
                    if (index == container.getLength() - 1) {
                        DesktopDisplayHost.this.updateFrameTitleBar();
                    }
                }

                @Override
                public void componentsRemoved(Container container, int index, Sequence<Component> removed) {
                    if (index == container.getLength()) {
                        DesktopDisplayHost.this.updateFrameTitleBar();
                    }
                }

                @Override
                public void componentMoved(Container container, int from, int to) {
                    int n = container.getLength();
                    if (from == n - 1 || to == n - 1) {
                        DesktopDisplayHost.this.updateFrameTitleBar();
                    }
                }
            });
        }

        private void updateFrameTitleBar() {
            Window rootOwnerLocal;
            Display display = this.getDisplay();
            int n = display.getLength();
            if (n == 0) {
                rootOwnerLocal = null;
            } else {
                Window topWindow = (Window)display.get(display.getLength() - 1);
                rootOwnerLocal = topWindow.getRootOwner();
            }
            Window previousRootOwner = this.rootOwner;
            if (rootOwnerLocal != previousRootOwner) {
                if (previousRootOwner != null) {
                    previousRootOwner.getWindowListeners().remove((Object)this.rootOwnerListener);
                }
                if (rootOwnerLocal != null) {
                    rootOwnerLocal.getWindowListeners().add((Object)this.rootOwnerListener);
                }
                this.rootOwner = rootOwnerLocal;
            }
            if (this.updateHostWindowTitleBarCallback == null) {
                this.updateHostWindowTitleBarCallback = new Runnable(){

                    @Override
                    public void run() {
                        java.awt.Window hostWindow = DesktopDisplayHost.this.getDisplay().getHostWindow();
                        if (DesktopDisplayHost.this.rootOwner == null) {
                            ((TitledWindow)((Object)hostWindow)).setTitle(DesktopApplicationContext.DEFAULT_HOST_WINDOW_TITLE);
                            hostWindow.setIconImage(null);
                        } else {
                            ((TitledWindow)((Object)hostWindow)).setTitle(DesktopDisplayHost.this.rootOwner.getTitle());
                            ArrayList<BufferedImage> iconImages = new ArrayList<BufferedImage>();
                            for (Image icon : DesktopDisplayHost.this.rootOwner.getIcons()) {
                                if (!(icon instanceof Picture)) continue;
                                iconImages.add(((Picture)icon).getBufferedImage());
                            }
                            if (iconImages.size() == 1) {
                                hostWindow.setIconImage((java.awt.Image)iconImages.get(0));
                            } else if (iconImages.size() > 1) {
                                hostWindow.setIconImages(iconImages);
                            }
                        }
                        DesktopDisplayHost.this.updateHostWindowTitleBarCallback = null;
                    }
                };
                ApplicationContext.queueCallback(this.updateHostWindowTitleBarCallback);
            }
        }
    }

    public static interface DisplayListener {
        public void hostWindowOpened(Display var1);

        public void hostWindowClosed(Display var1);

        public static class Adapter
        implements DisplayListener {
            @Override
            public void hostWindowOpened(Display display) {
            }

            @Override
            public void hostWindowClosed(Display display) {
            }
        }
    }
}

