/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.beans.IDProperty;
import org.apache.pivot.beans.PropertyNotFoundException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Automation;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.ComponentClassListener;
import org.apache.pivot.wtk.ComponentDataListener;
import org.apache.pivot.wtk.ComponentDecoratorListener;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.ComponentMouseWheelListener;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.ComponentStyleListener;
import org.apache.pivot.wtk.ComponentTooltipListener;
import org.apache.pivot.wtk.ConstrainedVisual;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Limits;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;

@IDProperty(value="name")
public abstract class Component
implements ConstrainedVisual {
    private Skin skin = null;
    private int preferredWidth = -1;
    private int preferredHeight = -1;
    private int minimumWidth = 0;
    private int maximumWidth = Integer.MAX_VALUE;
    private int minimumHeight = 0;
    private int maximumHeight = Integer.MAX_VALUE;
    private Dimensions preferredSize = null;
    private int baseline = -1;
    private Container parent = null;
    private boolean valid = false;
    private int x = 0;
    private int y = 0;
    private boolean visible = true;
    private ArrayList<Decorator> decorators = new ArrayList();
    private DecoratorSequence decoratorSequence = new DecoratorSequence();
    private boolean enabled = true;
    private Point mouseLocation = null;
    private Cursor cursor = null;
    private String tooltipText = null;
    private int tooltipDelay = 1000;
    private ApplicationContext.ScheduledCallback triggerTooltipCallback = null;
    private boolean tooltipWrapText = true;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    private MenuHandler menuHandler = null;
    private String name = null;
    private BeanAdapter styles = null;
    private StyleDictionary styleDictionary = new StyleDictionary();
    private HashMap<String, Object> userData = new HashMap();
    private UserDataDictionary userDataDictionary = new UserDataDictionary();
    private HashMap<? extends Enum<?>, Object> attributes = null;
    private String automationID;
    private ComponentListenerList componentListeners = new ComponentListenerList();
    private ComponentStateListenerList componentStateListeners = new ComponentStateListenerList();
    private ComponentDecoratorListenerList componentDecoratorListeners = new ComponentDecoratorListenerList();
    private ComponentStyleListenerList componentStyleListeners = new ComponentStyleListenerList();
    private ComponentMouseListenerList componentMouseListeners = new ComponentMouseListenerList();
    private ComponentMouseButtonListenerList componentMouseButtonListeners = new ComponentMouseButtonListenerList();
    private ComponentMouseWheelListenerList componentMouseWheelListeners = new ComponentMouseWheelListenerList();
    private ComponentKeyListenerList componentKeyListeners = new ComponentKeyListenerList();
    private ComponentTooltipListenerList componentTooltipListeners = new ComponentTooltipListenerList();
    private ComponentDataListenerList componentDataListeners = new ComponentDataListenerList();
    private static Component focusedComponent = null;
    private static HashMap<Class<? extends Component>, Map<String, ?>> typedStyles = new HashMap();
    private static HashMap<String, Map<String, ?>> namedStyles = new HashMap();
    private static ComponentClassListenerList componentClassListeners = new ComponentClassListenerList();

    public String getAutomationID() {
        return this.automationID;
    }

    public void setAutomationID(String automationID) {
        String previousAutomationID = this.automationID;
        this.automationID = automationID;
        if (this.getDisplay() != null) {
            if (previousAutomationID != null) {
                Automation.remove(previousAutomationID);
            }
            if (automationID != null) {
                Automation.add(automationID, this);
            }
        }
    }

    protected Skin getSkin() {
        return this.skin;
    }

    protected void setSkin(Skin skin) {
        if (skin == null) {
            throw new IllegalArgumentException("skin is null.");
        }
        if (this.skin != null) {
            throw new IllegalStateException("Skin is already installed.");
        }
        this.skin = skin;
        this.styles = new BeanAdapter((Object)skin);
        skin.install(this);
        LinkedList styleTypes = new LinkedList();
        for (Class<?> type = this.getClass(); type != Object.class; type = type.getSuperclass()) {
            styleTypes.insert(type, 0);
        }
        for (Class styleType : styleTypes) {
            Map stylesLocal = (Map)typedStyles.get((Object)styleType);
            if (stylesLocal == null) continue;
            this.setStyles(stylesLocal);
        }
        this.invalidate();
        this.repaint();
    }

    protected void installSkin(Class<? extends Component> componentClass) {
        Class<?> type = this.getClass();
        Theme theme = Theme.getTheme();
        Class<? extends Skin> skinClass = theme.getSkinClass(type);
        while (skinClass == null && type != componentClass && type != Component.class) {
            if ((type = type.getSuperclass()) == Component.class) continue;
            skinClass = theme.getSkinClass(type);
        }
        if (type == Component.class) {
            throw new IllegalArgumentException(componentClass.getName() + " is not an ancestor of " + this.getClass().getName());
        }
        if (skinClass == null) {
            throw new IllegalArgumentException("No skin mapping for " + componentClass.getName() + " found.");
        }
        if (type == componentClass) {
            try {
                this.setSkin(skinClass.newInstance());
            }
            catch (InstantiationException exception) {
                throw new IllegalArgumentException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    public Container getParent() {
        return this.parent;
    }

    protected void setParent(Container parent) {
        if (parent == null && this.isFocused()) {
            Component.clearFocus();
        }
        Container previousParent = this.parent;
        this.parent = parent;
        if (previousParent != null) {
            previousParent.descendantRemoved(this);
        }
        if (parent != null) {
            parent.descendantAdded(this);
        }
        this.componentListeners.parentChanged(this, previousParent);
    }

    public Window getWindow() {
        return (Window)this.getAncestor(Window.class);
    }

    public Display getDisplay() {
        return (Display)this.getAncestor(Display.class);
    }

    public Container getAncestor(Class<? extends Container> ancestorType) {
        Component component;
        for (component = this; component != null && !ancestorType.isInstance(component); component = component.getParent()) {
        }
        return (Container)component;
    }

    public Container getAncestor(String ancestorTypeName) throws ClassNotFoundException {
        if (ancestorTypeName == null) {
            throw new IllegalArgumentException();
        }
        return this.getAncestor(Class.forName(ancestorTypeName));
    }

    @Override
    public int getWidth() {
        return this.skin.getWidth();
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public int getHeight() {
        return this.skin.getHeight();
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public Dimensions getSize() {
        return new Dimensions(this.getWidth(), this.getHeight());
    }

    public final void setSize(Dimensions size) {
        if (size == null) {
            throw new IllegalArgumentException("size is null.");
        }
        this.setSize(size.width, size.height);
    }

    @Override
    public void setSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width is negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height is negative.");
        }
        int previousWidth = this.getWidth();
        int previousHeight = this.getHeight();
        if (width != previousWidth || height != previousHeight) {
            this.invalidate();
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.skin.setSize(width, height);
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.componentListeners.sizeChanged(this, previousWidth, previousHeight);
        }
    }

    public int getPreferredWidth() {
        return this.getPreferredWidth(-1);
    }

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidthLocal;
        if (this.preferredWidth == -1) {
            if (height == -1) {
                preferredWidthLocal = this.getPreferredSize().width;
            } else if (this.preferredSize != null && this.preferredSize.height == height) {
                preferredWidthLocal = this.preferredSize.width;
            } else {
                Limits widthLimits = this.getWidthLimits();
                preferredWidthLocal = widthLimits.constrain(this.skin.getPreferredWidth(height));
            }
        } else {
            preferredWidthLocal = this.preferredWidth;
        }
        return preferredWidthLocal;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.setPreferredSize(preferredWidth, this.preferredHeight);
    }

    public boolean isPreferredWidthSet() {
        return this.preferredWidth != -1;
    }

    public int getPreferredHeight() {
        return this.getPreferredHeight(-1);
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeightLocal;
        if (this.preferredHeight == -1) {
            if (width == -1) {
                preferredHeightLocal = this.getPreferredSize().height;
            } else if (this.preferredSize != null && this.preferredSize.width == width) {
                preferredHeightLocal = this.preferredSize.height;
            } else {
                Limits heightLimits = this.getHeightLimits();
                preferredHeightLocal = heightLimits.constrain(this.skin.getPreferredHeight(width));
            }
        } else {
            preferredHeightLocal = this.preferredHeight;
        }
        return preferredHeightLocal;
    }

    public void setPreferredHeight(int preferredHeight) {
        this.setPreferredSize(this.preferredWidth, preferredHeight);
    }

    public boolean isPreferredHeightSet() {
        return this.preferredHeight != -1;
    }

    @Override
    public Dimensions getPreferredSize() {
        if (this.preferredSize == null) {
            Dimensions preferredSizeLocal = this.preferredWidth == -1 && this.preferredHeight == -1 ? this.skin.getPreferredSize() : (this.preferredWidth == -1 ? new Dimensions(this.skin.getPreferredWidth(this.preferredHeight), this.preferredHeight) : (this.preferredHeight == -1 ? new Dimensions(this.preferredWidth, this.skin.getPreferredHeight(this.preferredWidth)) : new Dimensions(this.preferredWidth, this.preferredHeight)));
            Limits widthLimits = this.getWidthLimits();
            Limits heightLimits = this.getHeightLimits();
            int preferredWidthLocal = widthLimits.constrain(preferredSizeLocal.width);
            int preferredHeightLocal = heightLimits.constrain(preferredSizeLocal.height);
            if (preferredSizeLocal.width > preferredWidthLocal) {
                preferredHeightLocal = heightLimits.constrain(this.skin.getPreferredHeight(preferredWidthLocal));
            }
            if (preferredSizeLocal.height > preferredHeightLocal) {
                preferredWidthLocal = widthLimits.constrain(this.skin.getPreferredWidth(preferredHeightLocal));
            }
            this.preferredSize = new Dimensions(preferredWidthLocal, preferredHeightLocal);
        }
        return this.preferredSize;
    }

    public final void setPreferredSize(Dimensions preferredSize) {
        if (preferredSize == null) {
            throw new IllegalArgumentException("preferredSize is null.");
        }
        this.setPreferredSize(preferredSize.width, preferredSize.height);
    }

    public void setPreferredSize(int preferredWidth, int preferredHeight) {
        if (preferredWidth < -1) {
            throw new IllegalArgumentException(preferredWidth + " is not a valid value for preferredWidth.");
        }
        if (preferredHeight < -1) {
            throw new IllegalArgumentException(preferredHeight + " is not a valid value for preferredHeight.");
        }
        int previousPreferredWidth = this.preferredWidth;
        int previousPreferredHeight = this.preferredHeight;
        if (previousPreferredWidth != preferredWidth || previousPreferredHeight != preferredHeight) {
            this.preferredWidth = preferredWidth;
            this.preferredHeight = preferredHeight;
            this.invalidate();
            this.componentListeners.preferredSizeChanged(this, previousPreferredWidth, previousPreferredHeight);
        }
    }

    public boolean isPreferredSizeSet() {
        return this.isPreferredWidthSet() && this.isPreferredHeightSet();
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.setWidthLimits(minimumWidth, this.getMaximumWidth());
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.setWidthLimits(this.getMinimumWidth(), maximumWidth);
    }

    public Limits getWidthLimits() {
        return new Limits(this.minimumWidth, this.maximumWidth);
    }

    public void setWidthLimits(int minimumWidth, int maximumWidth) {
        int previousMinimumWidth = this.minimumWidth;
        int previousMaximumWidth = this.maximumWidth;
        if (previousMinimumWidth != minimumWidth || previousMaximumWidth != maximumWidth) {
            if (minimumWidth < 0) {
                throw new IllegalArgumentException("minimumWidth is negative.");
            }
            if (minimumWidth > maximumWidth) {
                throw new IllegalArgumentException("minimumWidth is greater than maximumWidth.");
            }
            this.minimumWidth = minimumWidth;
            this.maximumWidth = maximumWidth;
            this.invalidate();
            this.componentListeners.widthLimitsChanged(this, previousMinimumWidth, previousMaximumWidth);
        }
    }

    public final void setWidthLimits(Limits widthLimits) {
        if (widthLimits == null) {
            throw new IllegalArgumentException("widthLimits is null.");
        }
        this.setWidthLimits(widthLimits.minimum, widthLimits.maximum);
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.setHeightLimits(minimumHeight, this.getMaximumHeight());
    }

    public int getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setMaximumHeight(int maximumHeight) {
        this.setHeightLimits(this.getMinimumHeight(), maximumHeight);
    }

    public Limits getHeightLimits() {
        return new Limits(this.minimumHeight, this.maximumHeight);
    }

    public void setHeightLimits(int minimumHeight, int maximumHeight) {
        int previousMinimumHeight = this.minimumHeight;
        int previousMaximumHeight = this.maximumHeight;
        if (previousMinimumHeight != minimumHeight || previousMaximumHeight != maximumHeight) {
            if (minimumHeight < 0) {
                throw new IllegalArgumentException("minimumHeight is negative.");
            }
            if (minimumHeight > maximumHeight) {
                throw new IllegalArgumentException("minimumHeight is greater than maximumHeight.");
            }
            this.minimumHeight = minimumHeight;
            this.maximumHeight = maximumHeight;
            this.invalidate();
            this.componentListeners.heightLimitsChanged(this, previousMinimumHeight, previousMaximumHeight);
        }
    }

    public final void setHeightLimits(Limits heightLimits) {
        if (heightLimits == null) {
            throw new IllegalArgumentException("heightLimits is null.");
        }
        this.setHeightLimits(heightLimits.minimum, heightLimits.maximum);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    public void setLocation(int x, int y) {
        int previousX = this.x;
        int previousY = this.y;
        if (previousX != x || previousY != y) {
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.x = x;
            this.y = y;
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.componentListeners.locationChanged(this, previousX, previousY);
        }
    }

    public final void setLocation(Point location) {
        if (location == null) {
            throw new IllegalArgumentException("location cannot be null.");
        }
        this.setLocation(location.x, location.y);
    }

    @Override
    public int getBaseline() {
        if (this.baseline == -1) {
            this.baseline = this.skin.getBaseline();
        }
        return this.baseline;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.skin.getBaseline(width, height);
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.getWidth(), this.getHeight());
    }

    public Bounds getDecoratedBounds() {
        Bounds decoratedBounds = new Bounds(0, 0, this.getWidth(), this.getHeight());
        for (Decorator decorator : this.decorators) {
            decoratedBounds = decoratedBounds.union(decorator.getBounds(this));
        }
        return new Bounds(decoratedBounds.x + this.x, decoratedBounds.y + this.y, decoratedBounds.width, decoratedBounds.height);
    }

    public boolean contains(int xArgument, int yArgument) {
        throw new UnsupportedOperationException();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            if (!visible) {
                if (this.isFocused()) {
                    Component.clearFocus();
                }
                if (this.isMouseOver()) {
                    this.mouseOut();
                }
            }
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.visible = visible;
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            if (visible && !this.valid) {
                this.validate();
            }
            if (this.parent != null) {
                this.parent.invalidate();
            }
            this.componentListeners.visibleChanged(this);
        }
    }

    public DecoratorSequence getDecorators() {
        return this.decoratorSequence;
    }

    public Point mapPointToAncestor(Container ancestor, int xArgument, int yArgument) {
        if (ancestor == null) {
            throw new IllegalArgumentException("ancestor is null");
        }
        int xArgumentMutable = xArgument;
        int yArgumentMutable = yArgument;
        Point coordinates = null;
        Component component = this;
        while (component != null && coordinates == null) {
            if (component == ancestor) {
                coordinates = new Point(xArgumentMutable, yArgumentMutable);
                continue;
            }
            xArgumentMutable += component.x;
            yArgumentMutable += component.y;
            component = component.getParent();
        }
        return coordinates;
    }

    public Point mapPointToAncestor(Container ancestor, Point location) {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        return this.mapPointToAncestor(ancestor, location.x, location.y);
    }

    public Point mapPointFromAncestor(Container ancestor, int xArgument, int yArgument) {
        if (ancestor == null) {
            throw new IllegalArgumentException("ancestor is null");
        }
        int xArgumentMutable = xArgument;
        int yArgumentMutable = yArgument;
        Point coordinates = null;
        Component component = this;
        while (component != null && coordinates == null) {
            if (component == ancestor) {
                coordinates = new Point(xArgumentMutable, yArgumentMutable);
                continue;
            }
            xArgumentMutable -= component.x;
            yArgumentMutable -= component.y;
            component = component.getParent();
        }
        return coordinates;
    }

    public Point mapPointFromAncestor(Container ancestor, Point location) {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        return this.mapPointFromAncestor(ancestor, location.x, location.y);
    }

    public boolean isShowing() {
        Component component;
        for (component = this; component != null && component.isVisible() && !(component instanceof Display); component = component.getParent()) {
        }
        return component != null && component.isVisible();
    }

    public Bounds getVisibleArea() {
        return this.getVisibleArea(0, 0, this.getWidth(), this.getHeight());
    }

    public Bounds getVisibleArea(Bounds area) {
        if (area == null) {
            throw new IllegalArgumentException("area is null.");
        }
        return this.getVisibleArea(area.x, area.y, area.width, area.height);
    }

    public Bounds getVisibleArea(int xArgument, int yArgument, int width, int height) {
        Bounds visibleArea = null;
        int top = yArgument;
        int left = xArgument;
        int bottom = yArgument + height - 1;
        int right = xArgument + width - 1;
        int xOffset = 0;
        int yOffset = 0;
        for (Component component = this; component != null && component.isVisible(); component = component.getParent()) {
            int minTop = 0;
            int minLeft = 0;
            int maxBottom = component.getHeight() - 1;
            int maxRight = component.getWidth() - 1;
            if (component instanceof Viewport) {
                Viewport viewport = (Viewport)component;
                Bounds bounds = viewport.getViewportBounds();
                minTop = bounds.y;
                minLeft = bounds.x;
                maxBottom = bounds.y + bounds.height - 1;
                maxRight = bounds.x + bounds.width - 1;
            }
            top = component.y + Math.max(top, minTop);
            left = component.x + Math.max(left, minLeft);
            bottom = component.y + Math.max(Math.min(bottom, maxBottom), -1);
            right = component.x + Math.max(Math.min(right, maxRight), -1);
            xOffset += component.x;
            yOffset += component.y;
            if (!(component instanceof Display)) continue;
            visibleArea = new Bounds(left - xOffset, top - yOffset, right - left + 1, bottom - top + 1);
        }
        return visibleArea;
    }

    public void scrollAreaToVisible(Bounds area) {
        if (area == null) {
            throw new IllegalArgumentException("area is null.");
        }
        this.scrollAreaToVisible(area.x, area.y, area.width, area.height);
    }

    public void scrollAreaToVisible(int xArgument, int yArgument, int width, int height) {
        int xArgumentMutable = xArgument;
        int yArgumentMutable = yArgument;
        int widthMutable = width;
        int heightMutable = height;
        for (Component component = this; component != null; component = component.getParent()) {
            if (component instanceof Viewport) {
                Viewport viewport = (Viewport)component;
                Component view = viewport.getView();
                try {
                    Bounds viewportBounds = viewport.getViewportBounds();
                    int deltaX = 0;
                    int leftDisplacement = xArgumentMutable - viewportBounds.x;
                    int rightDisplacement = xArgumentMutable + widthMutable - (viewportBounds.x + viewportBounds.width);
                    if ((leftDisplacement & rightDisplacement) < 0) {
                        deltaX = Math.max(leftDisplacement, rightDisplacement);
                    } else if ((leftDisplacement | rightDisplacement) > 0) {
                        deltaX = Math.min(leftDisplacement, rightDisplacement);
                    }
                    if (deltaX != 0) {
                        int viewWidth = view == null ? 0 : view.getWidth();
                        int scrollLeft = viewport.getScrollLeft();
                        scrollLeft = Math.min(Math.max(scrollLeft + deltaX, 0), Math.max(viewWidth - viewportBounds.width, 0));
                        viewport.setScrollLeft(scrollLeft);
                        xArgumentMutable -= deltaX;
                    }
                    xArgumentMutable = Math.max(xArgumentMutable, viewportBounds.x);
                    widthMutable = Math.min(widthMutable, Math.max(viewportBounds.width - (xArgumentMutable - viewportBounds.x), 0));
                    int deltaY = 0;
                    int topDisplacement = yArgumentMutable - viewportBounds.y;
                    int bottomDisplacement = yArgumentMutable + heightMutable - (viewportBounds.y + viewportBounds.height);
                    if ((topDisplacement & bottomDisplacement) < 0) {
                        deltaY = Math.max(topDisplacement, bottomDisplacement);
                    } else if ((topDisplacement | bottomDisplacement) > 0) {
                        deltaY = Math.min(topDisplacement, bottomDisplacement);
                    }
                    if (deltaY != 0) {
                        int viewHeight = view == null ? 0 : view.getHeight();
                        int scrollTop = viewport.getScrollTop();
                        scrollTop = Math.min(Math.max(scrollTop + deltaY, 0), Math.max(viewHeight - viewportBounds.height, 0));
                        viewport.setScrollTop(scrollTop);
                        yArgumentMutable -= deltaY;
                    }
                    yArgumentMutable = Math.max(yArgumentMutable, viewportBounds.y);
                    heightMutable = Math.min(heightMutable, Math.max(viewportBounds.height - (yArgumentMutable - viewportBounds.y), 0));
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            xArgumentMutable += component.x;
            yArgumentMutable += component.y;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        Container.assertEventDispatchThread(this);
        this.valid = false;
        this.preferredSize = null;
        this.baseline = -1;
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    public void validate() {
        if (!this.valid && this.visible) {
            this.layout();
            this.valid = true;
        }
    }

    protected void layout() {
        this.skin.layout();
    }

    public final void repaint() {
        this.repaint(false);
    }

    public final void repaint(boolean immediate) {
        this.repaint(0, 0, this.getWidth(), this.getHeight(), immediate);
    }

    public final void repaint(Bounds area) {
        this.repaint(area, false);
    }

    public final void repaint(Bounds area, boolean immediate) {
        if (area == null) {
            throw new IllegalArgumentException("area is null.");
        }
        this.repaint(area.x, area.y, area.width, area.height, immediate);
    }

    public final void repaint(int xArgument, int yArgument, int width, int height) {
        this.repaint(xArgument, yArgument, width, height, false);
    }

    public void repaint(int xArgument, int yArgument, int width, int height, boolean immediate) {
        Container.assertEventDispatchThread(this);
        if (this.parent != null) {
            int xArgumentMutable = xArgument;
            int yArgumentMutable = yArgument;
            int widthMutable = width;
            int heightMutable = height;
            int top = yArgumentMutable;
            int left = xArgumentMutable;
            int bottom = top + heightMutable - 1;
            int right = left + widthMutable - 1;
            xArgumentMutable = Math.max(left, 0);
            yArgumentMutable = Math.max(top, 0);
            widthMutable = Math.min(right, this.getWidth() - 1) - xArgumentMutable + 1;
            heightMutable = Math.min(bottom, this.getHeight() - 1) - yArgumentMutable + 1;
            if (widthMutable > 0 && heightMutable > 0) {
                this.parent.repaint(xArgumentMutable + this.x, yArgumentMutable + this.y, widthMutable, heightMutable, immediate);
                for (Decorator decorator : this.decorators) {
                    AffineTransform transform = decorator.getTransform(this);
                    if (transform.isIdentity()) continue;
                    Rectangle area = new Rectangle(xArgumentMutable, yArgumentMutable, widthMutable, heightMutable);
                    Shape transformedShape = transform.createTransformedShape(area);
                    Bounds tranformedBounds = new Bounds(transformedShape.getBounds());
                    tranformedBounds = tranformedBounds.intersect(decorator.getBounds(this));
                    this.parent.repaint(tranformedBounds.x + this.x, tranformedBounds.y + this.y, tranformedBounds.width, tranformedBounds.height, immediate);
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        this.skin.paint(graphics);
    }

    public Graphics2D getGraphics() {
        Component component;
        Graphics2D graphics = null;
        int xLocal = 0;
        int yLocal = 0;
        for (component = this; component != null && component.isVisible() && !(component instanceof Display); component = component.getParent()) {
            xLocal += component.x;
            yLocal += component.y;
        }
        if (component != null && component.isVisible()) {
            Display display = (Display)component;
            graphics = (Graphics2D)display.getDisplayHost().getGraphics();
            double scale = display.getDisplayHost().getScale();
            if (scale != 1.0) {
                graphics.scale(scale, scale);
            }
            graphics.translate(xLocal, yLocal);
            graphics.clipRect(0, 0, this.getWidth(), this.getHeight());
        }
        return graphics;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            if (!enabled) {
                if (this.isFocused()) {
                    Component.clearFocus();
                }
                if (this.isMouseOver()) {
                    this.mouseOut();
                }
            }
            this.enabled = enabled;
            this.componentStateListeners.enabledChanged(this);
        }
    }

    public boolean isBlocked() {
        boolean blocked = false;
        for (Component component = this; component != null && !blocked; component = component.getParent()) {
            blocked = !component.isEnabled();
        }
        return blocked;
    }

    public boolean isMouseOver() {
        return this.mouseLocation != null;
    }

    public Point getMouseLocation() {
        return this.mouseLocation;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        Cursor previousCursor = this.cursor;
        if (previousCursor != cursor) {
            this.cursor = cursor;
            if (this.isMouseOver()) {
                Mouse.setCursor(this);
            }
            this.componentListeners.cursorChanged(this, previousCursor);
        }
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltipText) {
        String previousTooltipText = this.tooltipText;
        if (previousTooltipText != tooltipText) {
            this.tooltipText = tooltipText;
            this.componentListeners.tooltipTextChanged(this, previousTooltipText);
        }
    }

    public int getTooltipDelay() {
        return this.tooltipDelay;
    }

    public void setTooltipDelay(int tooltipDelay) {
        int previousTooltipDelay = this.tooltipDelay;
        if (previousTooltipDelay != tooltipDelay) {
            this.tooltipDelay = tooltipDelay;
            this.componentListeners.tooltipDelayChanged(this, previousTooltipDelay);
        }
    }

    public boolean getTooltipWrapText() {
        return this.tooltipWrapText;
    }

    public void setTooltipWrapText(boolean tooltipWrapText) {
        boolean previousTooltipWrapText = this.tooltipWrapText;
        if (previousTooltipWrapText != tooltipWrapText) {
            this.tooltipWrapText = tooltipWrapText;
        }
    }

    public boolean isOpaque() {
        return this.skin.isOpaque();
    }

    public boolean isFocusable() {
        boolean focusable = this.skin.isFocusable();
        if (focusable) {
            Component component;
            for (component = this; focusable && component != null && !(component instanceof Window); component = component.getParent(), focusable &= component != null) {
                focusable = component.isVisible() && this.isEnabled();
            }
            if (focusable) {
                Window window = (Window)component;
                focusable = window != null ? window.isVisible() && window.isEnabled() && window.isOpen() && !window.isClosing() : false;
            }
        }
        return focusable;
    }

    public boolean isFocused() {
        return focusedComponent == this;
    }

    protected void setFocused(boolean focused, Component obverseComponent) {
        if (focused) {
            this.parent.descendantGainedFocus(this, obverseComponent);
        } else {
            this.parent.descendantLostFocus(this);
        }
        this.componentStateListeners.focusedChanged(this, obverseComponent);
    }

    public boolean requestFocus() {
        if (this.isFocusable()) {
            Component.setFocusedComponent(this);
            ApplicationContext.DisplayHost displayHost = this.getDisplay().getDisplayHost();
            if (!displayHost.isFocusOwner()) {
                displayHost.requestFocusInWindow();
            }
        }
        return this.isFocused();
    }

    public Component transferFocus(FocusTraversalDirection direction) {
        Component component = null;
        Container parentLocal = this.getParent();
        if (parentLocal != null) {
            component = parentLocal.transferFocus(this, direction);
        }
        return component;
    }

    public static Component getFocusedComponent() {
        return focusedComponent;
    }

    private static void setFocusedComponent(Component focusedComponent) {
        Component previousFocusedComponent = Component.focusedComponent;
        if (previousFocusedComponent != focusedComponent) {
            Component.focusedComponent = focusedComponent;
            if (previousFocusedComponent != null) {
                previousFocusedComponent.setFocused(false, focusedComponent);
            }
            if (focusedComponent != null) {
                focusedComponent.setFocused(true, previousFocusedComponent);
            }
            componentClassListeners.focusedComponentChanged(previousFocusedComponent);
        }
    }

    public static void clearFocus() {
        Component.setFocusedComponent(null);
    }

    public void load(Object context) {
    }

    public void store(Object context) {
    }

    public void clear() {
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public void setDragSource(DragSource dragSource) {
        DragSource previousDragSource = this.dragSource;
        if (previousDragSource != dragSource) {
            this.dragSource = dragSource;
            this.componentListeners.dragSourceChanged(this, previousDragSource);
        }
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public void setDropTarget(DropTarget dropTarget) {
        DropTarget previousDropTarget = this.dropTarget;
        if (previousDropTarget != dropTarget) {
            this.dropTarget = dropTarget;
            this.componentListeners.dropTargetChanged(this, previousDropTarget);
        }
    }

    public MenuHandler getMenuHandler() {
        return this.menuHandler;
    }

    public void setMenuHandler(MenuHandler menuHandler) {
        MenuHandler previousMenuHandler = this.menuHandler;
        if (previousMenuHandler != menuHandler) {
            this.menuHandler = menuHandler;
            this.componentListeners.menuHandlerChanged(this, previousMenuHandler);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String previousName = this.name;
        if (previousName != name) {
            this.name = name;
            this.componentListeners.nameChanged(this, previousName);
        }
    }

    public final StyleDictionary getStyles() {
        return this.styleDictionary;
    }

    public void setStyles(Map<String, ?> styles) {
        if (styles == null) {
            throw new IllegalArgumentException("styles is null.");
        }
        for (String key : styles) {
            this.getStyles().put(key, styles.get((Object)key));
        }
    }

    public void setStyles(String styles) throws SerializationException {
        if (styles == null) {
            throw new IllegalArgumentException("styles is null.");
        }
        this.setStyles(JSONSerializer.parseMap((String)styles));
    }

    public static Map<Class<? extends Component>, Map<String, ?>> getTypedStyles() {
        return typedStyles;
    }

    public static Map<String, Map<String, ?>> getNamedStyles() {
        return namedStyles;
    }

    public void setStyleName(String styleName) {
        if (styleName == null) {
            throw new IllegalArgumentException();
        }
        Map stylesLocal = (Map)namedStyles.get((Object)styleName);
        if (stylesLocal == null) {
            System.err.println("Named style \"" + styleName + "\" does not exist.");
        } else {
            this.setStyles(stylesLocal);
        }
    }

    public void setStyleNames(Sequence<String> styleNames) {
        if (styleNames == null) {
            throw new IllegalArgumentException();
        }
        int n = styleNames.getLength();
        for (int i = 0; i < n; ++i) {
            this.setStyleName((String)styleNames.get(i));
        }
    }

    public void setStyleNames(String styleNames) {
        if (styleNames == null) {
            throw new IllegalArgumentException();
        }
        String[] styleNameArray = styleNames.split(",");
        for (int i = 0; i < styleNameArray.length; ++i) {
            String styleName = styleNameArray[i];
            this.setStyleName(styleName.trim());
        }
    }

    public UserDataDictionary getUserData() {
        return this.userDataDictionary;
    }

    public <T extends Enum<T>> Object getAttribute(T key) {
        Object attribute = null;
        if (this.attributes != null) {
            attribute = this.attributes.get(key);
        }
        return attribute;
    }

    public <T extends Enum<T>> Object setAttribute(T key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        Object previousValue = value != null ? this.attributes.put(key, value) : this.attributes.remove(key);
        return previousValue;
    }

    public void reenterMouse() {
        if (this.isMouseOver()) {
            this.mouseOut();
            Display display = this.getDisplay();
            Point location = display.getMouseLocation();
            location = this.mapPointFromAncestor(display, this.x, this.y);
            this.mouseMove(location.x, location.y);
        }
    }

    protected boolean mouseMove(int xArgument, int yArgument) {
        boolean consumed = false;
        if (this.isEnabled()) {
            this.mouseLocation = new Point(xArgument, yArgument);
            if (this.triggerTooltipCallback != null) {
                this.triggerTooltipCallback.cancel();
                this.triggerTooltipCallback = null;
            }
            this.triggerTooltipCallback = ApplicationContext.scheduleCallback(new Runnable(){

                @Override
                public void run() {
                    Point mouseLocationLocal = Component.this.getMouseLocation();
                    if (mouseLocationLocal != null) {
                        Component.this.componentTooltipListeners.tooltipTriggered(Component.this, mouseLocationLocal.x, mouseLocationLocal.y);
                    }
                }
            }, this.tooltipDelay);
            consumed = this.componentMouseListeners.mouseMove(this, xArgument, yArgument);
        }
        return consumed;
    }

    protected void mouseOver() {
        if (this.isEnabled()) {
            this.mouseLocation = new Point(-1, -1);
            this.componentMouseListeners.mouseOver(this);
        }
    }

    protected void mouseOut() {
        if (this.isEnabled()) {
            this.mouseLocation = null;
            if (this.triggerTooltipCallback != null) {
                this.triggerTooltipCallback.cancel();
                this.triggerTooltipCallback = null;
            }
            this.componentMouseListeners.mouseOut(this);
        }
    }

    protected boolean mouseDown(Mouse.Button button, int xArgument, int yArgument) {
        boolean consumed = false;
        if (this.isEnabled()) {
            if (this.triggerTooltipCallback != null) {
                this.triggerTooltipCallback.cancel();
                this.triggerTooltipCallback = null;
            }
            consumed = this.componentMouseButtonListeners.mouseDown(this, button, xArgument, yArgument);
        }
        return consumed;
    }

    protected boolean mouseUp(Mouse.Button button, int xArgument, int yArgument) {
        boolean consumed = false;
        if (this.isEnabled()) {
            consumed = this.componentMouseButtonListeners.mouseUp(this, button, xArgument, yArgument);
        }
        return consumed;
    }

    protected boolean mouseClick(Mouse.Button button, int xArgument, int yArgument, int count) {
        boolean consumed = false;
        if (this.isEnabled()) {
            consumed = this.componentMouseButtonListeners.mouseClick(this, button, xArgument, yArgument, count);
        }
        return consumed;
    }

    protected boolean mouseWheel(Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int xArgument, int yArgument) {
        boolean consumed = false;
        if (this.isEnabled()) {
            consumed = this.componentMouseWheelListeners.mouseWheel(this, scrollType, scrollAmount, wheelRotation, xArgument, yArgument);
        }
        return consumed;
    }

    protected boolean keyTyped(char character) {
        boolean consumed = false;
        if (this.isEnabled() && !(consumed = this.componentKeyListeners.keyTyped(this, character)) && this.parent != null) {
            consumed = this.parent.keyTyped(character);
        }
        return consumed;
    }

    protected boolean keyPressed(int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (this.isEnabled() && !(consumed = this.componentKeyListeners.keyPressed(this, keyCode, keyLocation)) && this.parent != null) {
            consumed = this.parent.keyPressed(keyCode, keyLocation);
        }
        return consumed;
    }

    protected boolean keyReleased(int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (this.isEnabled() && !(consumed = this.componentKeyListeners.keyReleased(this, keyCode, keyLocation)) && this.parent != null) {
            consumed = this.parent.keyReleased(keyCode, keyLocation);
        }
        return consumed;
    }

    public String toString() {
        String s = this.getClass().getName();
        if (this.automationID != null) {
            s = s + "#" + this.automationID;
        }
        return s;
    }

    public ListenerList<ComponentListener> getComponentListeners() {
        return this.componentListeners;
    }

    public ListenerList<ComponentStateListener> getComponentStateListeners() {
        return this.componentStateListeners;
    }

    public ListenerList<ComponentDecoratorListener> getComponentDecoratorListeners() {
        return this.componentDecoratorListeners;
    }

    public ListenerList<ComponentStyleListener> getComponentStyleListeners() {
        return this.componentStyleListeners;
    }

    public ListenerList<ComponentMouseListener> getComponentMouseListeners() {
        return this.componentMouseListeners;
    }

    public ListenerList<ComponentMouseButtonListener> getComponentMouseButtonListeners() {
        return this.componentMouseButtonListeners;
    }

    public ListenerList<ComponentMouseWheelListener> getComponentMouseWheelListeners() {
        return this.componentMouseWheelListeners;
    }

    public ListenerList<ComponentKeyListener> getComponentKeyListeners() {
        return this.componentKeyListeners;
    }

    public ListenerList<ComponentTooltipListener> getComponentTooltipListeners() {
        return this.componentTooltipListeners;
    }

    public ListenerList<ComponentDataListener> getComponentDataListeners() {
        return this.componentDataListeners;
    }

    public static ListenerList<ComponentClassListener> getComponentClassListeners() {
        return componentClassListeners;
    }

    protected static final void indexBoundsCheck(String indexName, int index, int min, int max) throws IndexOutOfBoundsException {
        if (max < min) {
            throw new IllegalArgumentException("max (" + max + ") < " + "min (" + min + ")");
        }
        if (index < min) {
            throw new IndexOutOfBoundsException(indexName + ": index (" + index + ") < min (" + min + ")");
        }
        if (index > max) {
            throw new IndexOutOfBoundsException(indexName + ": index (" + index + ") > max (" + max + ")");
        }
    }

    private static class ComponentClassListenerList
    extends WTKListenerList<ComponentClassListener>
    implements ComponentClassListener {
        private ComponentClassListenerList() {
        }

        @Override
        public void focusedComponentChanged(Component previousFocusedComponent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentClassListener listener = (ComponentClassListener)i$.next();
                listener.focusedComponentChanged(previousFocusedComponent);
            }
        }
    }

    private static class ComponentDataListenerList
    extends WTKListenerList<ComponentDataListener>
    implements ComponentDataListener {
        private ComponentDataListenerList() {
        }

        @Override
        public void valueAdded(Component component, String key) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentDataListener listener = (ComponentDataListener)i$.next();
                listener.valueAdded(component, key);
            }
        }

        @Override
        public void valueUpdated(Component component, String key, Object previousValue) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentDataListener listener = (ComponentDataListener)i$.next();
                listener.valueUpdated(component, key, previousValue);
            }
        }

        @Override
        public void valueRemoved(Component component, String key, Object value) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentDataListener listener = (ComponentDataListener)i$.next();
                listener.valueRemoved(component, key, value);
            }
        }
    }

    private static class ComponentTooltipListenerList
    extends WTKListenerList<ComponentTooltipListener>
    implements ComponentTooltipListener {
        private ComponentTooltipListenerList() {
        }

        @Override
        public void tooltipTriggered(Component component, int x, int y) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentTooltipListener listener = (ComponentTooltipListener)i$.next();
                listener.tooltipTriggered(component, x, y);
            }
        }
    }

    private static class ComponentKeyListenerList
    extends WTKListenerList<ComponentKeyListener>
    implements ComponentKeyListener {
        private ComponentKeyListenerList() {
        }

        @Override
        public boolean keyTyped(Component component, char character) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentKeyListener listener = (ComponentKeyListener)i$.next();
                consumed |= listener.keyTyped(component, character);
            }
            return consumed;
        }

        @Override
        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentKeyListener listener = (ComponentKeyListener)i$.next();
                consumed |= listener.keyPressed(component, keyCode, keyLocation);
            }
            return consumed;
        }

        @Override
        public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentKeyListener listener = (ComponentKeyListener)i$.next();
                consumed |= listener.keyReleased(component, keyCode, keyLocation);
            }
            return consumed;
        }
    }

    private static class ComponentMouseWheelListenerList
    extends WTKListenerList<ComponentMouseWheelListener>
    implements ComponentMouseWheelListener {
        private ComponentMouseWheelListenerList() {
        }

        @Override
        public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentMouseWheelListener listener = (ComponentMouseWheelListener)i$.next();
                consumed |= listener.mouseWheel(component, scrollType, scrollAmount, wheelRotation, x, y);
            }
            return consumed;
        }
    }

    private static class ComponentMouseButtonListenerList
    extends WTKListenerList<ComponentMouseButtonListener>
    implements ComponentMouseButtonListener {
        private ComponentMouseButtonListenerList() {
        }

        @Override
        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentMouseButtonListener listener = (ComponentMouseButtonListener)i$.next();
                consumed |= listener.mouseDown(component, button, x, y);
            }
            return consumed;
        }

        @Override
        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentMouseButtonListener listener = (ComponentMouseButtonListener)i$.next();
                consumed |= listener.mouseUp(component, button, x, y);
            }
            return consumed;
        }

        @Override
        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentMouseButtonListener listener = (ComponentMouseButtonListener)i$.next();
                consumed |= listener.mouseClick(component, button, x, y, count);
            }
            return consumed;
        }
    }

    private static class ComponentMouseListenerList
    extends WTKListenerList<ComponentMouseListener>
    implements ComponentMouseListener {
        private ComponentMouseListenerList() {
        }

        @Override
        public boolean mouseMove(Component component, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentMouseListener listener = (ComponentMouseListener)i$.next();
                consumed |= listener.mouseMove(component, x, y);
            }
            return consumed;
        }

        @Override
        public void mouseOver(Component component) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentMouseListener listener = (ComponentMouseListener)i$.next();
                listener.mouseOver(component);
            }
        }

        @Override
        public void mouseOut(Component component) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentMouseListener listener = (ComponentMouseListener)i$.next();
                listener.mouseOut(component);
            }
        }
    }

    private static class ComponentStyleListenerList
    extends WTKListenerList<ComponentStyleListener>
    implements ComponentStyleListener {
        private ComponentStyleListenerList() {
        }

        @Override
        public void styleUpdated(Component component, String styleKey, Object previousValue) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentStyleListener listener = (ComponentStyleListener)i$.next();
                listener.styleUpdated(component, styleKey, previousValue);
            }
        }
    }

    private static class ComponentDecoratorListenerList
    extends WTKListenerList<ComponentDecoratorListener>
    implements ComponentDecoratorListener {
        private ComponentDecoratorListenerList() {
        }

        @Override
        public void decoratorInserted(Component component, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentDecoratorListener listener = (ComponentDecoratorListener)i$.next();
                listener.decoratorInserted(component, index);
            }
        }

        @Override
        public void decoratorUpdated(Component component, int index, Decorator previousDecorator) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentDecoratorListener listener = (ComponentDecoratorListener)i$.next();
                listener.decoratorUpdated(component, index, previousDecorator);
            }
        }

        @Override
        public void decoratorsRemoved(Component component, int index, Sequence<Decorator> decorators) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentDecoratorListener listener = (ComponentDecoratorListener)i$.next();
                listener.decoratorsRemoved(component, index, decorators);
            }
        }
    }

    private static class ComponentStateListenerList
    extends WTKListenerList<ComponentStateListener>
    implements ComponentStateListener {
        private ComponentStateListenerList() {
        }

        @Override
        public void enabledChanged(Component component) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentStateListener listener = (ComponentStateListener)i$.next();
                listener.enabledChanged(component);
            }
        }

        @Override
        public void focusedChanged(Component component, Component obverseComponent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentStateListener listener = (ComponentStateListener)i$.next();
                listener.focusedChanged(component, obverseComponent);
            }
        }
    }

    private static class ComponentListenerList
    extends WTKListenerList<ComponentListener>
    implements ComponentListener {
        private ComponentListenerList() {
        }

        @Override
        public void parentChanged(Component component, Container previousParent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.parentChanged(component, previousParent);
            }
        }

        @Override
        public void sizeChanged(Component component, int previousWidth, int previousHeight) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.sizeChanged(component, previousWidth, previousHeight);
            }
        }

        @Override
        public void preferredSizeChanged(Component component, int previousPreferredWidth, int previousPreferredHeight) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.preferredSizeChanged(component, previousPreferredWidth, previousPreferredHeight);
            }
        }

        @Override
        public void widthLimitsChanged(Component component, int previousMinimumWidth, int previousMaximumWidth) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.widthLimitsChanged(component, previousMinimumWidth, previousMaximumWidth);
            }
        }

        @Override
        public void heightLimitsChanged(Component component, int previousMinimumHeight, int previousMaximumHeight) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.heightLimitsChanged(component, previousMinimumHeight, previousMaximumHeight);
            }
        }

        @Override
        public void locationChanged(Component component, int previousX, int previousY) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.locationChanged(component, previousX, previousY);
            }
        }

        @Override
        public void visibleChanged(Component component) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.visibleChanged(component);
            }
        }

        @Override
        public void cursorChanged(Component component, Cursor previousCursor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.cursorChanged(component, previousCursor);
            }
        }

        @Override
        public void tooltipTextChanged(Component component, String previousTooltipText) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.tooltipTextChanged(component, previousTooltipText);
            }
        }

        @Override
        public void tooltipDelayChanged(Component component, int previousTooltipDelay) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.tooltipDelayChanged(component, previousTooltipDelay);
            }
        }

        @Override
        public void dragSourceChanged(Component component, DragSource previousDragSource) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.dragSourceChanged(component, previousDragSource);
            }
        }

        @Override
        public void dropTargetChanged(Component component, DropTarget previousDropTarget) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.dropTargetChanged(component, previousDropTarget);
            }
        }

        @Override
        public void menuHandlerChanged(Component component, MenuHandler previousMenuHandler) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.menuHandlerChanged(component, previousMenuHandler);
            }
        }

        @Override
        public void nameChanged(Component component, String previousName) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ComponentListener listener = (ComponentListener)i$.next();
                listener.nameChanged(component, previousName);
            }
        }
    }

    public final class DecoratorSequence
    implements Sequence<Decorator>,
    Iterable<Decorator> {
        public int add(Decorator decorator) {
            int index = this.getLength();
            this.insert(decorator, index);
            return index;
        }

        public void insert(Decorator decorator, int index) {
            if (decorator == null) {
                throw new IllegalArgumentException("decorator is null");
            }
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Component.this.decorators.insert((Object)decorator, index);
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Component.this.componentDecoratorListeners.decoratorInserted(Component.this, index);
        }

        public Decorator update(int index, Decorator decorator) {
            if (decorator == null) {
                throw new IllegalArgumentException("decorator is null.");
            }
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Decorator previousDecorator = (Decorator)Component.this.decorators.update(index, (Object)decorator);
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Component.this.componentDecoratorListeners.decoratorUpdated(Component.this, index, previousDecorator);
            return previousDecorator;
        }

        public int remove(Decorator decorator) {
            int index = this.indexOf(decorator);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Decorator> remove(int index, int count) {
            if (count > 0 && Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Sequence removed = Component.this.decorators.remove(index, count);
            if (count > 0) {
                if (Component.this.parent != null) {
                    Component.this.parent.repaint(Component.this.getDecoratedBounds());
                }
                Component.this.componentDecoratorListeners.decoratorsRemoved(Component.this, index, (Sequence<Decorator>)removed);
            }
            return removed;
        }

        public Sequence<Decorator> removeAll() {
            return this.remove(0, this.getLength());
        }

        public Decorator get(int index) {
            return (Decorator)Component.this.decorators.get(index);
        }

        public int indexOf(Decorator decorator) {
            return Component.this.decorators.indexOf((Object)decorator);
        }

        public int getLength() {
            return Component.this.decorators.getLength();
        }

        @Override
        public Iterator<Decorator> iterator() {
            return new ImmutableIterator((Iterator)Component.this.decorators.iterator());
        }
    }

    public final class UserDataDictionary
    implements Dictionary<String, Object>,
    Iterable<String> {
        private UserDataDictionary() {
        }

        public Object get(String key) {
            return Component.this.userData.get((Object)key);
        }

        public Object put(String key, Object value) {
            boolean update = Component.this.userData.containsKey((Object)key);
            Object previousValue = Component.this.userData.put((Object)key, value);
            if (update) {
                Component.this.componentDataListeners.valueUpdated(Component.this, key, previousValue);
            } else {
                Component.this.componentDataListeners.valueAdded(Component.this, key);
            }
            return previousValue;
        }

        public Object remove(String key) {
            Object previousValue;
            if (Component.this.userData.containsKey((Object)key)) {
                previousValue = Component.this.userData.remove((Object)key);
                Component.this.componentDataListeners.valueRemoved(Component.this, key, previousValue);
            } else {
                previousValue = null;
            }
            return previousValue;
        }

        public boolean containsKey(String key) {
            return Component.this.userData.containsKey((Object)key);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator(Component.this.userData.iterator());
        }
    }

    public final class StyleDictionary
    implements Dictionary<String, Object>,
    Iterable<String> {
        private StyleDictionary() {
        }

        public Object get(String key) {
            return Component.this.styles.get(key);
        }

        public Object put(String key, Object value) {
            Object previousValue = null;
            try {
                previousValue = Component.this.styles.put(key, value);
                Component.this.componentStyleListeners.styleUpdated(Component.this, key, previousValue);
            }
            catch (PropertyNotFoundException exception) {
                System.err.println("\"" + key + "\" is not a valid style for " + Component.this);
            }
            return previousValue;
        }

        public Object remove(String key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(String key) {
            return Component.this.styles.containsKey(key);
        }

        public boolean isReadOnly(String key) {
            return Component.this.styles.isReadOnly(key);
        }

        public Class<?> getType(String key) {
            return Component.this.styles.getType(key);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator(Component.this.styles.iterator());
        }
    }
}

