/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.awt.print.PrinterGraphics;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Version;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentClassListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropAction;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.LocalManifestAdapter;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.RemoteManifest;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.ShadeDecorator;

public abstract class ApplicationContext {
    protected static URL origin = null;
    protected static ArrayList<Display> displays = new ArrayList();
    protected static ArrayList<Application> applications = new ArrayList();
    private static Timer timer = null;
    private static HashMap<URI, Object> resourceCache = new HashMap();
    private static ResourceCacheDictionary resourceCacheDictionary = new ResourceCacheDictionary();
    private static Version jvmVersion = null;
    private static Version pivotVersion = null;

    public static URL getOrigin() {
        return origin;
    }

    public static ResourceCacheDictionary getResourceCache() {
        return resourceCacheDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyStylesheet(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL stylesheetLocation = classLoader.getResource(resourceName.substring(1));
        if (stylesheetLocation == null) {
            throw new RuntimeException("Unable to locate style sheet resource \"" + resourceName + "\".");
        }
        try {
            InputStream inputStream = stylesheetLocation.openStream();
            try {
                JSONSerializer serializer = new JSONSerializer();
                Map stylesheet = (Map)serializer.readObject(inputStream);
                for (String name : stylesheet) {
                    Map styles = (Map)stylesheet.get((Object)name);
                    int i = name.lastIndexOf(46) + 1;
                    if (Character.isUpperCase(name.charAt(i))) {
                        if (!name.contains(".")) {
                            name = ApplicationContext.class.getPackage().getName() + "." + name;
                        }
                        Class<?> type = null;
                        try {
                            type = Class.forName(name);
                        }
                        catch (ClassNotFoundException exception) {
                            // empty catch block
                        }
                        if (type == null || !Component.class.isAssignableFrom(type)) continue;
                        Component.getTypedStyles().put(type, (Object)styles);
                        continue;
                    }
                    Component.getNamedStyles().put((Object)name, (Object)styles);
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (SerializationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Version getJVMVersion() {
        return jvmVersion;
    }

    public static Version getPivotVersion() {
        return pivotVersion;
    }

    public static ScheduledCallback scheduleCallback(Runnable callback, long delay) {
        ScheduledCallback scheduledCallback = new ScheduledCallback(callback);
        try {
            try {
                timer.schedule((TimerTask)scheduledCallback, delay);
            }
            catch (IllegalStateException exception) {
                ApplicationContext.createTimer();
                timer.schedule((TimerTask)scheduledCallback, delay);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Unable to schedule callback: " + throwable);
        }
        return scheduledCallback;
    }

    public static ScheduledCallback scheduleRecurringCallback(Runnable callback, long period) {
        return ApplicationContext.scheduleRecurringCallback(callback, 0L, period);
    }

    public static ScheduledCallback scheduleRecurringCallback(Runnable callback, long delay, long period) {
        ScheduledCallback scheduledCallback = new ScheduledCallback(callback);
        try {
            try {
                timer.schedule((TimerTask)scheduledCallback, delay, period);
            }
            catch (IllegalStateException exception) {
                ApplicationContext.createTimer();
                timer.schedule((TimerTask)scheduledCallback, delay, period);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Unable to schedule callback: " + throwable);
        }
        return scheduledCallback;
    }

    public static QueuedCallback queueCallback(Runnable callback) {
        return ApplicationContext.queueCallback(callback, false);
    }

    public static QueuedCallback queueCallback(Runnable callback, boolean wait) {
        QueuedCallback queuedCallback;
        block6: {
            queuedCallback = new QueuedCallback(callback);
            try {
                if (wait) {
                    try {
                        EventQueue.invokeAndWait(queuedCallback);
                        break block6;
                    }
                    catch (InvocationTargetException exception) {
                        throw new RuntimeException(exception.getCause());
                    }
                    catch (InterruptedException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                EventQueue.invokeLater(queuedCallback);
            }
            catch (Throwable throwable) {
                System.err.println("Unable to queue callback: " + throwable);
            }
        }
        return queuedCallback;
    }

    protected static void createTimer() {
        timer = new Timer();
    }

    protected static void destroyTimer() {
        timer.cancel();
        timer = null;
    }

    public static List<Display> getDisplays() {
        return displays;
    }

    protected static void invalidateDisplays() {
        for (Display display : displays) {
            display.invalidate();
        }
    }

    private static DropAction getUserDropAction(InputEvent event) {
        DropAction userDropAction = event.isControlDown() && event.isShiftDown() || event.isAltDown() && event.isMetaDown() ? DropAction.LINK : (event.isControlDown() || event.isAltDown() ? DropAction.COPY : (event.isShiftDown() ? DropAction.MOVE : null));
        return userDropAction;
    }

    private static DropAction getDropAction(int nativeDropAction) {
        DropAction dropAction = null;
        switch (nativeDropAction) {
            case 1: {
                dropAction = DropAction.COPY;
                break;
            }
            case 2: {
                dropAction = DropAction.MOVE;
                break;
            }
            case 0x40000000: {
                dropAction = DropAction.LINK;
                break;
            }
        }
        return dropAction;
    }

    private static int getSupportedDropActions(int sourceActions) {
        int dropActions = 0;
        if ((sourceActions & 1) > 0) {
            dropActions |= DropAction.COPY.getMask();
        }
        if ((sourceActions & 2) > 0) {
            dropActions |= DropAction.MOVE.getMask();
        }
        if ((sourceActions & 0x40000000) > 0) {
            dropActions |= DropAction.LINK.getMask();
        }
        return dropActions;
    }

    private static int getNativeDropAction(DropAction dropAction) {
        int nativeDropAction = 0;
        if (dropAction != null) {
            switch (dropAction) {
                case COPY: {
                    nativeDropAction = 1;
                    break;
                }
                case MOVE: {
                    nativeDropAction = 2;
                    break;
                }
                case LINK: {
                    nativeDropAction = 0x40000000;
                    break;
                }
            }
        }
        return nativeDropAction;
    }

    private static Cursor getDropCursor(DropAction dropAction) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (dropAction != null) {
            switch (dropAction) {
                case COPY: {
                    cursor = java.awt.dnd.DragSource.DefaultCopyDrop;
                    break;
                }
                case MOVE: {
                    cursor = java.awt.dnd.DragSource.DefaultMoveDrop;
                    break;
                }
                case LINK: {
                    cursor = java.awt.dnd.DragSource.DefaultLinkDrop;
                    break;
                }
            }
        }
        return cursor;
    }

    public static void handleUncaughtException(Exception exception) {
        int n = 0;
        for (Application application : applications) {
            if (!(application instanceof Application.UncaughtExceptionHandler)) continue;
            Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)application);
            uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
            ++n;
        }
        if (n == 0) {
            Display display;
            exception.printStackTrace();
            Display display2 = display = displays.getLength() > 0 ? (Display)displays.get(0) : null;
            if (display == null) {
                return;
            }
            String message = exception.getClass().getName();
            TextArea body = null;
            String bodyText = exception.getMessage();
            if (bodyText != null && bodyText.length() > 0) {
                body = new TextArea();
                body.setText(bodyText);
                body.setEditable(false);
            }
            Alert alert = new Alert(MessageType.ERROR, message, null, body, false);
            alert.open(display);
        }
    }

    static {
        jvmVersion = Version.decode((String)System.getProperty("java.vm.version"));
        String version = ApplicationContext.class.getPackage().getImplementationVersion();
        pivotVersion = version == null ? new Version(0, 0, 0, 0) : Version.decode((String)version);
    }

    public static class QueuedCallback
    implements Runnable {
        private Runnable callback;
        private volatile boolean executed = false;
        private volatile boolean cancelled = false;

        private QueuedCallback(Runnable callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                try {
                    this.callback.run();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    for (Application application : applications) {
                        if (!(application instanceof Application.UncaughtExceptionHandler)) continue;
                        Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)application);
                        uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                    }
                }
                for (Display display : displays) {
                    display.validate();
                }
                this.executed = true;
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            return !this.executed;
        }
    }

    public static final class ScheduledCallback
    extends TimerTask {
        private Runnable callback;
        private QueuedCallback queuedCallback = null;

        private ScheduledCallback(Runnable callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            if (this.queuedCallback != null) {
                this.queuedCallback.cancel();
            }
            this.queuedCallback = ApplicationContext.queueCallback(this.callback);
        }

        @Override
        public boolean cancel() {
            if (this.queuedCallback != null) {
                this.queuedCallback.cancel();
            }
            return super.cancel();
        }
    }

    public static final class ResourceCacheDictionary
    implements Dictionary<URL, Object>,
    Iterable<URL> {
        private ResourceCacheDictionary() {
        }

        public synchronized Object get(URL key) {
            try {
                return resourceCache.get((Object)key.toURI());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }

        public synchronized Object put(URL key, Object value) {
            try {
                return resourceCache.put((Object)key.toURI(), value);
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }

        public synchronized Object remove(URL key) {
            try {
                return resourceCache.remove((Object)key.toURI());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }

        public synchronized boolean containsKey(URL key) {
            try {
                return resourceCache.containsKey((Object)key.toURI());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Iterator<URL> iterator() {
            return new Iterator<URL>(){
                private Iterator<URI> iterator = ApplicationContext.access$1300().iterator();

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public URL next() {
                    try {
                        return this.iterator.next().toURL();
                    }
                    catch (MalformedURLException exception) {
                        throw new RuntimeException(exception);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public synchronized int getCount() {
            return resourceCache.getCount();
        }
    }

    public static class DisplayHost
    extends java.awt.Component {
        private static final long serialVersionUID = -815713849595314026L;
        private transient Display display = new Display(this);
        private AWTEvent currentAWTEvent = null;
        private Component focusedComponent = null;
        private Point dragLocation = null;
        private Component dragDescendant = null;
        private transient Manifest dragManifest = null;
        private DropAction userDropAction = null;
        private Component dropDescendant = null;
        private MenuPopup menuPopup = null;
        private double scale = 1.0;
        private boolean debugPaint = false;
        private boolean bufferedImagePaintEnabled = true;
        private BufferedImage bufferedImage = null;
        private GraphicsConfiguration bufferedImageGC = null;
        private boolean volatileImagePaintEnabled = true;
        private VolatileImage volatileImage = null;
        private GraphicsConfiguration volatileImageGC = null;
        private Random random = null;
        private transient DropTargetListener dropTargetListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent event) {
                if (DisplayHost.this.dragDescendant != null) {
                    throw new IllegalStateException("Local drag already in progress.");
                }
                java.awt.Point location = event.getLocation();
                DisplayHost.this.dragLocation = new Point(location.x, location.y);
                DisplayHost.this.dragManifest = new RemoteManifest(event.getTransferable());
                DisplayHost.this.userDropAction = ApplicationContext.getDropAction(event.getDropAction());
                DisplayHost.this.dropDescendant = DisplayHost.this.getDropDescendant(location.x, location.y);
                DropAction dropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                    dropAction = dropTarget.dragEnter(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(event.getSourceActions()), DisplayHost.this.userDropAction);
                }
                if (dropAction == null) {
                    event.rejectDrag();
                } else {
                    event.acceptDrag(ApplicationContext.getNativeDropAction(dropAction));
                }
                DisplayHost.this.display.validate();
            }

            @Override
            public void dragExit(DropTargetEvent event) {
                DisplayHost.this.dragLocation = null;
                DisplayHost.this.dragManifest = null;
                DisplayHost.this.userDropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                    dropTarget.dragExit(DisplayHost.this.dropDescendant);
                }
                DisplayHost.this.dropDescendant = null;
                DisplayHost.this.display.validate();
            }

            @Override
            public void dragOver(DropTargetDragEvent event) {
                java.awt.Point location = event.getLocation();
                Component previousDropDescendant = DisplayHost.this.dropDescendant;
                DisplayHost.this.dropDescendant = DisplayHost.this.getDropDescendant(location.x, location.y);
                DropAction dropAction = null;
                if (previousDropDescendant == DisplayHost.this.dropDescendant) {
                    if (DisplayHost.this.dropDescendant != null) {
                        DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                        Point dropLocation = DisplayHost.this.dropDescendant.mapPointFromAncestor(DisplayHost.this.display, location.x, location.y);
                        if (dropLocation == null) {
                            dropLocation = DisplayHost.this.display.getMouseLocation();
                        }
                        if (dropLocation != null) {
                            dropAction = dropTarget.dragMove(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(event.getSourceActions()), dropLocation.x, dropLocation.y, DisplayHost.this.userDropAction);
                        }
                    }
                } else {
                    if (previousDropDescendant != null) {
                        DropTarget previousDropTarget = previousDropDescendant.getDropTarget();
                        previousDropTarget.dragExit(previousDropDescendant);
                    }
                    if (DisplayHost.this.dropDescendant != null) {
                        DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                        dropAction = dropTarget.dragEnter(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(event.getSourceActions()), DisplayHost.this.userDropAction);
                    }
                }
                DisplayHost.this.setCursor(ApplicationContext.getDropCursor(dropAction));
                if (dropAction == null) {
                    event.rejectDrag();
                } else {
                    event.acceptDrag(ApplicationContext.getNativeDropAction(dropAction));
                }
                DisplayHost.this.display.validate();
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent event) {
                DisplayHost.this.userDropAction = ApplicationContext.getDropAction(event.getDropAction());
                DropAction dropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    java.awt.Point location = event.getLocation();
                    Point dropLocation = DisplayHost.this.dropDescendant.mapPointFromAncestor(DisplayHost.this.display, location.x, location.y);
                    if (dropLocation == null) {
                        dropLocation = DisplayHost.this.display.getMouseLocation();
                    }
                    if (dropLocation != null) {
                        DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                        dropAction = dropTarget.userDropActionChange(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(event.getSourceActions()), dropLocation.x, dropLocation.y, DisplayHost.this.userDropAction);
                    }
                }
                if (dropAction == null) {
                    event.rejectDrag();
                } else {
                    event.acceptDrag(ApplicationContext.getNativeDropAction(dropAction));
                }
                DisplayHost.this.display.validate();
            }

            @Override
            public void drop(DropTargetDropEvent event) {
                java.awt.Point location = event.getLocation();
                DisplayHost.this.dropDescendant = DisplayHost.this.getDropDescendant(location.x, location.y);
                DropAction dropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    Point dropLocation = DisplayHost.this.dropDescendant.mapPointFromAncestor(DisplayHost.this.display, location.x, location.y);
                    if (dropLocation == null) {
                        dropLocation = DisplayHost.this.display.getMouseLocation();
                    }
                    DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                    int supportedDropActions = ApplicationContext.getSupportedDropActions(event.getSourceActions());
                    if (dropLocation != null && (dropAction = dropTarget.userDropActionChange(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, supportedDropActions, dropLocation.x, dropLocation.y, DisplayHost.this.userDropAction)) != null) {
                        event.acceptDrop(ApplicationContext.getNativeDropAction(dropAction));
                        dropTarget.drop(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, supportedDropActions, dropLocation.x, dropLocation.y, DisplayHost.this.userDropAction);
                    }
                }
                if (dropAction == null) {
                    event.rejectDrop();
                }
                event.dropComplete(true);
                DisplayHost.this.setCursor(Cursor.getDefaultCursor());
                DisplayHost.this.dragManifest = null;
                DisplayHost.this.dragLocation = null;
                DisplayHost.this.dropDescendant = null;
                DisplayHost.this.display.validate();
            }
        };

        public DisplayHost() {
            this.enableEvents(131133L);
            try {
                System.setProperty("sun.awt.noerasebackground", "true");
                System.setProperty("sun.awt.erasebackgroundonresize", "false");
            }
            catch (SecurityException exception) {
                // empty catch block
            }
            try {
                if (Boolean.getBoolean("org.apache.pivot.wtk.disablevolatilebuffer")) {
                    this.volatileImagePaintEnabled = false;
                }
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            try {
                this.debugPaint = Boolean.getBoolean("org.apache.pivot.wtk.debugpaint");
                if (this.debugPaint) {
                    this.random = new Random();
                }
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            try {
                boolean debugFocus = Boolean.getBoolean("org.apache.pivot.wtk.debugfocus");
                if (debugFocus) {
                    final ShadeDecorator focusDecorator = new ShadeDecorator(0.2f, Color.RED);
                    ComponentClassListener focusChangeListener = new ComponentClassListener(){

                        @Override
                        public void focusedComponentChanged(Component previousFocusedComponent) {
                            Component focusedComponentLocal;
                            if (previousFocusedComponent != null && previousFocusedComponent.getDecorators().indexOf(focusDecorator) > -1) {
                                previousFocusedComponent.getDecorators().remove(focusDecorator);
                            }
                            if ((focusedComponentLocal = Component.getFocusedComponent()) != null && focusedComponentLocal.getDecorators().indexOf(focusDecorator) == -1) {
                                focusedComponentLocal.getDecorators().add(focusDecorator);
                            }
                            System.out.println("focusedComponentChanged():\n  from = " + previousFocusedComponent + "\n  to = " + focusedComponentLocal);
                        }
                    };
                    Component.getComponentClassListeners().add((Object)focusChangeListener);
                }
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            java.awt.dnd.DropTarget dropTarget = new java.awt.dnd.DropTarget(this, this.dropTargetListener);
            this.setFocusTraversalKeysEnabled(false);
        }

        public Display getDisplay() {
            return this.display;
        }

        public AWTEvent getCurrentAWTEvent() {
            return this.currentAWTEvent;
        }

        public double getScale() {
            return this.scale;
        }

        public void setScale(double scale) {
            if (scale != this.scale) {
                this.scale = scale;
                this.display.setSize(Math.max((int)Math.ceil((double)this.getWidth() / scale), 0), Math.max((int)Math.ceil((double)this.getHeight() / scale), 0));
                this.display.repaint();
            }
        }

        public void scaleUp() {
            double newScale = this.scale < 1.0 ? 1.0 : (this.scale < 1.25 ? 1.25 : (this.scale < 1.5 ? 1.5 : (this.scale < 2.0 ? 2.0 : Math.min(Math.floor(this.scale) + 1.0, 12.0))));
            this.setScale(newScale);
        }

        public void scaleDown() {
            double newScale = this.scale <= 1.25 ? 1.0 : (this.scale <= 1.5 ? 1.25 : (this.scale <= 2.0 ? 1.5 : Math.ceil(this.scale) - 1.0));
            this.setScale(newScale);
        }

        public void setVolatileImagePaintEnabled(boolean enabled) {
            this.volatileImagePaintEnabled = enabled;
            if (enabled) {
                this.bufferedImage = null;
                this.bufferedImageGC = null;
            } else {
                this.volatileImage = null;
                this.volatileImageGC = null;
            }
        }

        public void setBufferedImagePaintEnabled(boolean enabled) {
            this.bufferedImagePaintEnabled = enabled;
            if (!enabled) {
                this.bufferedImage = null;
                this.bufferedImageGC = null;
            }
        }

        @Override
        public void repaint(int x, int y, int width, int height) {
            int xMutable = x;
            int yMutable = y;
            int widthMutable = width;
            int heightMutable = height;
            if (xMutable < 0) {
                widthMutable = Math.max(widthMutable + xMutable, 0);
                xMutable = 0;
            }
            if (yMutable < 0) {
                heightMutable = Math.max(heightMutable + yMutable, 0);
                yMutable = 0;
            }
            if (widthMutable > 0 && heightMutable > 0) {
                if (this.scale == 1.0) {
                    super.repaint(xMutable, yMutable, widthMutable, heightMutable);
                } else {
                    super.repaint((int)Math.floor((double)xMutable * this.scale), (int)Math.floor((double)yMutable * this.scale), (int)Math.ceil((double)widthMutable * this.scale) + 1, (int)Math.ceil((double)heightMutable * this.scale) + 1);
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.clipRect(0, 0, this.getWidth(), this.getHeight());
            if (graphics instanceof PrintGraphics || graphics instanceof PrinterGraphics) {
                this.print(graphics);
                return;
            }
            Rectangle clipBounds = graphics.getClipBounds();
            if (clipBounds != null && !clipBounds.isEmpty()) {
                try {
                    boolean bPaintSuccess = false;
                    if (this.volatileImagePaintEnabled) {
                        bPaintSuccess = this.paintVolatileBuffered((Graphics2D)graphics);
                    }
                    if (!bPaintSuccess && this.bufferedImagePaintEnabled) {
                        bPaintSuccess = this.paintBuffered((Graphics2D)graphics);
                    }
                    if (!bPaintSuccess) {
                        this.paintDisplay((Graphics2D)graphics);
                    }
                    if (this.debugPaint) {
                        graphics.setColor(new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256), 75));
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                }
                catch (RuntimeException exception) {
                    System.err.println("Exception thrown during paint(): " + exception);
                    throw exception;
                }
            }
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void print(Graphics graphics) {
            graphics.clipRect(0, 0, this.getWidth(), this.getHeight());
            Rectangle clipBounds = graphics.getClipBounds();
            if (clipBounds != null && !clipBounds.isEmpty()) {
                try {
                    this.paintDisplay((Graphics2D)graphics);
                }
                catch (RuntimeException exception) {
                    System.err.println("Exception thrown during print(): " + exception);
                    throw exception;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean paintBuffered(Graphics2D graphics) {
            boolean painted = false;
            GraphicsConfiguration gc = graphics.getDeviceConfiguration();
            Rectangle clipBounds = graphics.getClipBounds();
            if (this.bufferedImage == null || this.bufferedImageGC != gc || this.bufferedImage.getWidth() < clipBounds.width || this.bufferedImage.getHeight() < clipBounds.height) {
                this.bufferedImage = gc.createCompatibleImage(clipBounds.width, clipBounds.height, 1);
                this.bufferedImageGC = gc;
            }
            if (this.bufferedImage != null) {
                Graphics2D bufferedImageGraphics = (Graphics2D)this.bufferedImage.getGraphics();
                bufferedImageGraphics.setClip(0, 0, clipBounds.width, clipBounds.height);
                bufferedImageGraphics.translate(-clipBounds.x, -clipBounds.y);
                try {
                    this.paintDisplay(bufferedImageGraphics);
                    graphics.drawImage((Image)this.bufferedImage, clipBounds.x, clipBounds.y, this);
                }
                finally {
                    bufferedImageGraphics.dispose();
                }
                painted = true;
            }
            return painted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean paintVolatileBuffered(Graphics2D graphics) {
            int valid;
            boolean painted = false;
            GraphicsConfiguration gc = graphics.getDeviceConfiguration();
            Rectangle gcBounds = gc.getBounds();
            if (this.volatileImage == null || this.volatileImageGC != gc) {
                if (this.volatileImage != null) {
                    this.volatileImage.flush();
                }
                this.volatileImage = gc.createCompatibleVolatileImage(gcBounds.width, gcBounds.height, 1);
                this.volatileImageGC = gc;
            }
            if ((valid = this.volatileImage.validate(gc)) == 0 || valid == 1) {
                Rectangle clipBounds = graphics.getClipBounds();
                Graphics2D volatileImageGraphics = this.volatileImage.createGraphics();
                volatileImageGraphics.setClip(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                try {
                    this.paintDisplay(volatileImageGraphics);
                    int x2 = clipBounds.x + clipBounds.width;
                    int y2 = clipBounds.y + clipBounds.height;
                    graphics.drawImage(this.volatileImage, clipBounds.x, clipBounds.y, x2, y2, clipBounds.x, clipBounds.y, x2, y2, this);
                }
                finally {
                    volatileImageGraphics.dispose();
                }
                painted = !this.volatileImage.contentsLost();
            } else {
                this.volatileImage.flush();
                this.volatileImage = null;
            }
            return painted;
        }

        private void paintDisplay(Graphics2D graphics) {
            DragSource dragSource;
            Visual dragRepresentation;
            Decorator decorator;
            int i;
            if (this.scale != 1.0) {
                graphics.scale(this.scale, this.scale);
            }
            Graphics2D decoratedGraphics = graphics;
            Component.DecoratorSequence decorators = this.display.getDecorators();
            int n = decorators.getLength();
            for (i = n - 1; i >= 0; --i) {
                decorator = decorators.get(i);
                decoratedGraphics = decorator.prepare(this.display, decoratedGraphics);
            }
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.display.paint(graphics);
            for (i = 0; i < n; ++i) {
                decorator = decorators.get(i);
                decorator.update();
            }
            if (this.dragDescendant != null && (dragRepresentation = (dragSource = this.dragDescendant.getDragSource()).getRepresentation()) != null) {
                Point dragOffset = dragSource.getOffset();
                int tx = this.dragLocation.x - dragOffset.x;
                int ty = this.dragLocation.y - dragOffset.y;
                graphics.translate(tx, ty);
                dragRepresentation.paint(graphics);
            }
        }

        private void repaintDragRepresentation() {
            DragSource dragSource = this.dragDescendant.getDragSource();
            Visual dragRepresentation = dragSource.getRepresentation();
            if (dragRepresentation != null) {
                Point dragOffset = dragSource.getOffset();
                this.repaint(this.dragLocation.x - dragOffset.x, this.dragLocation.y - dragOffset.y, dragRepresentation.getWidth(), dragRepresentation.getHeight());
            }
        }

        private Component getDropDescendant(int x, int y) {
            Component dropDescendantLocal;
            for (dropDescendantLocal = this.display.getDescendantAt(x, y); dropDescendantLocal != null && dropDescendantLocal.getDropTarget() == null; dropDescendantLocal = dropDescendantLocal.getParent()) {
            }
            if (dropDescendantLocal != null && dropDescendantLocal.isBlocked()) {
                dropDescendantLocal = null;
            }
            return dropDescendantLocal;
        }

        private void startNativeDrag(final DragSource dragSource, final Component dragDescendantArgument, final MouseEvent mouseEvent) {
            java.awt.dnd.DragSource awtDragSource = java.awt.dnd.DragSource.getDefaultDragSource();
            final int supportedDropActions = dragSource.getSupportedDropActions();
            DragGestureRecognizer dragGestureRecognizer = new DragGestureRecognizer(java.awt.dnd.DragSource.getDefaultDragSource(), this){
                private static final long serialVersionUID = -3204487375572082596L;
                {
                    super(x0, x1);
                    this.appendEvent(mouseEvent);
                }

                @Override
                public synchronized int getSourceActions() {
                    int awtSourceActions = 0;
                    if (DropAction.COPY.isSelected(supportedDropActions)) {
                        awtSourceActions |= 1;
                    }
                    if (DropAction.MOVE.isSelected(supportedDropActions)) {
                        awtSourceActions |= 2;
                    }
                    if (DropAction.LINK.isSelected(supportedDropActions)) {
                        awtSourceActions |= 0x40000000;
                    }
                    return awtSourceActions;
                }

                @Override
                protected void registerListeners() {
                }

                @Override
                protected void unregisterListeners() {
                }
            };
            java.util.ArrayList<MouseEvent> inputEvents = new java.util.ArrayList<MouseEvent>();
            inputEvents.add(mouseEvent);
            java.awt.Point location = new java.awt.Point(mouseEvent.getX(), mouseEvent.getY());
            DragGestureEvent trigger = new DragGestureEvent(dragGestureRecognizer, 2, location, inputEvents);
            LocalManifest dragContent = dragSource.getContent();
            LocalManifestAdapter localManifestAdapter = new LocalManifestAdapter(dragContent);
            awtDragSource.startDrag(trigger, Cursor.getDefaultCursor(), null, null, localManifestAdapter, new DragSourceListener(){

                @Override
                public void dragEnter(DragSourceDragEvent event) {
                    DragSourceContext context = event.getDragSourceContext();
                    context.setCursor(ApplicationContext.getDropCursor(ApplicationContext.getDropAction(event.getDropAction())));
                }

                @Override
                public void dragExit(DragSourceEvent event) {
                    DragSourceContext context = event.getDragSourceContext();
                    context.setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void dragOver(DragSourceDragEvent event) {
                    DragSourceContext context = event.getDragSourceContext();
                    context.setCursor(ApplicationContext.getDropCursor(ApplicationContext.getDropAction(event.getDropAction())));
                }

                @Override
                public void dropActionChanged(DragSourceDragEvent event) {
                    DragSourceContext context = event.getDragSourceContext();
                    context.setCursor(ApplicationContext.getDropCursor(ApplicationContext.getDropAction(event.getDropAction())));
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent event) {
                    DragSourceContext context = event.getDragSourceContext();
                    context.setCursor(Cursor.getDefaultCursor());
                    dragSource.endDrag(dragDescendantArgument, ApplicationContext.getDropAction(event.getDropAction()));
                }
            });
        }

        @Override
        protected void processEvent(AWTEvent event) {
            this.currentAWTEvent = event;
            super.processEvent(event);
            this.currentAWTEvent = null;
            this.display.validate();
        }

        @Override
        protected void processComponentEvent(ComponentEvent event) {
            super.processComponentEvent(event);
            switch (event.getID()) {
                case 101: {
                    if (this.scale == 1.0) {
                        this.display.setSize(Math.max(this.getWidth(), 0), Math.max(this.getHeight(), 0));
                        break;
                    }
                    this.display.setSize(Math.max((int)Math.ceil((double)this.getWidth() / this.scale), 0), Math.max((int)Math.ceil((double)this.getHeight() / this.scale), 0));
                    break;
                }
            }
        }

        @Override
        protected void processFocusEvent(FocusEvent event) {
            super.processFocusEvent(event);
            switch (event.getID()) {
                case 1004: {
                    if (this.focusedComponent == null || !this.focusedComponent.isShowing() || this.focusedComponent.isBlocked()) break;
                    this.focusedComponent.requestFocus();
                    break;
                }
                case 1005: {
                    this.focusedComponent = Component.getFocusedComponent();
                    Component.clearFocus();
                    break;
                }
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            super.processMouseEvent(event);
            int x = (int)Math.round((double)event.getX() / this.scale);
            int y = (int)Math.round((double)event.getY() / this.scale);
            int mouseButtons = 0;
            int modifiersEx = event.getModifiersEx();
            if ((modifiersEx & 0x400) > 0) {
                mouseButtons |= Mouse.Button.LEFT.getMask();
            }
            if ((modifiersEx & 0x800) > 0) {
                mouseButtons |= Mouse.Button.MIDDLE.getMask();
            }
            if ((modifiersEx & 0x1000) > 0) {
                mouseButtons |= Mouse.Button.RIGHT.getMask();
            }
            Mouse.setButtons(mouseButtons);
            Mouse.Button button = null;
            switch (event.getButton()) {
                case 1: {
                    button = Mouse.Button.LEFT;
                    break;
                }
                case 2: {
                    button = Mouse.Button.MIDDLE;
                    break;
                }
                case 3: {
                    button = Mouse.Button.RIGHT;
                    break;
                }
            }
            int eventID = event.getID();
            if (eventID == 504 || eventID == 505) {
                try {
                    switch (eventID) {
                        case 504: {
                            this.display.mouseOver();
                            break;
                        }
                        case 505: {
                            this.display.mouseOut();
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    ApplicationContext.handleUncaughtException(exception);
                }
            } else {
                Component mouseOwner;
                Component mouseCapturer = Mouse.getCapturer();
                if (mouseCapturer == null) {
                    mouseOwner = this.display;
                } else {
                    mouseOwner = mouseCapturer;
                    Point location = mouseOwner.mapPointFromAncestor(this.display, x, y);
                    if (location == null) {
                        location = this.display.getMouseLocation();
                    }
                    if (location != null) {
                        x = location.x;
                        y = location.y;
                    }
                }
                try {
                    switch (eventID) {
                        case 501: {
                            this.requestFocus();
                            this.requestFocusInWindow();
                            boolean consumed = mouseOwner.mouseDown(button, x, y);
                            if (button == Mouse.Button.LEFT) {
                                this.dragLocation = new Point(x, y);
                            } else if (this.menuPopup == null && button == Mouse.Button.RIGHT && !consumed) {
                                MenuHandler menuHandler;
                                Menu menu = new Menu();
                                Component component = mouseOwner;
                                int componentX = x;
                                int componentY = y;
                                while ((menuHandler = component.getMenuHandler()) == null || !menuHandler.configureContextMenu(component, menu, componentX, componentY)) {
                                    if (component instanceof Container) {
                                        Container container = (Container)component;
                                        if ((component = container.getComponentAt(componentX, componentY)) != null) {
                                            componentX -= component.getX();
                                            componentY -= component.getY();
                                        }
                                    } else {
                                        component = null;
                                    }
                                    if (component != null && component.isEnabled()) continue;
                                }
                                if (menu.getSections().getLength() > 0) {
                                    this.menuPopup = new MenuPopup(menu);
                                    this.menuPopup.getWindowStateListeners().add((Object)new WindowStateListener.Adapter(){

                                        @Override
                                        public void windowClosed(Window window, Display displayArgument, Window owner) {
                                            DisplayHost.this.menuPopup.getMenu().getSections().clear();
                                            DisplayHost.this.menuPopup = null;
                                            window.getWindowStateListeners().remove((Object)this);
                                        }
                                    });
                                    Window window = null;
                                    window = mouseOwner == this.display ? (Window)this.display.getComponentAt(x, y) : mouseOwner.getWindow();
                                    Display displayLocal = window.getDisplay();
                                    Point location = mouseOwner.mapPointToAncestor(displayLocal, x, y);
                                    this.menuPopup.open(window, location);
                                }
                            }
                            if (!consumed) break;
                            event.consume();
                            break;
                        }
                        case 502: {
                            if (this.dragDescendant == null) {
                                boolean consumed = mouseOwner.mouseUp(button, x, y);
                                if (consumed) {
                                    event.consume();
                                }
                            } else {
                                DragSource dragSource = this.dragDescendant.getDragSource();
                                this.repaintDragRepresentation();
                                if (this.dropDescendant == null) {
                                    dragSource.endDrag(this.dragDescendant, null);
                                } else {
                                    DropTarget dropTarget = this.dropDescendant.getDropTarget();
                                    DropAction dropAction = dropTarget.drop(this.dropDescendant, this.dragManifest, dragSource.getSupportedDropActions(), x, y, ApplicationContext.getUserDropAction(event));
                                    dragSource.endDrag(this.dragDescendant, dropAction);
                                }
                                this.setCursor(Cursor.getDefaultCursor());
                                this.dragDescendant = null;
                                this.dragManifest = null;
                                this.userDropAction = null;
                                this.dropDescendant = null;
                            }
                            this.dragLocation = null;
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    ApplicationContext.handleUncaughtException(exception);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent event) {
            super.processMouseMotionEvent(event);
            int x = (int)Math.round((double)event.getX() / this.scale);
            int y = (int)Math.round((double)event.getY() / this.scale);
            try {
                switch (event.getID()) {
                    case 503: 
                    case 506: {
                        if (this.dragDescendant == null) {
                            Component mouseCapturer = Mouse.getCapturer();
                            if (mouseCapturer == null) {
                                if (!this.display.isMouseOver()) {
                                    this.display.mouseOver();
                                }
                                this.display.mouseMove(x, y);
                                int dragThreshold = Platform.getDragThreshold();
                                if (this.dragLocation != null && (Math.abs(x - this.dragLocation.x) > dragThreshold || Math.abs(y - this.dragLocation.y) > dragThreshold)) {
                                    this.dragDescendant = this.display.getDescendantAt(this.dragLocation.x, this.dragLocation.y);
                                    while (this.dragDescendant != null && this.dragDescendant.getDragSource() == null) {
                                        this.dragDescendant = this.dragDescendant.getParent();
                                    }
                                    if (this.dragDescendant == null || this.dragDescendant.isBlocked()) {
                                        this.dragDescendant = null;
                                        this.dragLocation = null;
                                        break;
                                    }
                                    DragSource dragSource = this.dragDescendant.getDragSource();
                                    this.dragLocation = this.dragDescendant.mapPointFromAncestor(this.display, x, y);
                                    if (this.dragLocation == null) {
                                        this.dragLocation = this.display.getMouseLocation();
                                    }
                                    if (this.dragLocation != null) {
                                        if (dragSource.beginDrag(this.dragDescendant, this.dragLocation.x, this.dragLocation.y)) {
                                            if (dragSource.isNative()) {
                                                this.startNativeDrag(dragSource, this.dragDescendant, event);
                                                this.dragDescendant = null;
                                                this.dragLocation = null;
                                                break;
                                            }
                                            if (dragSource.getRepresentation() != null && dragSource.getOffset() == null) {
                                                throw new IllegalStateException("Drag offset is required when a representation is specified.");
                                            }
                                            if (this.display.isMouseOver()) {
                                                this.display.mouseOut();
                                            }
                                            this.dragManifest = dragSource.getContent();
                                            this.userDropAction = ApplicationContext.getUserDropAction(event);
                                            this.dragLocation = new Point(x, y);
                                            this.repaintDragRepresentation();
                                            break;
                                        }
                                        this.dragDescendant = null;
                                        this.dragLocation = null;
                                    }
                                }
                            } else {
                                boolean consumed;
                                Point location = mouseCapturer.mapPointFromAncestor(this.display, x, y);
                                if (location == null) {
                                    location = this.display.getMouseLocation();
                                }
                                if (location != null && (consumed = mouseCapturer.mouseMove(location.x, location.y))) {
                                    event.consume();
                                }
                            }
                            break;
                        }
                        if (this.dragLocation == null) break;
                        DragSource dragSource = this.dragDescendant.getDragSource();
                        Component previousDropDescendant = this.dropDescendant;
                        this.dropDescendant = this.getDropDescendant(x, y);
                        DropAction dropAction = null;
                        if (previousDropDescendant == this.dropDescendant) {
                            if (this.dropDescendant != null) {
                                DropTarget dropTarget = this.dropDescendant.getDropTarget();
                                Point dropLocation = this.dropDescendant.mapPointFromAncestor(this.display, x, y);
                                if (dropLocation == null) {
                                    dropLocation = this.display.getMouseLocation();
                                }
                                if (dropLocation != null) {
                                    dropAction = dropTarget.dragMove(this.dropDescendant, this.dragManifest, dragSource.getSupportedDropActions(), dropLocation.x, dropLocation.y, this.userDropAction);
                                }
                            }
                        } else {
                            if (previousDropDescendant != null) {
                                DropTarget previousDropTarget = previousDropDescendant.getDropTarget();
                                previousDropTarget.dragExit(previousDropDescendant);
                            }
                            if (this.dropDescendant != null) {
                                DropTarget dropTarget = this.dropDescendant.getDropTarget();
                                dropAction = dropTarget.dragEnter(this.dropDescendant, this.dragManifest, dragSource.getSupportedDropActions(), this.userDropAction);
                            }
                        }
                        this.setCursor(ApplicationContext.getDropCursor(dropAction));
                        this.repaintDragRepresentation();
                        this.dragLocation = new Point(x, y);
                        this.repaintDragRepresentation();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                ApplicationContext.handleUncaughtException(exception);
            }
        }

        @Override
        protected void processMouseWheelEvent(MouseWheelEvent event) {
            super.processMouseWheelEvent(event);
            int x = (int)Math.round((double)event.getX() / this.scale);
            int y = (int)Math.round((double)event.getY() / this.scale);
            Mouse.ScrollType scrollType = null;
            switch (event.getScrollType()) {
                case 1: {
                    scrollType = Mouse.ScrollType.BLOCK;
                    break;
                }
                case 0: {
                    scrollType = Mouse.ScrollType.UNIT;
                    break;
                }
            }
            try {
                switch (event.getID()) {
                    case 507: {
                        Component mouseOwner;
                        if (Keyboard.isPressed(Keyboard.Modifier.CTRL) && Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                            if (event.getWheelRotation() < 0) {
                                this.scaleUp();
                                break;
                            }
                            this.scaleDown();
                            break;
                        }
                        if (this.dragDescendant != null) break;
                        Component mouseCapturer = Mouse.getCapturer();
                        if (mouseCapturer == null) {
                            mouseOwner = this.display;
                        } else {
                            mouseOwner = mouseCapturer;
                            Point location = mouseOwner.mapPointFromAncestor(this.display, x, y);
                            if (location == null) {
                                location = this.display.getMouseLocation();
                            }
                            if (location != null) {
                                x = location.x;
                                y = location.y;
                            }
                        }
                        boolean consumed = mouseOwner.mouseWheel(scrollType, event.getScrollAmount(), event.getWheelRotation(), x, y);
                        if (consumed) {
                            event.consume();
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                ApplicationContext.handleUncaughtException(exception);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent event) {
            super.processKeyEvent(event);
            int modifiersEx = event.getModifiersEx();
            int awtKeyLocation = event.getKeyLocation();
            int keyboardModifiers = 0;
            if ((modifiersEx & 0x40) > 0) {
                keyboardModifiers |= Keyboard.Modifier.SHIFT.getMask();
            }
            if ((modifiersEx & 0x80) > 0 && ((modifiersEx & 0x200) == 0 || awtKeyLocation == 3)) {
                keyboardModifiers |= Keyboard.Modifier.CTRL.getMask();
            }
            if ((modifiersEx & 0x200) > 0) {
                keyboardModifiers |= Keyboard.Modifier.ALT.getMask();
            }
            if ((modifiersEx & 0x100) > 0) {
                keyboardModifiers |= Keyboard.Modifier.META.getMask();
            }
            Keyboard.setModifiers(keyboardModifiers);
            Keyboard.KeyLocation keyLocation = null;
            switch (awtKeyLocation) {
                case 1: {
                    keyLocation = Keyboard.KeyLocation.STANDARD;
                    break;
                }
                case 2: {
                    keyLocation = Keyboard.KeyLocation.LEFT;
                    break;
                }
                case 3: {
                    keyLocation = Keyboard.KeyLocation.RIGHT;
                    break;
                }
                case 4: {
                    keyLocation = Keyboard.KeyLocation.KEYPAD;
                    break;
                }
            }
            if (this.dragDescendant == null) {
                Component focusedComponentLocal = Component.getFocusedComponent();
                switch (event.getID()) {
                    case 401: {
                        boolean consumed = false;
                        int keyCode = event.getKeyCode();
                        if (Keyboard.isPressed(Keyboard.Modifier.CTRL) && Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                            if (keyCode == 521 || keyCode == 61 || keyCode == 107) {
                                this.scaleUp();
                            } else if (keyCode == 45 || keyCode == 109) {
                                this.scaleDown();
                            }
                        }
                        try {
                            if (focusedComponentLocal == null) {
                                for (Application application : applications) {
                                    if (!(application instanceof Application.UnprocessedKeyHandler)) continue;
                                    Application.UnprocessedKeyHandler unprocessedKeyHandler = (Application.UnprocessedKeyHandler)((Object)application);
                                    unprocessedKeyHandler.keyPressed(keyCode, keyLocation);
                                }
                            } else if (!focusedComponentLocal.isBlocked()) {
                                consumed = focusedComponentLocal.keyPressed(keyCode, keyLocation);
                            }
                        }
                        catch (Exception exception) {
                            ApplicationContext.handleUncaughtException(exception);
                        }
                        if (!consumed) break;
                        event.consume();
                        break;
                    }
                    case 402: {
                        boolean consumed = false;
                        int keyCode = event.getKeyCode();
                        try {
                            if (focusedComponentLocal == null) {
                                for (Application application : applications) {
                                    if (!(application instanceof Application.UnprocessedKeyHandler)) continue;
                                    Application.UnprocessedKeyHandler unprocessedKeyHandler = (Application.UnprocessedKeyHandler)((Object)application);
                                    unprocessedKeyHandler.keyReleased(keyCode, keyLocation);
                                }
                            } else if (!focusedComponentLocal.isBlocked()) {
                                consumed = focusedComponentLocal.keyReleased(keyCode, keyLocation);
                            }
                        }
                        catch (Exception exception) {
                            ApplicationContext.handleUncaughtException(exception);
                        }
                        if (!consumed) break;
                        event.consume();
                        break;
                    }
                    case 400: {
                        boolean consumed = false;
                        char keyChar = event.getKeyChar();
                        try {
                            if (focusedComponentLocal == null) {
                                for (Application application : applications) {
                                    if (!(application instanceof Application.UnprocessedKeyHandler)) continue;
                                    Application.UnprocessedKeyHandler unprocessedKeyHandler = (Application.UnprocessedKeyHandler)((Object)application);
                                    unprocessedKeyHandler.keyTyped(keyChar);
                                }
                            } else if (!focusedComponentLocal.isBlocked()) {
                                consumed = focusedComponentLocal.keyTyped(keyChar);
                            }
                        }
                        catch (Exception exception) {
                            ApplicationContext.handleUncaughtException(exception);
                        }
                        if (!consumed) break;
                        event.consume();
                        break;
                    }
                }
            } else {
                DragSource dragSource = this.dragDescendant.getDragSource();
                if (this.dropDescendant != null) {
                    DropAction previousUserDropAction = this.userDropAction;
                    this.userDropAction = ApplicationContext.getUserDropAction(event);
                    if (previousUserDropAction != this.userDropAction) {
                        DropTarget dropTarget = this.dropDescendant.getDropTarget();
                        Point dropLocation = this.dragLocation;
                        if (dropLocation != null) {
                            dropLocation = this.dropDescendant.mapPointFromAncestor(this.display, dropLocation.x, dropLocation.y);
                        }
                        if (dropLocation == null) {
                            dropLocation = this.display.getMouseLocation();
                        }
                        if (dropLocation != null) {
                            dropTarget.userDropActionChange(this.dropDescendant, this.dragManifest, dragSource.getSupportedDropActions(), dropLocation.x, dropLocation.y, this.userDropAction);
                        }
                    }
                }
            }
        }
    }
}

