/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetBasedConsumptionStatusChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetBasedConsumptionStatusChecker.class);
    private final InstanceDataManager _instanceDataManager;
    private final Set<String> _consumingSegments;
    private final Set<String> _caughtUpSegments = new HashSet<String>();

    public OffsetBasedConsumptionStatusChecker(InstanceDataManager instanceDataManager, Set<String> consumingSegments) {
        this._instanceDataManager = instanceDataManager;
        this._consumingSegments = consumingSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumConsumingSegmentsNotReachedTheirLatestOffset() {
        for (String segName : this._consumingSegments) {
            if (this._caughtUpSegments.contains(segName)) continue;
            TableDataManager tableDataManager = this.getTableDataManager(segName);
            if (tableDataManager == null) {
                LOGGER.info("TableDataManager is not yet setup for segment {}. Will check consumption status later", (Object)segName);
                continue;
            }
            SegmentDataManager segmentDataManager = null;
            try {
                segmentDataManager = tableDataManager.acquireSegment(segName);
                if (segmentDataManager == null) {
                    LOGGER.info("SegmentDataManager is not yet setup for segment {}. Will check consumption status later", (Object)segName);
                    continue;
                }
                if (!(segmentDataManager instanceof LLRealtimeSegmentDataManager)) {
                    LOGGER.info("Segment {} is already committed and is considered caught up.", (Object)segName);
                    this._caughtUpSegments.add(segName);
                    continue;
                }
                LLRealtimeSegmentDataManager rtSegmentDataManager = (LLRealtimeSegmentDataManager)segmentDataManager;
                StreamPartitionMsgOffset latestIngestedOffset = rtSegmentDataManager.getCurrentOffset();
                StreamPartitionMsgOffset latestStreamOffset = rtSegmentDataManager.getLatestStreamOffsetAtStartupTime();
                if (latestStreamOffset == null || latestIngestedOffset == null) {
                    LOGGER.info("Null offset found for segment {} - latest stream offset: {}, latest ingested offset: {}. Will check consumption status later", new Object[]{segName, latestStreamOffset, latestIngestedOffset});
                    continue;
                }
                if (latestIngestedOffset.compareTo((Object)latestStreamOffset) < 0) {
                    LOGGER.info("Latest ingested offset {} in segment {} is smaller than stream latest available offset {} ", new Object[]{latestIngestedOffset, segName, latestStreamOffset});
                    continue;
                }
                LOGGER.info("Segment {} with latest ingested offset {} has caught up to the latest stream offset {}", new Object[]{segName, latestIngestedOffset, latestStreamOffset});
                this._caughtUpSegments.add(segName);
            }
            finally {
                if (segmentDataManager == null) continue;
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        return this._consumingSegments.size() - this._caughtUpSegments.size();
    }

    private TableDataManager getTableDataManager(String segmentName) {
        LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
        String tableName = llcSegmentName.getTableName();
        String tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(tableName);
        return this._instanceDataManager.getTableDataManager(tableNameWithType);
    }
}

