/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.metrics.PinotMetricUtils;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.core.query.scheduler.QuerySchedulerFactory;
import org.apache.pinot.core.transport.QueryServer;
import org.apache.pinot.core.transport.TlsConfig;
import org.apache.pinot.core.transport.grpc.GrpcQueryServer;
import org.apache.pinot.core.util.TlsUtils;
import org.apache.pinot.server.conf.ServerConf;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerInstance.class);
    private final ServerMetrics _serverMetrics;
    private final InstanceDataManager _instanceDataManager;
    private final QueryExecutor _queryExecutor;
    private final LongAccumulator _latestQueryTime;
    private final QueryScheduler _queryScheduler;
    private final QueryServer _nettyQueryServer;
    private final QueryServer _nettyTlsQueryServer;
    private final GrpcQueryServer _grpcQueryServer;
    private boolean _started = false;

    public ServerInstance(ServerConf serverConf, HelixManager helixManager) throws Exception {
        LOGGER.info("Initializing server instance");
        LOGGER.info("Initializing server metrics");
        PinotMetricsRegistry metricsRegistry = PinotMetricUtils.getPinotMetricsRegistry((PinotConfiguration)serverConf.getMetricsConfig());
        this._serverMetrics = new ServerMetrics(serverConf.getMetricsPrefix(), metricsRegistry, serverConf.emitTableLevelMetrics(), serverConf.getAllowedTablesForEmittingMetrics());
        this._serverMetrics.initializeGlobalMeters();
        String instanceDataManagerClassName = serverConf.getInstanceDataManagerClassName();
        LOGGER.info("Initializing instance data manager of class: {}", (Object)instanceDataManagerClassName);
        this._instanceDataManager = (InstanceDataManager)Class.forName(instanceDataManagerClassName).newInstance();
        this._instanceDataManager.init(serverConf.getInstanceDataManagerConfig(), helixManager, this._serverMetrics);
        FunctionRegistry.init();
        String queryExecutorClassName = serverConf.getQueryExecutorClassName();
        LOGGER.info("Initializing query executor of class: {}", (Object)queryExecutorClassName);
        this._queryExecutor = (QueryExecutor)Class.forName(queryExecutorClassName).newInstance();
        PinotConfiguration queryExecutorConfig = serverConf.getQueryExecutorConfig();
        this._queryExecutor.init(queryExecutorConfig, this._instanceDataManager, this._serverMetrics);
        LOGGER.info("Initializing query scheduler");
        this._latestQueryTime = new LongAccumulator(Long::max, 0L);
        this._queryScheduler = QuerySchedulerFactory.create((PinotConfiguration)serverConf.getSchedulerConfig(), (QueryExecutor)this._queryExecutor, (ServerMetrics)this._serverMetrics, (LongAccumulator)this._latestQueryTime);
        TlsConfig tlsConfig = TlsUtils.extractTlsConfig((PinotConfiguration)serverConf.getPinotConfig(), (String)"pinot.server.tls");
        if (serverConf.isNettyServerEnabled()) {
            int nettyPort = serverConf.getNettyPort();
            LOGGER.info("Initializing Netty query server on port: {}", (Object)nettyPort);
            this._nettyQueryServer = new QueryServer(nettyPort, this._queryScheduler, this._serverMetrics);
        } else {
            this._nettyQueryServer = null;
        }
        if (serverConf.isNettyTlsServerEnabled()) {
            int nettySecPort = serverConf.getNettyTlsPort();
            LOGGER.info("Initializing TLS-secured Netty query server on port: {}", (Object)nettySecPort);
            this._nettyTlsQueryServer = new QueryServer(nettySecPort, this._queryScheduler, this._serverMetrics, tlsConfig);
        } else {
            this._nettyTlsQueryServer = null;
        }
        if (serverConf.isEnableGrpcServer()) {
            if (tlsConfig.isCustomized()) {
                LOGGER.warn("gRPC query server does not support TLS yet");
            }
            int grpcPort = serverConf.getGrpcPort();
            LOGGER.info("Initializing gRPC query server on port: {}", (Object)grpcPort);
            this._grpcQueryServer = new GrpcQueryServer(grpcPort, this._queryExecutor, this._serverMetrics);
        } else {
            this._grpcQueryServer = null;
        }
        LOGGER.info("Initializing transform functions");
        HashSet transformFunctionClasses = new HashSet();
        for (String transformFunctionClassName : serverConf.getTransformFunctions()) {
            try {
                transformFunctionClasses.add(Class.forName(transformFunctionClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find transform function class: " + transformFunctionClassName);
            }
        }
        TransformFunctionFactory.init(transformFunctionClasses);
        LOGGER.info("Finish initializing server instance");
    }

    public synchronized void start() {
        if (this._started) {
            LOGGER.info("Server instance is already running, skipping the start");
            return;
        }
        LOGGER.info("Starting server instance");
        LOGGER.info("Starting instance data manager");
        this._instanceDataManager.start();
        LOGGER.info("Starting query executor");
        this._queryExecutor.start();
        LOGGER.info("Starting query scheduler");
        this._queryScheduler.start();
        if (this._nettyQueryServer != null) {
            LOGGER.info("Starting Netty query server");
            this._nettyQueryServer.start();
        }
        if (this._nettyTlsQueryServer != null) {
            LOGGER.info("Starting TLS-secured Netty query server");
            this._nettyTlsQueryServer.start();
        }
        if (this._grpcQueryServer != null) {
            LOGGER.info("Starting gRPC query server");
            this._grpcQueryServer.start();
        }
        this._started = true;
        LOGGER.info("Finish starting server instance");
    }

    public synchronized void shutDown() {
        Preconditions.checkState((boolean)this._started, (Object)"Server instance is not running");
        LOGGER.info("Shutting down server instance");
        if (this._nettyTlsQueryServer != null) {
            LOGGER.info("Shutting down TLS-secured Netty query server");
            this._nettyTlsQueryServer.shutDown();
        }
        if (this._grpcQueryServer != null) {
            LOGGER.info("Shutting down gRPC query server");
            this._grpcQueryServer.shutdown();
        }
        if (this._nettyQueryServer != null) {
            LOGGER.info("Shutting down Netty query server");
            this._nettyQueryServer.shutDown();
        }
        LOGGER.info("Shutting down query scheduler");
        this._queryScheduler.stop();
        LOGGER.info("Shutting down query executor");
        this._queryExecutor.shutDown();
        LOGGER.info("Shutting down instance data manager");
        this._instanceDataManager.shutDown();
        LOGGER.info("Shutting down metrics registry");
        this._serverMetrics.getMetricsRegistry().shutdown();
        this._started = false;
        LOGGER.info("Finish shutting down server instance");
    }

    public ServerMetrics getServerMetrics() {
        return this._serverMetrics;
    }

    public InstanceDataManager getInstanceDataManager() {
        return this._instanceDataManager;
    }

    public long getLatestQueryTime() {
        return this._latestQueryTime.get();
    }
}

