/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.conf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.spi.env.PinotConfiguration;

public class ServerConf {
    private static final String PINOT_CONFIG_PREFIX = "pinot.";
    private static final String PINOT_SERVER_INSTANCE = "pinot.server.instance";
    private static final String PINOT_SERVER_METRICS = "pinot.server.metrics";
    private static final String PINOT_SERVER_METRICS_PREFIX = "pinot.server.metrics.prefix";
    private static final String PINOT_SERVER_QUERY = "pinot.server.query.executor";
    private static final String PINOT_SERVER_REQUEST = "pinot.server.request";
    private static final String PINOT_SERVER_INSTANCE_DATA_MANAGER_CLASS = "pinot.server.instance.data.manager.class";
    private static final String PINOT_SERVER_QUERY_EXECUTOR_CLASS = "pinot.server.query.executor.class";
    private static final String PINOT_SERVER_TRANSFORM_FUNCTIONS = "pinot.server.transforms";
    private static final String PINOT_QUERY_SCHEDULER_PREFIX = "pinot.query.scheduler";
    private PinotConfiguration _serverConf;

    public ServerConf(PinotConfiguration serverConfig) {
        this._serverConf = serverConfig;
    }

    public void init(PinotConfiguration serverConfig) {
        this._serverConf = serverConfig;
    }

    public PinotConfiguration getInstanceDataManagerConfig() {
        return this._serverConf.subset(PINOT_SERVER_INSTANCE);
    }

    public PinotConfiguration getQueryExecutorConfig() {
        return this._serverConf.subset(PINOT_SERVER_QUERY);
    }

    public PinotConfiguration getRequestConfig() {
        return this._serverConf.subset(PINOT_SERVER_REQUEST);
    }

    public PinotConfiguration getMetricsConfig() {
        return this._serverConf.subset(PINOT_SERVER_METRICS);
    }

    public boolean isNettyServerEnabled() {
        return this._serverConf.getProperty("pinot.server.netty.enabled", true);
    }

    public int getNettyPort() {
        return this._serverConf.getProperty("pinot.server.netty.port", 8098);
    }

    public boolean isNettyTlsServerEnabled() {
        return this._serverConf.getProperty("pinot.server.nettytls.enabled", false);
    }

    public int getNettyTlsPort() {
        return this._serverConf.getProperty("pinot.server.nettytls.port", 8091);
    }

    public boolean isEnableGrpcServer() {
        return this._serverConf.getProperty("pinot.server.grpc.enable", false);
    }

    public boolean isEnableSwagger() {
        return this._serverConf.getProperty("pinot.server.swagger.enabled", true);
    }

    public int getGrpcPort() {
        return this._serverConf.getProperty("pinot.server.grpc.port", 8090);
    }

    public PinotConfiguration getConfig(String component) {
        return this._serverConf.subset(PINOT_CONFIG_PREFIX + component);
    }

    public String getInstanceDataManagerClassName() {
        return this._serverConf.getProperty(PINOT_SERVER_INSTANCE_DATA_MANAGER_CLASS);
    }

    public String getQueryExecutorClassName() {
        return this._serverConf.getProperty(PINOT_SERVER_QUERY_EXECUTOR_CLASS);
    }

    public PinotConfiguration getSchedulerConfig() {
        return this._serverConf.subset(PINOT_QUERY_SCHEDULER_PREFIX);
    }

    public List<String> getTransformFunctions() {
        return this._serverConf.getProperty(PINOT_SERVER_TRANSFORM_FUNCTIONS, Arrays.asList(new String[0]));
    }

    public boolean emitTableLevelMetrics() {
        return this._serverConf.getProperty("pinot.server.enableTableLevelMetrics", true);
    }

    public Collection<String> getAllowedTablesForEmittingMetrics() {
        return this._serverConf.getProperty("pinot.server.allowedTablesForEmittingMetrics", Collections.emptyList());
    }

    public String getMetricsPrefix() {
        return this._serverConf.getProperty(PINOT_SERVER_METRICS_PREFIX, "pinot.server.");
    }

    public PinotConfiguration getPinotConfig() {
        return this._serverConf;
    }
}

