/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.restlet.resources.TableTierInfo;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.util.ServerTableTierReader;

public class TableTierReader {
    private static final String ERROR_RESP_NO_RESPONSE = "NO_RESPONSE_FROM_SERVER";
    private static final String ERROR_RESP_MISSING_SEGMENT = "SEGMENT_MISSED_ON_SERVER";
    private static final String ERROR_RESP_NOT_IMMUTABLE = "NOT_IMMUTABLE_SEGMENT";
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;
    private final PinotHelixResourceManager _helixResourceManager;

    public TableTierReader(Executor executor, HttpClientConnectionManager connectionManager, PinotHelixResourceManager helixResourceManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
        this._helixResourceManager = helixResourceManager;
    }

    public TableTierDetails getTableTierDetails(String tableNameWithType, @Nullable String segmentName, int timeoutMs) throws InvalidConfigException {
        return this.getTableTierDetails(tableNameWithType, segmentName, timeoutMs, false);
    }

    public TableTierDetails getTableTierDetails(String tableNameWithType, @Nullable String segmentName, int timeoutMs, boolean skipErrors) throws InvalidConfigException {
        HashMap<String, List<String>> serverToSegmentsMap = new HashMap<String, List<String>>();
        if (segmentName == null) {
            serverToSegmentsMap.putAll(this._helixResourceManager.getServerToSegmentsMap(tableNameWithType));
        } else {
            List<String> segmentInList = Collections.singletonList(segmentName);
            for (String server : this._helixResourceManager.getServers(tableNameWithType, segmentName)) {
                serverToSegmentsMap.put(server, segmentInList);
            }
        }
        BiMap<String, String> endpoints = this._helixResourceManager.getDataInstanceAdminEndpoints(serverToSegmentsMap.keySet());
        ServerTableTierReader serverTableTierReader = new ServerTableTierReader(this._executor, this._connectionManager);
        Map<String, TableTierInfo> serverToTableTierInfoMap = serverTableTierReader.getTableTierInfoFromServers(endpoints, tableNameWithType, segmentName, timeoutMs);
        TableTierDetails tableTierDetails = new TableTierDetails(tableNameWithType);
        for (Map.Entry entry : serverToSegmentsMap.entrySet()) {
            String server = (String)entry.getKey();
            List expectedSegmentsOnServer = (List)entry.getValue();
            TableTierInfo tableTierInfo = serverToTableTierInfoMap.get(server);
            for (String expectedSegment : expectedSegmentsOnServer) {
                String tier;
                String string = tier = tableTierInfo == null ? ERROR_RESP_NO_RESPONSE : TableTierReader.getSegmentTier(expectedSegment, tableTierInfo);
                if (skipErrors && TableTierReader.hasError(tier)) continue;
                tableTierDetails._segmentCurrentTiers.computeIfAbsent(expectedSegment, k -> new HashMap()).put(server, tier);
            }
        }
        if (segmentName == null) {
            for (SegmentZKMetadata segmentZKMetadata : this._helixResourceManager.getSegmentsZKMetadata(tableNameWithType)) {
                tableTierDetails._segmentTargetTiers.put(segmentZKMetadata.getSegmentName(), segmentZKMetadata.getTier());
            }
        } else {
            SegmentZKMetadata segmentZKMetadata = this._helixResourceManager.getSegmentZKMetadata(tableNameWithType, segmentName);
            Preconditions.checkState((segmentZKMetadata != null ? 1 : 0) != 0, (String)"No segmentZKMetadata for segment: %s of table: %s to find the target tier", (Object)segmentName, (Object)tableNameWithType);
            tableTierDetails._segmentTargetTiers.put(segmentName, segmentZKMetadata.getTier());
        }
        return tableTierDetails;
    }

    private static boolean hasError(String tier) {
        return ERROR_RESP_MISSING_SEGMENT.equals(tier) || ERROR_RESP_NO_RESPONSE.equals(tier) || ERROR_RESP_NOT_IMMUTABLE.equals(tier);
    }

    private static String getSegmentTier(String expectedSegment, TableTierInfo tableTierInfo) {
        if (tableTierInfo.getMutableSegments().contains(expectedSegment)) {
            return ERROR_RESP_NOT_IMMUTABLE;
        }
        if (!tableTierInfo.getSegmentTiers().containsKey(expectedSegment)) {
            return ERROR_RESP_MISSING_SEGMENT;
        }
        return (String)tableTierInfo.getSegmentTiers().get(expectedSegment);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TableTierDetails {
        private final String _tableName;
        private final Map<String, Map<String, String>> _segmentCurrentTiers = new HashMap<String, Map<String, String>>();
        private final Map<String, String> _segmentTargetTiers = new HashMap<String, String>();

        TableTierDetails(String tableName) {
            this._tableName = tableName;
        }

        @JsonPropertyDescription(value="Name of table to look for segment storage tiers")
        @JsonProperty(value="tableName")
        public String getTableName() {
            return this._tableName;
        }

        @JsonPropertyDescription(value="Storage tiers of segments for the given table")
        @JsonProperty(value="segmentTiers")
        public Map<String, Map<String, String>> getSegmentTiers() {
            HashMap<String, Map<String, String>> segmentTiers = new HashMap<String, Map<String, String>>(this._segmentCurrentTiers);
            for (Map.Entry<String, String> entry : this._segmentTargetTiers.entrySet()) {
                segmentTiers.computeIfAbsent(entry.getKey(), s -> new HashMap()).put("targetTier", entry.getValue());
            }
            return segmentTiers;
        }

        @JsonIgnore
        public Map<String, Map<String, String>> getSegmentCurrentTiers() {
            return this._segmentCurrentTiers;
        }

        @JsonIgnore
        public Map<String, String> getSegmentTargetTiers() {
            return this._segmentTargetTiers;
        }
    }
}

