/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariedLengthDictionaryRule
extends AbstractRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariedLengthDictionaryRule.class);

    public VariedLengthDictionaryRule(InputManager input, ConfigManager output) {
        super(input, output);
    }

    @Override
    public void run() {
        for (String colName : this._input.getColNameToIntMap().keySet()) {
            if (this._output.getIndexConfig().getNoDictionaryColumns().contains(colName)) continue;
            LOGGER.debug("{} {}", (Object)this._input.getFieldType(colName), (Object)colName);
            if (this._input.getFieldType(colName) != FieldSpec.DataType.STRING && this._input.getFieldType(colName) != FieldSpec.DataType.BYTES) continue;
            this._output.getIndexConfig().getVarLengthDictionaryColumns().add(colName);
        }
    }
}

