/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import com.google.common.annotations.VisibleForTesting;
import java.util.Random;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.MultiValueGeneratorHelper;

public class BooleanGenerator
implements Generator {
    private static final double DEFAULT_NUMBER_OF_VALUES_PER_ENTRY = 1.0;
    private final double _numberOfValuesPerEntry;
    private final Random _random;

    public BooleanGenerator(Double numberOfValuesPerEntry) {
        this(numberOfValuesPerEntry, new Random(System.currentTimeMillis()));
    }

    @VisibleForTesting
    BooleanGenerator(Double numberOfValuesPerEntry, Random random) {
        this._numberOfValuesPerEntry = numberOfValuesPerEntry != null ? numberOfValuesPerEntry : 1.0;
        this._random = random;
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        if (this._numberOfValuesPerEntry == 1.0) {
            return this.getNextBooleanAsInteger();
        }
        return MultiValueGeneratorHelper.generateMultiValueEntries(this._numberOfValuesPerEntry, this._random, this::getNextBooleanAsInteger);
    }

    private int getNextBooleanAsInteger() {
        return this._random.nextBoolean() ? 1 : 0;
    }
}

