/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class ZKMetadataUtils {
    private ZKMetadataUtils() {
    }

    public static SegmentZKMetadata createSegmentZKMetadata(String tableNameWithType, SegmentMetadata segmentMetadata, String downloadUrl, @Nullable String crypterName, long segmentSizeInBytes) {
        SegmentZKMetadata segmentZKMetadata = new SegmentZKMetadata(segmentMetadata.getName());
        ZKMetadataUtils.updateSegmentZKMetadata(tableNameWithType, segmentZKMetadata, segmentMetadata, downloadUrl, crypterName, segmentSizeInBytes, true);
        return segmentZKMetadata;
    }

    public static void refreshSegmentZKMetadata(String tableNameWithType, SegmentZKMetadata segmentZKMetadata, SegmentMetadata segmentMetadata, String downloadUrl, @Nullable String crypterName, long segmentSizeInBytes) {
        ZKMetadataUtils.updateSegmentZKMetadata(tableNameWithType, segmentZKMetadata, segmentMetadata, downloadUrl, crypterName, segmentSizeInBytes, false);
    }

    public static void updateSegmentZKTimeInterval(SegmentZKMetadata segmentZKMetadata, DateTimeFieldSpec dateTimeFieldSpec) {
        String endTimeString;
        String startTimeString = segmentZKMetadata.getRawStartTime();
        if (StringUtils.isNotEmpty((CharSequence)startTimeString)) {
            long updatedStartTime = dateTimeFieldSpec.getFormatSpec().fromFormatToMillis(startTimeString);
            segmentZKMetadata.setStartTime(updatedStartTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)(endTimeString = segmentZKMetadata.getRawEndTime()))) {
            long updatedEndTime = dateTimeFieldSpec.getFormatSpec().fromFormatToMillis(endTimeString);
            segmentZKMetadata.setEndTime(updatedEndTime);
        }
    }

    private static void updateSegmentZKMetadata(String tableNameWithType, SegmentZKMetadata segmentZKMetadata, SegmentMetadata segmentMetadata, String downloadUrl, @Nullable String crypterName, long segmentSizeInBytes, boolean newSegment) {
        if (newSegment) {
            segmentZKMetadata.setPushTime(System.currentTimeMillis());
        } else {
            segmentZKMetadata.setRefreshTime(System.currentTimeMillis());
        }
        if (segmentMetadata.getTimeInterval() != null) {
            segmentZKMetadata.setStartTime(segmentMetadata.getTimeInterval().getStartMillis());
            segmentZKMetadata.setEndTime(segmentMetadata.getTimeInterval().getEndMillis());
            segmentZKMetadata.setTimeUnit(TimeUnit.MILLISECONDS);
            ColumnMetadata timeColumnMetadata = segmentMetadata.getColumnMetadataFor(segmentMetadata.getTimeColumn());
            if (ZKMetadataUtils.isValidTimeMetadata(timeColumnMetadata)) {
                segmentZKMetadata.setRawStartTime(timeColumnMetadata.getMinValue().toString());
                segmentZKMetadata.setRawEndTime(timeColumnMetadata.getMaxValue().toString());
            }
        } else {
            segmentZKMetadata.setStartTime(-1L);
            segmentZKMetadata.setEndTime(-1L);
            segmentZKMetadata.setTimeUnit(null);
        }
        segmentZKMetadata.setIndexVersion(segmentMetadata.getVersion() != null ? segmentMetadata.getVersion().name() : null);
        segmentZKMetadata.setTotalDocs((long)segmentMetadata.getTotalDocs());
        segmentZKMetadata.setSizeInBytes(segmentSizeInBytes);
        segmentZKMetadata.setCrc(Long.parseLong(segmentMetadata.getCrc()));
        segmentZKMetadata.setCreationTime(segmentMetadata.getIndexCreationTime());
        segmentZKMetadata.setDownloadUrl(downloadUrl);
        segmentZKMetadata.setCrypterName(crypterName);
        HashMap columnPartitionMap = new HashMap();
        segmentMetadata.getColumnMetadataMap().forEach((column, columnMetadata) -> {
            PartitionFunction partitionFunction = columnMetadata.getPartitionFunction();
            if (partitionFunction != null) {
                ColumnPartitionMetadata columnPartitionMetadata = new ColumnPartitionMetadata(partitionFunction.getName(), partitionFunction.getNumPartitions(), columnMetadata.getPartitions(), partitionFunction.getFunctionConfig());
                columnPartitionMap.put(column, columnPartitionMetadata);
            }
        });
        segmentZKMetadata.setPartitionMetadata(!columnPartitionMap.isEmpty() ? new SegmentPartitionMetadata(columnPartitionMap) : null);
        Map customMap = segmentZKMetadata.getCustomMap();
        if (customMap == null) {
            customMap = segmentMetadata.getCustomMap();
        } else {
            customMap.putAll(segmentMetadata.getCustomMap());
        }
        segmentZKMetadata.setCustomMap(customMap);
        if (TableNameBuilder.isRealtimeTableResource((String)tableNameWithType)) {
            segmentZKMetadata.setStatus(CommonConstants.Segment.Realtime.Status.UPLOADED);
            if (newSegment && SegmentName.isLowLevelConsumerSegmentName((String)segmentMetadata.getName())) {
                Preconditions.checkArgument((segmentMetadata.getStartOffset() != null && segmentMetadata.getEndOffset() != null ? 1 : 0) != 0, (Object)"New uploaded LLC segment must have start/end offset in the segment metadata");
            }
            if (segmentMetadata.getStartOffset() != null) {
                segmentZKMetadata.setStartOffset(segmentMetadata.getStartOffset());
            }
            if (segmentMetadata.getEndOffset() != null) {
                segmentZKMetadata.setEndOffset(segmentMetadata.getEndOffset());
            }
        }
    }

    private static boolean isValidTimeMetadata(ColumnMetadata timeColumnMetadata) {
        return timeColumnMetadata != null && timeColumnMetadata.getMinValue() != null && timeColumnMetadata.getMaxValue() != null && !timeColumnMetadata.isMinMaxValueInvalid();
    }
}

