/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.realtime.segment;

import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;

public class CommittingSegmentDescriptor {
    private String _segmentName;
    private long _segmentSizeBytes;
    private String _segmentLocation;
    private String _nextOffset;
    private SegmentMetadataImpl _segmentMetadata;

    public static CommittingSegmentDescriptor fromSegmentCompletionReqParams(SegmentCompletionProtocol.Request.Params reqParams) {
        CommittingSegmentDescriptor committingSegmentDescriptor = new CommittingSegmentDescriptor(reqParams.getSegmentName(), reqParams.getStreamPartitionMsgOffset(), reqParams.getSegmentSizeBytes());
        committingSegmentDescriptor.setSegmentLocation(reqParams.getSegmentLocation());
        return committingSegmentDescriptor;
    }

    public static CommittingSegmentDescriptor fromSegmentCompletionReqParamsAndMetadata(SegmentCompletionProtocol.Request.Params reqParams, SegmentMetadataImpl metadata) {
        CommittingSegmentDescriptor committingSegmentDescriptor = CommittingSegmentDescriptor.fromSegmentCompletionReqParams(reqParams);
        committingSegmentDescriptor.setSegmentMetadata(metadata);
        return committingSegmentDescriptor;
    }

    public CommittingSegmentDescriptor(String segmentName, String nextOffset, long segmentSizeBytes) {
        this._segmentName = segmentName;
        this._nextOffset = nextOffset;
        this._segmentSizeBytes = segmentSizeBytes;
    }

    public CommittingSegmentDescriptor(String segmentName, String nextOffset, long segmentSizeBytes, String segmentLocation) {
        this(segmentName, nextOffset, segmentSizeBytes);
        this._segmentLocation = segmentLocation;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public void setSegmentName(String segmentName) {
        this._segmentName = segmentName;
    }

    public long getSegmentSizeBytes() {
        return this._segmentSizeBytes;
    }

    public void setSegmentSizeBytes(long segmentSizeBytes) {
        this._segmentSizeBytes = segmentSizeBytes;
    }

    public String getSegmentLocation() {
        return this._segmentLocation;
    }

    public void setSegmentLocation(String segmentLocation) {
        this._segmentLocation = segmentLocation;
    }

    public String getNextOffset() {
        return this._nextOffset;
    }

    public SegmentMetadataImpl getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public void setSegmentMetadata(SegmentMetadataImpl segmentMetadata) {
        this._segmentMetadata = segmentMetadata;
    }
}

