/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.minion.MinionTaskMetadataUtils;
import org.apache.pinot.common.utils.DateTimeUtils;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotHelixTaskResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotHelixTaskResourceManager.class);
    public static final String TASK_NAME_SEPARATOR = "_";
    private static final String TASK_QUEUE_PREFIX = "TaskQueue_";
    private static final String TASK_PREFIX = "Task_";
    private static final String UNKNOWN_TABLE_NAME = "unknown";
    private final TaskDriver _taskDriver;
    private final PinotHelixResourceManager _helixResourceManager;
    private final long _taskExpireTimeMs;

    public PinotHelixTaskResourceManager(PinotHelixResourceManager helixResourceManager, TaskDriver taskDriver) {
        this(helixResourceManager, taskDriver, TimeUnit.HOURS.toMillis(24L));
    }

    public PinotHelixTaskResourceManager(PinotHelixResourceManager helixResourceManager, TaskDriver taskDriver, long taskExpireTimeMs) {
        this._helixResourceManager = helixResourceManager;
        this._taskDriver = taskDriver;
        this._taskExpireTimeMs = taskExpireTimeMs;
    }

    public synchronized Set<String> getTaskTypes() {
        Set helixJobQueues = this._taskDriver.getWorkflows().keySet();
        HashSet<String> taskTypes = new HashSet<String>(helixJobQueues.size());
        for (String helixJobQueue : helixJobQueues) {
            taskTypes.add(PinotHelixTaskResourceManager.getTaskType(helixJobQueue));
        }
        return taskTypes;
    }

    public synchronized void ensureTaskQueueExists(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        WorkflowConfig workflowConfig = this._taskDriver.getWorkflowConfig(helixJobQueueName);
        if (workflowConfig == null) {
            LOGGER.info("Creating task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
            JobQueue jobQueue = new JobQueue.Builder(helixJobQueueName).setWorkflowConfig(new WorkflowConfig.Builder().setParallelJobs(Integer.MAX_VALUE).build()).build();
            this._taskDriver.createQueue(jobQueue);
        }
    }

    public synchronized void cleanUpTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Cleaning up task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.cleanupQueue(helixJobQueueName);
    }

    public synchronized void stopTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Stopping task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.stop(helixJobQueueName);
    }

    public synchronized void resumeTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Resuming task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.resume(helixJobQueueName);
    }

    public synchronized void deleteTaskQueue(String taskType, boolean forceDelete) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        if (forceDelete) {
            LOGGER.warn("Force deleting task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        } else {
            LOGGER.info("Deleting task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        }
        this._taskDriver.delete(helixJobQueueName, forceDelete);
    }

    public synchronized void deleteTask(String taskName, boolean forceDelete) {
        String taskType = PinotHelixTaskResourceManager.getTaskType(taskName);
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        if (forceDelete) {
            LOGGER.warn("Force deleting task: {} from queue: {} of task type: {}", new Object[]{taskName, helixJobQueueName, taskType});
        } else {
            LOGGER.info("Deleting task: {} from queue: {} of task type: {}", new Object[]{taskName, helixJobQueueName, taskType});
        }
        this._taskDriver.deleteJob(helixJobQueueName, taskName, forceDelete);
    }

    public synchronized Set<String> getTaskQueues() {
        return this._taskDriver.getWorkflows().keySet();
    }

    @Nullable
    public synchronized TaskState getTaskQueueState(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        if (this._taskDriver.getWorkflowConfig(helixJobQueueName) == null) {
            return null;
        }
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(helixJobQueueName);
        return workflowContext != null ? workflowContext.getWorkflowState() : TaskState.NOT_STARTED;
    }

    public synchronized String submitTask(List<PinotTaskConfig> pinotTaskConfigs, long taskTimeoutMs, int numConcurrentTasksPerInstance, int maxAttemptsPerTask) {
        return this.submitTask(pinotTaskConfigs, "minion_untagged", taskTimeoutMs, numConcurrentTasksPerInstance, maxAttemptsPerTask);
    }

    public synchronized String submitTask(List<PinotTaskConfig> pinotTaskConfigs, String minionInstanceTag, long taskTimeoutMs, int numConcurrentTasksPerInstance, int maxAttemptsPerTask) {
        int numChildTasks = pinotTaskConfigs.size();
        Preconditions.checkState((numChildTasks > 0 ? 1 : 0) != 0);
        Preconditions.checkState((numConcurrentTasksPerInstance > 0 ? 1 : 0) != 0);
        String taskType = pinotTaskConfigs.get(0).getTaskType();
        String parentTaskName = this.getParentTaskName(taskType, UUID.randomUUID() + TASK_NAME_SEPARATOR + System.currentTimeMillis());
        return this.submitTask(parentTaskName, pinotTaskConfigs, minionInstanceTag, taskTimeoutMs, numConcurrentTasksPerInstance, maxAttemptsPerTask);
    }

    public synchronized String submitTask(String parentTaskName, List<PinotTaskConfig> pinotTaskConfigs, String minionInstanceTag, long taskTimeoutMs, int numConcurrentTasksPerInstance, int maxAttemptsPerTask) {
        int numChildTasks = pinotTaskConfigs.size();
        Preconditions.checkState((numChildTasks > 0 ? 1 : 0) != 0);
        Preconditions.checkState((numConcurrentTasksPerInstance > 0 ? 1 : 0) != 0);
        String taskType = pinotTaskConfigs.get(0).getTaskType();
        LOGGER.info("Submitting parent task: {} of type: {} with {} child task configs: {} to Minion instances with tag: {}", new Object[]{parentTaskName, taskType, numChildTasks, pinotTaskConfigs, minionInstanceTag});
        ArrayList<TaskConfig> helixTaskConfigs = new ArrayList<TaskConfig>(numChildTasks);
        for (int i = 0; i < numChildTasks; ++i) {
            PinotTaskConfig pinotTaskConfig = pinotTaskConfigs.get(i);
            Preconditions.checkState((boolean)pinotTaskConfig.getTaskType().equals(taskType));
            helixTaskConfigs.add(pinotTaskConfig.toHelixTaskConfig(parentTaskName + TASK_NAME_SEPARATOR + i));
        }
        JobConfig.Builder jobBuilder = new JobConfig.Builder().addTaskConfigs(helixTaskConfigs).setInstanceGroupTag(minionInstanceTag).setTimeoutPerTask(taskTimeoutMs).setNumConcurrentTasksPerInstance(numConcurrentTasksPerInstance).setIgnoreDependentJobFailure(true).setMaxAttemptsPerTask(maxAttemptsPerTask).setFailureThreshold(Integer.MAX_VALUE).setExpiry(Long.valueOf(this._taskExpireTimeMs));
        this._taskDriver.enqueueJob(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType), parentTaskName, jobBuilder);
        return parentTaskName;
    }

    public synchronized Set<String> getTasks(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        WorkflowConfig workflowConfig = this._taskDriver.getWorkflowConfig(helixJobQueueName);
        Preconditions.checkArgument((workflowConfig != null ? 1 : 0) != 0, (String)"Task queue: %s for task type: %s does not exist", (Object)helixJobQueueName, (Object)taskType);
        Set helixJobs = workflowConfig.getJobDag().getAllNodes();
        HashSet<String> tasks = new HashSet<String>(helixJobs.size());
        for (String helixJobName : helixJobs) {
            tasks.add(PinotHelixTaskResourceManager.getPinotTaskName(helixJobName));
        }
        return tasks;
    }

    public synchronized Map<String, TaskState> getTaskStates(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        WorkflowConfig workflowConfig = this._taskDriver.getWorkflowConfig(helixJobQueueName);
        Preconditions.checkArgument((workflowConfig != null ? 1 : 0) != 0, (String)"Task queue: %s for task type: %s does not exist", (Object)helixJobQueueName, (Object)taskType);
        Set helixJobs = workflowConfig.getJobDag().getAllNodes();
        if (helixJobs.isEmpty()) {
            return Collections.emptyMap();
        }
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext == null) {
            return helixJobs.stream().collect(Collectors.toMap(PinotHelixTaskResourceManager::getPinotTaskName, ignored -> TaskState.NOT_STARTED));
        }
        Map helixJobStates = workflowContext.getJobStates();
        return helixJobs.stream().collect(Collectors.toMap(PinotHelixTaskResourceManager::getPinotTaskName, helixJobName -> helixJobStates.getOrDefault(helixJobName, TaskState.NOT_STARTED)));
    }

    public synchronized TaskCount getTaskCount(String taskName) {
        String helixJobName = PinotHelixTaskResourceManager.getHelixJobName(taskName);
        JobConfig jobConfig = this._taskDriver.getJobConfig(helixJobName);
        Preconditions.checkArgument((jobConfig != null ? 1 : 0) != 0, (String)"Task: %s does not exist", (Object)taskName);
        Set subtasks = jobConfig.getTaskConfigMap().keySet();
        TaskCount taskCount = new TaskCount();
        JobContext jobContext = this._taskDriver.getJobContext(helixJobName);
        if (jobContext == null) {
            int numSubtasks = subtasks.size();
            for (int i = 0; i < numSubtasks; ++i) {
                taskCount.addTaskState(null);
            }
            return taskCount;
        }
        Map taskIdPartitionMap = jobContext.getTaskIdPartitionMap();
        for (String taskId : subtasks) {
            TaskPartitionState state = null;
            Integer partition = (Integer)taskIdPartitionMap.get(taskId);
            if (partition != null) {
                state = jobContext.getPartitionState(partition.intValue());
            }
            taskCount.addTaskState(state);
        }
        return taskCount;
    }

    public synchronized Map<String, TaskCount> getTableTaskCount(String taskName) {
        String helixJobName = PinotHelixTaskResourceManager.getHelixJobName(taskName);
        JobConfig jobConfig = this._taskDriver.getJobConfig(helixJobName);
        Preconditions.checkArgument((jobConfig != null ? 1 : 0) != 0, (String)"Task: %s does not exist", (Object)taskName);
        Map taskConfigMap = jobConfig.getTaskConfigMap();
        HashMap<String, TaskCount> taskCountMap = new HashMap<String, TaskCount>();
        JobContext jobContext = this._taskDriver.getJobContext(helixJobName);
        if (jobContext == null) {
            for (TaskConfig taskConfig : taskConfigMap.values()) {
                String tableName = taskConfig.getConfigMap().getOrDefault("tableName", UNKNOWN_TABLE_NAME);
                taskCountMap.computeIfAbsent(tableName, k -> new TaskCount()).addTaskState(null);
            }
            return taskCountMap;
        }
        Map taskIdPartitionMap = jobContext.getTaskIdPartitionMap();
        for (Map.Entry entry : taskConfigMap.entrySet()) {
            String taskId = (String)entry.getKey();
            TaskPartitionState state = null;
            Integer partition = (Integer)taskIdPartitionMap.get(taskId);
            if (partition != null) {
                state = jobContext.getPartitionState(partition.intValue());
            }
            TaskConfig taskConfig = (TaskConfig)entry.getValue();
            String tableName = taskConfig.getConfigMap().getOrDefault("tableName", UNKNOWN_TABLE_NAME);
            taskCountMap.computeIfAbsent(tableName, k -> new TaskCount()).addTaskState(state);
        }
        return taskCountMap;
    }

    public synchronized Set<String> getTasksInProgress(String taskType) {
        WorkflowConfig workflowConfig = this._taskDriver.getWorkflowConfig(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowConfig == null) {
            return Collections.emptySet();
        }
        Set helixJobs = workflowConfig.getJobDag().getAllNodes();
        if (helixJobs.isEmpty()) {
            return Collections.emptySet();
        }
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext == null) {
            return helixJobs.stream().map(PinotHelixTaskResourceManager::getPinotTaskName).collect(Collectors.toSet());
        }
        Map helixJobStates = workflowContext.getJobStates();
        return helixJobs.stream().filter(helixJobName -> {
            TaskState taskState = (TaskState)helixJobStates.get(helixJobName);
            return taskState == null || taskState == TaskState.NOT_STARTED || taskState == TaskState.IN_PROGRESS;
        }).map(PinotHelixTaskResourceManager::getPinotTaskName).collect(Collectors.toSet());
    }

    @Nullable
    public synchronized TaskState getTaskState(String taskName) {
        TaskState jobState;
        String helixJobName = PinotHelixTaskResourceManager.getHelixJobName(taskName);
        JobConfig jobConfig = this._taskDriver.getJobConfig(helixJobName);
        if (jobConfig == null) {
            return null;
        }
        String taskType = PinotHelixTaskResourceManager.getTaskType(taskName);
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext != null && (jobState = workflowContext.getJobState(helixJobName)) != null) {
            return jobState;
        }
        return TaskState.NOT_STARTED;
    }

    public synchronized Map<String, TaskPartitionState> getSubtaskStates(String taskName) {
        String helixJobName = PinotHelixTaskResourceManager.getHelixJobName(taskName);
        JobConfig jobConfig = this._taskDriver.getJobConfig(helixJobName);
        Preconditions.checkArgument((jobConfig != null ? 1 : 0) != 0, (String)"Task: %s does not exist", (Object)taskName);
        Set subtasks = jobConfig.getTaskConfigMap().keySet();
        HashMap<String, TaskPartitionState> subtaskStates = new HashMap<String, TaskPartitionState>();
        JobContext jobContext = this._taskDriver.getJobContext(helixJobName);
        if (jobContext == null) {
            for (String taskId : subtasks) {
                subtaskStates.put(taskId, null);
            }
            return subtaskStates;
        }
        Map taskIdPartitionMap = jobContext.getTaskIdPartitionMap();
        for (String taskId : subtasks) {
            TaskPartitionState state = null;
            Integer partition = (Integer)taskIdPartitionMap.get(taskId);
            if (partition != null) {
                state = jobContext.getPartitionState(partition.intValue());
            }
            subtaskStates.put(taskId, state);
        }
        return subtaskStates;
    }

    public synchronized List<PinotTaskConfig> getSubtaskConfigs(String taskName) {
        Collection helixTaskConfigs = this._taskDriver.getJobConfig(PinotHelixTaskResourceManager.getHelixJobName(taskName)).getTaskConfigMap().values();
        ArrayList<PinotTaskConfig> taskConfigs = new ArrayList<PinotTaskConfig>(helixTaskConfigs.size());
        for (TaskConfig helixTaskConfig : helixTaskConfigs) {
            taskConfigs.add(PinotTaskConfig.fromHelixTaskConfig((TaskConfig)helixTaskConfig));
        }
        return taskConfigs;
    }

    public synchronized Map<String, String> getTaskRuntimeConfig(String taskName) {
        JobConfig jobConfig = this._taskDriver.getJobConfig(PinotHelixTaskResourceManager.getHelixJobName(taskName));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("ConcurrentTasksPerWorker", String.valueOf(jobConfig.getNumConcurrentTasksPerInstance()));
        configs.put("TaskTimeoutMs", String.valueOf(jobConfig.getTimeoutPerTask()));
        configs.put("TaskExpireTimeMs", String.valueOf(jobConfig.getExpiry()));
        configs.put("MinionWorkerGroupTag", jobConfig.getInstanceGroupTag());
        return configs;
    }

    public synchronized Map<String, PinotTaskConfig> getSubtaskConfigs(String taskName, @Nullable String subtaskNames) {
        JobConfig jobConfig = this._taskDriver.getJobConfig(PinotHelixTaskResourceManager.getHelixJobName(taskName));
        if (jobConfig == null) {
            return Collections.emptyMap();
        }
        Map helixTaskConfigs = jobConfig.getTaskConfigMap();
        HashMap<String, PinotTaskConfig> taskConfigs = new HashMap<String, PinotTaskConfig>(helixTaskConfigs.size());
        if (StringUtils.isEmpty((CharSequence)subtaskNames)) {
            helixTaskConfigs.forEach((sub, cfg) -> taskConfigs.put((String)sub, PinotTaskConfig.fromHelixTaskConfig((TaskConfig)cfg)));
            return taskConfigs;
        }
        for (String subtaskName : StringUtils.split((String)subtaskNames, (char)',')) {
            TaskConfig taskConfig = (TaskConfig)helixTaskConfigs.get(subtaskName);
            if (taskConfig == null) continue;
            taskConfigs.put(subtaskName, PinotTaskConfig.fromHelixTaskConfig((TaskConfig)taskConfig));
        }
        return taskConfigs;
    }

    public synchronized Map<String, Object> getSubtaskProgress(String taskName, @Nullable String subtaskNames, Executor executor, HttpClientConnectionManager connMgr, Map<String, String> workerEndpoints, Map<String, String> requestHeaders, int timeoutMs) throws Exception {
        return this.getSubtaskProgress(taskName, subtaskNames, new CompletionServiceHelper(executor, connMgr, (BiMap<String, String>)HashBiMap.create((int)0)), workerEndpoints, requestHeaders, timeoutMs);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    Map<String, Object> getSubtaskProgress(String taskName, @Nullable String subtaskNames, CompletionServiceHelper completionServiceHelper, Map<String, String> workerEndpoints, Map<String, String> requestHeaders, int timeoutMs) throws Exception {
        Set selectedSubtasks;
        String helixJobName = PinotHelixTaskResourceManager.getHelixJobName(taskName);
        JobConfig jobConfig = this._taskDriver.getJobConfig(helixJobName);
        Preconditions.checkArgument((jobConfig != null ? 1 : 0) != 0, (String)"Task: %s does not exist", (Object)taskName);
        Set subtasks = jobConfig.getTaskConfigMap().keySet();
        if (StringUtils.isNotEmpty((CharSequence)subtaskNames)) {
            selectedSubtasks = new HashSet<String>(Arrays.asList(StringUtils.split((String)subtaskNames, (char)',')));
            selectedSubtasks.retainAll(subtasks);
        } else {
            selectedSubtasks = subtasks;
        }
        if (selectedSubtasks.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> subtaskProgressMap = new HashMap<String, Object>();
        JobContext jobContext = this._taskDriver.getJobContext(helixJobName);
        if (jobContext == null) {
            for (String taskId : selectedSubtasks) {
                subtaskProgressMap.put(taskId, "No worker has run this subtask");
            }
            return subtaskProgressMap;
        }
        HashMap<String, Pair> subtaskWorkerAndStateMap = new HashMap<String, Pair>();
        HashMap<String, Set> workerSubtasksMap = new HashMap<String, Set>();
        Map taskIdPartitionMap = jobContext.getTaskIdPartitionMap();
        for (String taskId : selectedSubtasks) {
            void var19_21;
            Object worker = null;
            Object var19_22 = null;
            Integer partition = (Integer)taskIdPartitionMap.get(taskId);
            if (partition != null) {
                worker = jobContext.getAssignedParticipant(partition.intValue());
                TaskPartitionState taskPartitionState = jobContext.getPartitionState(partition.intValue());
            }
            subtaskWorkerAndStateMap.put(taskId, Pair.of((Object)worker, (Object)var19_21));
            if (worker == null) continue;
            workerSubtasksMap.computeIfAbsent((String)worker, k -> new HashSet()).add(taskId);
        }
        LOGGER.debug("Found subtasks on workers: {}", workerSubtasksMap);
        ArrayList<String> workerUrls = new ArrayList<String>();
        workerSubtasksMap.forEach((workerId, subtasksOnWorker) -> workerUrls.add(String.format("%s/tasks/subtask/progress?subtaskNames=%s", workerEndpoints.get(workerId), StringUtils.join((Iterable)subtasksOnWorker, (char)','))));
        LOGGER.debug("Getting task progress with workerUrls: {}", workerUrls);
        if (!workerUrls.isEmpty()) {
            CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(workerUrls, null, true, requestHeaders, timeoutMs);
            for (Map.Entry entry : serviceResponse._httpResponses.entrySet()) {
                String worker = (String)entry.getKey();
                String resp = (String)entry.getValue();
                LOGGER.debug("Got resp: {} from worker: {}", (Object)resp, (Object)worker);
                if (!StringUtils.isNotEmpty((CharSequence)resp)) continue;
                subtaskProgressMap.putAll((Map)JsonUtils.stringToObject((String)resp, Map.class));
            }
            if (serviceResponse._failedResponseCount > 0) {
                LOGGER.warn("There were {} workers failed to report task progress. Got partial progress info: {}", (Object)serviceResponse._failedResponseCount, subtaskProgressMap);
            }
        }
        for (String taskId : selectedSubtasks) {
            if (subtaskProgressMap.containsKey(taskId)) continue;
            Pair pair = (Pair)subtaskWorkerAndStateMap.get(taskId);
            if (pair.getLeft() == null) {
                subtaskProgressMap.put(taskId, "No worker has run this subtask");
                continue;
            }
            subtaskProgressMap.put(taskId, String.format("No status from worker: %s. Got status: %s from Helix", pair.getLeft(), pair.getRight()));
        }
        return subtaskProgressMap;
    }

    public synchronized Map<String, Object> getSubtaskOnWorkerProgress(String subtaskState, Executor executor, HttpClientConnectionManager connMgr, Map<String, String> selectedMinionWorkerEndpoints, Map<String, String> requestHeaders, int timeoutMs) throws JsonProcessingException {
        return this.getSubtaskOnWorkerProgress(subtaskState, new CompletionServiceHelper(executor, connMgr, (BiMap<String, String>)HashBiMap.create((int)0)), selectedMinionWorkerEndpoints, requestHeaders, timeoutMs);
    }

    @VisibleForTesting
    Map<String, Object> getSubtaskOnWorkerProgress(String subtaskState, CompletionServiceHelper completionServiceHelper, Map<String, String> selectedMinionWorkerEndpoints, Map<String, String> requestHeaders, int timeoutMs) throws JsonProcessingException {
        HashMap<String, Object> minionWorkerIdSubtaskProgressMap = new HashMap<String, Object>();
        if (selectedMinionWorkerEndpoints.isEmpty()) {
            return minionWorkerIdSubtaskProgressMap;
        }
        Map<String, String> minionWorkerUrlToWorkerIdMap = selectedMinionWorkerEndpoints.entrySet().stream().collect(Collectors.toMap(entry -> String.format("%s/tasks/subtask/state/progress?subTaskState=%s", entry.getValue(), subtaskState), Map.Entry::getKey));
        ArrayList<String> workerUrls = new ArrayList<String>(minionWorkerUrlToWorkerIdMap.keySet());
        LOGGER.debug("Getting task progress with workerUrls: {}", workerUrls);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(workerUrls, null, true, requestHeaders, timeoutMs);
        for (Map.Entry<String, String> entry2 : serviceResponse._httpResponses.entrySet()) {
            String worker = entry2.getKey();
            String resp = entry2.getValue();
            LOGGER.debug("Got resp: {} from worker: {}", (Object)resp, (Object)worker);
            minionWorkerIdSubtaskProgressMap.put(minionWorkerUrlToWorkerIdMap.get(worker), JsonUtils.stringToObject((String)resp, Map.class));
        }
        if (serviceResponse._failedResponseCount > 0) {
            LOGGER.warn("There were {} workers failed to report task progress. Got partial progress info: {}", (Object)serviceResponse._failedResponseCount, minionWorkerIdSubtaskProgressMap);
        }
        return minionWorkerIdSubtaskProgressMap;
    }

    public synchronized Map<String, TaskState> getTaskStatesByTable(String taskType, String tableNameWithType) {
        HashMap<String, TaskState> filteredTaskStateMap = new HashMap<String, TaskState>();
        Map<String, TaskState> taskStateMap = this.getTaskStates(taskType);
        block0: for (Map.Entry<String, TaskState> taskState : taskStateMap.entrySet()) {
            String taskName = taskState.getKey();
            for (PinotTaskConfig taskConfig : this.getSubtaskConfigs(taskName)) {
                String tableNameConfig = taskConfig.getTableName();
                if (tableNameConfig == null || !tableNameConfig.equals(tableNameWithType)) continue;
                filteredTaskStateMap.put(taskName, taskStateMap.get(taskName));
                continue block0;
            }
        }
        return filteredTaskStateMap;
    }

    public synchronized Map<String, TaskCount> getTaskCounts(String taskType) {
        Set<String> tasks = this.getTasks(taskType);
        TreeMap<String, TaskCount> taskCounts = new TreeMap<String, TaskCount>();
        for (String taskName : tasks) {
            taskCounts.put(taskName, this.getTaskCount(taskName));
        }
        return taskCounts;
    }

    public synchronized Map<String, TaskDebugInfo> getTasksDebugInfo(String taskType, int verbosity) {
        TreeMap<String, TaskDebugInfo> taskDebugInfos = new TreeMap<String, TaskDebugInfo>();
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext == null) {
            return taskDebugInfos;
        }
        Map helixJobStates = workflowContext.getJobStates();
        for (String helixJobName : helixJobStates.keySet()) {
            taskDebugInfos.put(PinotHelixTaskResourceManager.getPinotTaskName(helixJobName), this.getTaskDebugInfo(workflowContext, helixJobName, verbosity));
        }
        return taskDebugInfos;
    }

    public synchronized Map<String, TaskDebugInfo> getTasksDebugInfoByTable(String taskType, String tableNameWithType, int verbosity) {
        TreeMap<String, TaskDebugInfo> taskDebugInfos = new TreeMap<String, TaskDebugInfo>();
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext == null) {
            return taskDebugInfos;
        }
        Map helixJobStates = workflowContext.getJobStates();
        block0: for (String helixJobName : helixJobStates.keySet()) {
            String pinotTaskName = PinotHelixTaskResourceManager.getPinotTaskName(helixJobName);
            for (PinotTaskConfig taskConfig : this.getSubtaskConfigs(pinotTaskName)) {
                String tableNameConfig;
                Map pinotConfigs = taskConfig.getConfigs();
                if (pinotConfigs == null || (tableNameConfig = (String)pinotConfigs.get("tableName")) == null || !tableNameConfig.equals(tableNameWithType)) continue;
                taskDebugInfos.put(pinotTaskName, this.getTaskDebugInfo(workflowContext, helixJobName, verbosity));
                continue block0;
            }
        }
        return taskDebugInfos;
    }

    public synchronized TaskDebugInfo getTaskDebugInfo(String taskName, int verbosity) {
        String taskType = PinotHelixTaskResourceManager.getTaskType(taskName);
        WorkflowContext workflowContext = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType));
        if (workflowContext == null) {
            return null;
        }
        String helixJobName = PinotHelixTaskResourceManager.getHelixJobName(taskName);
        return this.getTaskDebugInfo(workflowContext, helixJobName, verbosity);
    }

    private synchronized TaskDebugInfo getTaskDebugInfo(WorkflowContext workflowContext, String helixJobName, int verbosity) {
        JobContext jobContext;
        boolean showCompleted = verbosity > 0;
        TaskDebugInfo taskDebugInfo = new TaskDebugInfo();
        taskDebugInfo.setTaskState(workflowContext.getJobState(helixJobName));
        long jobStartTimeMs = workflowContext.getJobStartTime(helixJobName);
        if (jobStartTimeMs > 0L) {
            taskDebugInfo.setStartTime(DateTimeUtils.epochToDefaultDateFormat((long)jobStartTimeMs));
        }
        if ((jobContext = this._taskDriver.getJobContext(helixJobName)) != null) {
            long jobFinishTimeMs;
            JobConfig jobConfig = this._taskDriver.getJobConfig(helixJobName);
            long jobExecutionStartTimeMs = jobContext.getExecutionStartTime();
            if (jobExecutionStartTimeMs > 0L) {
                taskDebugInfo.setExecutionStartTime(DateTimeUtils.epochToDefaultDateFormat((long)jobExecutionStartTimeMs));
            }
            if ((jobFinishTimeMs = jobContext.getFinishTime()) > 0L) {
                taskDebugInfo.setFinishTime(DateTimeUtils.epochToDefaultDateFormat((long)jobFinishTimeMs));
            }
            Set partitionSet = jobContext.getPartitionSet();
            TaskCount subtaskCount = new TaskCount();
            Iterator iterator = partitionSet.iterator();
            while (iterator.hasNext()) {
                long subtaskFinishTimeMs;
                int partition = (Integer)iterator.next();
                TaskPartitionState partitionState = jobContext.getPartitionState(partition);
                subtaskCount.addTaskState(partitionState);
                if (!showCompleted && partitionState == TaskPartitionState.COMPLETED) continue;
                SubtaskDebugInfo subtaskDebugInfo = new SubtaskDebugInfo();
                String taskIdForPartition = jobContext.getTaskIdForPartition(partition);
                subtaskDebugInfo.setTaskId(taskIdForPartition);
                subtaskDebugInfo.setState(partitionState);
                long subtaskStartTimeMs = jobContext.getPartitionStartTime(partition);
                if (subtaskStartTimeMs > 0L) {
                    subtaskDebugInfo.setStartTime(DateTimeUtils.epochToDefaultDateFormat((long)subtaskStartTimeMs));
                }
                if ((subtaskFinishTimeMs = jobContext.getPartitionFinishTime(partition)) > 0L) {
                    subtaskDebugInfo.setFinishTime(DateTimeUtils.epochToDefaultDateFormat((long)subtaskFinishTimeMs));
                }
                subtaskDebugInfo.setParticipant(jobContext.getAssignedParticipant(partition));
                subtaskDebugInfo.setInfo(jobContext.getPartitionInfo(partition));
                TaskConfig helixTaskConfig = jobConfig.getTaskConfig(taskIdForPartition);
                if (helixTaskConfig != null) {
                    PinotTaskConfig pinotTaskConfig = PinotTaskConfig.fromHelixTaskConfig((TaskConfig)helixTaskConfig);
                    subtaskDebugInfo.setTaskConfig(pinotTaskConfig);
                }
                taskDebugInfo.addSubtaskInfo(subtaskDebugInfo);
            }
            taskDebugInfo.setSubtaskCount(subtaskCount);
        }
        return taskDebugInfo;
    }

    public static String getHelixJobQueueName(String taskType) {
        return TASK_QUEUE_PREFIX + taskType;
    }

    public static String getHelixJobName(String pinotTaskName) {
        return PinotHelixTaskResourceManager.getHelixJobQueueName(PinotHelixTaskResourceManager.getTaskType(pinotTaskName)) + TASK_NAME_SEPARATOR + pinotTaskName;
    }

    private static String getPinotTaskName(String helixJobName) {
        return helixJobName.substring(TASK_QUEUE_PREFIX.length() + PinotHelixTaskResourceManager.getTaskType(helixJobName).length() + 1);
    }

    private static String getTaskType(String name) {
        return name.split(TASK_NAME_SEPARATOR)[1];
    }

    public String getParentTaskName(String taskType, String taskName) {
        return TASK_PREFIX + taskType + TASK_NAME_SEPARATOR + taskName;
    }

    public String getTaskMetadataByTable(String taskType, String tableNameWithType) throws JsonProcessingException {
        ZkHelixPropertyStore<ZNRecord> propertyStore = this._helixResourceManager.getPropertyStore();
        ZNRecord raw = MinionTaskMetadataUtils.fetchTaskMetadata(propertyStore, (String)taskType, (String)tableNameWithType);
        if (raw == null) {
            return JsonUtils.objectToString((Object)JsonUtils.newObjectNode());
        }
        return JsonUtils.objectToString((Object)raw);
    }

    public void deleteTaskMetadataByTable(String taskType, String tableNameWithType) {
        ZkHelixPropertyStore<ZNRecord> propertyStore = this._helixResourceManager.getPropertyStore();
        MinionTaskMetadataUtils.deleteTaskMetadata(propertyStore, (String)taskType, (String)tableNameWithType);
    }

    public Map<String, Map<String, Long>> getTaskMetadataLastUpdateTimeMs() {
        ZkHelixPropertyStore<ZNRecord> propertyStore = this._helixResourceManager.getPropertyStore();
        return MinionTaskMetadataUtils.getAllTaskMetadataLastUpdateTimeMs(propertyStore);
    }

    @JsonPropertyOrder(value={"total", "completed", "running", "waiting", "error", "unknown"})
    public static class TaskCount {
        private int _waiting;
        private int _error;
        private int _running;
        private int _completed;
        private int _unknown;
        private int _total;

        public void addTaskState(TaskPartitionState state) {
            ++this._total;
            if (state == null) {
                ++this._waiting;
            } else {
                switch (state) {
                    case INIT: 
                    case RUNNING: {
                        ++this._running;
                        break;
                    }
                    case TASK_ERROR: {
                        ++this._error;
                        break;
                    }
                    case COMPLETED: {
                        ++this._completed;
                        break;
                    }
                    default: {
                        ++this._unknown;
                    }
                }
            }
        }

        public int getWaiting() {
            return this._waiting;
        }

        public int getRunning() {
            return this._running;
        }

        public int getTotal() {
            return this._total;
        }

        public int getError() {
            return this._error;
        }

        public int getCompleted() {
            return this._completed;
        }

        public int getUnknown() {
            return this._unknown;
        }

        public void accumulate(TaskCount other) {
            this._waiting += other.getWaiting();
            this._running += other.getRunning();
            this._error += other.getError();
            this._completed += other.getCompleted();
            this._unknown += other.getUnknown();
            this._total += other.getTotal();
        }
    }

    @JsonPropertyOrder(value={"taskId", "state", "startTime", "finishTime", "participant", "info", "taskConfig"})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class SubtaskDebugInfo {
        private String _taskId;
        private TaskPartitionState _state;
        private String _startTime;
        private String _finishTime;
        private String _participant;
        private String _info;
        private PinotTaskConfig _taskConfig;

        public void setTaskId(String taskId) {
            this._taskId = taskId;
        }

        public void setState(TaskPartitionState state) {
            this._state = state;
        }

        public void setStartTime(String startTime) {
            this._startTime = startTime;
        }

        public void setFinishTime(String finishTime) {
            this._finishTime = finishTime;
        }

        public void setParticipant(String participant) {
            this._participant = participant;
        }

        public void setInfo(String info) {
            this._info = info;
        }

        public void setTaskConfig(PinotTaskConfig taskConfig) {
            this._taskConfig = taskConfig;
        }

        public String getTaskId() {
            return this._taskId;
        }

        public TaskPartitionState getState() {
            return this._state;
        }

        public String getStartTime() {
            return this._startTime;
        }

        public String getFinishTime() {
            return this._finishTime;
        }

        public String getParticipant() {
            return this._participant;
        }

        public String getInfo() {
            return this._info;
        }

        public PinotTaskConfig getTaskConfig() {
            return this._taskConfig;
        }
    }

    @JsonPropertyOrder(value={"taskState", "subtaskCount", "startTime", "executionStartTime", "finishTime", "subtaskInfos"})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class TaskDebugInfo {
        private String _startTime;
        private String _executionStartTime;
        private String _finishTime;
        private TaskState _taskState;
        private TaskCount _subtaskCount;
        private List<SubtaskDebugInfo> _subtaskInfos;

        public void setStartTime(String startTime) {
            this._startTime = startTime;
        }

        public void setExecutionStartTime(String executionStartTime) {
            this._executionStartTime = executionStartTime;
        }

        public void setFinishTime(String finishTime) {
            this._finishTime = finishTime;
        }

        public void setTaskState(TaskState taskState) {
            this._taskState = taskState;
        }

        public void setSubtaskCount(TaskCount subtaskCount) {
            this._subtaskCount = subtaskCount;
        }

        public void addSubtaskInfo(SubtaskDebugInfo subtaskInfo) {
            if (this._subtaskInfos == null) {
                this._subtaskInfos = new ArrayList<SubtaskDebugInfo>();
            }
            this._subtaskInfos.add(subtaskInfo);
        }

        public String getStartTime() {
            return this._startTime;
        }

        public String getExecutionStartTime() {
            return this._executionStartTime;
        }

        public String getFinishTime() {
            return this._finishTime;
        }

        public TaskState getTaskState() {
            return this._taskState;
        }

        public TaskCount getSubtaskCount() {
            return this._subtaskCount;
        }

        public List<SubtaskDebugInfo> getSubtaskInfos() {
            return this._subtaskInfos;
        }
    }
}

