/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment.strategy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategy;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicaGroupSegmentAssignmentStrategy
implements SegmentAssignmentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicaGroupSegmentAssignmentStrategy.class);
    private static HelixManager _helixManager;
    private static String _tableName;
    private static String _partitionColumn;
    private int _replication;
    private TableConfig _tableConfig;

    ReplicaGroupSegmentAssignmentStrategy() {
    }

    @Override
    public void init(HelixManager helixManager, TableConfig tableConfig) {
        _helixManager = helixManager;
        this._tableConfig = tableConfig;
        _tableName = tableConfig.getTableName();
        SegmentsValidationAndRetentionConfig validationAndRetentionConfig = tableConfig.getValidationConfig();
        Preconditions.checkState((validationAndRetentionConfig != null ? 1 : 0) != 0, (Object)"Validation Config is null");
        this._replication = tableConfig.getReplication();
        _partitionColumn = TableConfigUtils.getPartitionColumn((TableConfig)this._tableConfig);
        if (_partitionColumn == null) {
            LOGGER.info("Initialized ReplicaGroupSegmentAssignmentStrategy with replication: {} without partition column for table: {} ", (Object)this._replication, (Object)_tableName);
        } else {
            LOGGER.info("Initialized ReplicaGroupSegmentAssignmentStrategy with replication: {} and partition column: {} for table: {}", new Object[]{this._replication, _partitionColumn, _tableName});
        }
    }

    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, InstancePartitionsType instancePartitionsType) {
        int numPartitions = instancePartitions.getNumPartitions();
        ReplicaGroupSegmentAssignmentStrategy.checkReplication(instancePartitions, this._replication, _tableName);
        int partitionId = _partitionColumn == null || numPartitions == 1 ? 0 : (this._tableConfig.getTableType() == TableType.OFFLINE ? SegmentAssignmentUtils.getOfflineSegmentPartitionId(segmentName, _tableName, _helixManager, _partitionColumn) % numPartitions : SegmentAssignmentUtils.getRealtimeSegmentPartitionId(segmentName, _tableName, _helixManager, _partitionColumn) % numPartitions);
        return SegmentAssignmentUtils.assignSegmentWithReplicaGroup(currentAssignment, instancePartitions, partitionId);
    }

    @Override
    public Map<String, Map<String, String>> reassignSegments(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, InstancePartitionsType instancePartitionsType) {
        int numPartitions = instancePartitions.getNumPartitions();
        ReplicaGroupSegmentAssignmentStrategy.checkReplication(instancePartitions, this._replication, _tableName);
        if (_partitionColumn == null || numPartitions == 1) {
            ArrayList<String> segments = new ArrayList<String>(currentAssignment.keySet());
            Collections.shuffle(segments, new Random(_tableName.hashCode()));
            TreeMap<String, Map<String, String>> newAssignment = new TreeMap<String, Map<String, String>>();
            SegmentAssignmentUtils.rebalanceReplicaGroupBasedPartition(currentAssignment, instancePartitions, 0, segments, newAssignment);
            return newAssignment;
        }
        Map<Integer, List<String>> instancePartitionIdToSegmentsMap = this._tableConfig.getTableType() == TableType.OFFLINE ? SegmentAssignmentUtils.getOfflineInstancePartitionIdToSegmentsMap(currentAssignment.keySet(), instancePartitions.getNumPartitions(), _tableName, _helixManager, _partitionColumn) : SegmentAssignmentUtils.getRealtimeInstancePartitionIdToSegmentsMap(currentAssignment.keySet(), instancePartitions.getNumPartitions(), _tableName, _helixManager, _partitionColumn);
        Random random = new Random(_tableName.hashCode());
        for (List<String> segments : instancePartitionIdToSegmentsMap.values()) {
            Collections.shuffle(segments, random);
        }
        return SegmentAssignmentUtils.rebalanceReplicaGroupBasedTable(currentAssignment, instancePartitions, instancePartitionIdToSegmentsMap);
    }

    private static void checkReplication(InstancePartitions instancePartitions, int replication, String tableName) {
        int numReplicaGroups = instancePartitions.getNumReplicaGroups();
        if (numReplicaGroups != replication) {
            LOGGER.warn("Number of replica-groups in instance partitions {}: {} does not match replication in table config: {} for table: {}, using: {}", new Object[]{instancePartitions.getInstancePartitionsName(), numReplicaGroups, replication, tableName, numReplicaGroups});
        }
    }
}

