/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment.strategy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategy;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllServersSegmentAssignmentStrategy
implements SegmentAssignmentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllServersSegmentAssignmentStrategy.class);
    private HelixManager _helixManager;
    private String _offlineTableName;
    private TenantConfig _tenantConfig;

    @Override
    public void init(HelixManager helixManager, TableConfig tableConfig) {
        this._helixManager = helixManager;
        this._offlineTableName = tableConfig.getTableName();
        this._tenantConfig = tableConfig.getTenantConfig();
        LOGGER.info("Initialized AllServersSegmentAssignmentStrategy for table: {}", (Object)this._offlineTableName);
    }

    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, InstancePartitionsType instancePartitionsType) {
        String serverTag = this._tenantConfig.getServer();
        Set instances = HelixHelper.getServerInstancesForTenant((HelixManager)this._helixManager, (String)serverTag);
        int numInstances = instances.size();
        Preconditions.checkState((numInstances > 0 ? 1 : 0) != 0, (String)"No instance found with tag: %s or %s", (Object)TagNameUtils.getOfflineTagForTenant((String)serverTag), (Object)TagNameUtils.getRealtimeTagForTenant((String)serverTag));
        return new ArrayList<String>(instances);
    }

    @Override
    public Map<String, Map<String, String>> reassignSegments(Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, InstancePartitionsType instancePartitionsType) {
        String serverTag = this._tenantConfig.getServer();
        Set instances = HelixHelper.getServerInstancesForTenant((HelixManager)this._helixManager, (String)serverTag);
        TreeMap<String, Map<String, String>> newAssignment = new TreeMap<String, Map<String, String>>();
        for (String segment : currentAssignment.keySet()) {
            newAssignment.put(segment, SegmentAssignmentUtils.getInstanceStateMap(instances, "ONLINE"));
        }
        return newAssignment;
    }
}

