/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.controller.helix.core.assignment.segment.BaseSegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.AllServersSegmentAssignmentStrategy;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategy;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategyFactory;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;

public class OfflineSegmentAssignment
extends BaseSegmentAssignment {
    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap) {
        InstancePartitions instancePartitions = instancePartitionsMap.get(InstancePartitionsType.OFFLINE);
        Preconditions.checkState((instancePartitions != null ? 1 : 0) != 0, (String)"Failed to find OFFLINE instance partitions for table: %s", (Object)this._tableNameWithType);
        SegmentAssignmentStrategy segmentAssignmentStrategy = SegmentAssignmentStrategyFactory.getSegmentAssignmentStrategy(this._helixManager, this._tableConfig, InstancePartitionsType.OFFLINE.toString(), instancePartitions);
        this._logger.info("Assigning segment: {} with instance partitions: {} for table: {}", new Object[]{segmentName, instancePartitions, this._tableNameWithType});
        List<String> instancesAssigned = segmentAssignmentStrategy.assignSegment(segmentName, currentAssignment, instancePartitions, InstancePartitionsType.OFFLINE);
        this._logger.info("Assigned segment: {} to instances: {} for table: {}", new Object[]{segmentName, instancesAssigned, this._tableNameWithType});
        return instancesAssigned;
    }

    @Override
    public Map<String, Map<String, String>> rebalanceTable(Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap, @Nullable List<Tier> sortedTiers, @Nullable Map<String, InstancePartitions> tierInstancePartitionsMap, Configuration config) {
        InstancePartitions offlineInstancePartitions = instancePartitionsMap.get(InstancePartitionsType.OFFLINE);
        Preconditions.checkState((offlineInstancePartitions != null ? 1 : 0) != 0, (String)"Failed to find OFFLINE instance partitions for table: %s", (Object)this._tableNameWithType);
        SegmentAssignmentStrategy segmentAssignmentStrategy = SegmentAssignmentStrategyFactory.getSegmentAssignmentStrategy(this._helixManager, this._tableConfig, InstancePartitionsType.OFFLINE.toString(), offlineInstancePartitions);
        if (segmentAssignmentStrategy instanceof AllServersSegmentAssignmentStrategy) {
            return segmentAssignmentStrategy.reassignSegments(currentAssignment, offlineInstancePartitions, InstancePartitionsType.OFFLINE);
        }
        boolean bootstrap = config.getBoolean("bootstrap", false);
        Pair<List<Map<String, Map<String, String>>>, Map<String, Map<String, String>>> pair = this.rebalanceTiers(currentAssignment, sortedTiers, tierInstancePartitionsMap, bootstrap, InstancePartitionsType.OFFLINE);
        List newTierAssignments = (List)pair.getLeft();
        Map nonTierAssignment = (Map)pair.getRight();
        this._logger.info("Rebalancing table: {} with instance partitions: {}, bootstrap: {}", new Object[]{this._tableNameWithType, offlineInstancePartitions, bootstrap});
        Map<String, Map<String, String>> newAssignment = this.reassignSegments(InstancePartitionsType.OFFLINE.toString(), nonTierAssignment, offlineInstancePartitions, bootstrap, segmentAssignmentStrategy, InstancePartitionsType.OFFLINE);
        if (CollectionUtils.isNotEmpty((Collection)newTierAssignments)) {
            newTierAssignments.forEach(newAssignment::putAll);
        }
        this._logger.info("Rebalanced table: {}, number of segments to be moved to each instance: {}", (Object)this._tableNameWithType, SegmentAssignmentUtils.getNumSegmentsToBeMovedPerInstance(currentAssignment, newAssignment));
        return newAssignment;
    }
}

