/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.TableAndSchemaConfig;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Upsert"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotUpsertRestletResource {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotUpsertRestletResource.class);

    @POST
    @Path(value="/upsert/estimateHeapUsage")
    @Authorize(targetType=TargetType.CLUSTER, action="EstimateUpsertMemory")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Estimate memory usage for an upsert table", notes="This API returns the estimated heap usage based on primary key column stats. This allows us to estimate table size before onboarding.")
    public String estimateHeapUsage(String tableSchemaConfigStr, @ApiParam(value="cardinality", required=true) @QueryParam(value="cardinality") long cardinality, @ApiParam(value="primaryKeySize", defaultValue="-1") @QueryParam(value="primaryKeySize") int primaryKeySize, @ApiParam(value="numPartitions", defaultValue="-1") @QueryParam(value="numPartitions") int numPartitions) {
        TableAndSchemaConfig tableSchemaConfig;
        ObjectNode resultData = JsonUtils.newObjectNode();
        try {
            tableSchemaConfig = (TableAndSchemaConfig)JsonUtils.stringToObject((String)tableSchemaConfigStr, TableAndSchemaConfig.class);
        }
        catch (IOException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Invalid TableSchemaConfigs json string: %s", tableSchemaConfigStr), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        TableConfig tableConfig = tableSchemaConfig.getTableConfig();
        resultData.put("tableName", tableConfig.getTableName());
        Schema schema = tableSchemaConfig.getSchema();
        int bytesPerKey = 0;
        List primaryKeys = schema.getPrimaryKeyColumns();
        if (primaryKeySize > 0) {
            bytesPerKey = primaryKeySize;
        } else {
            for (String primaryKey : primaryKeys) {
                FieldSpec.DataType dt = schema.getFieldSpecFor(primaryKey).getDataType();
                if (!dt.isFixedWidth()) {
                    String msg = "Primary key sizes much be provided for non fixed-width columns";
                    throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST);
                }
                bytesPerKey += dt.size();
            }
            bytesPerKey += 32;
        }
        int bytesPerValue = 60;
        List comparisonColumns = tableConfig.getUpsertConfig().getComparisonColumns();
        if (comparisonColumns != null) {
            int bytesPerArrayElem = 8;
            bytesPerValue = 52;
            for (String columnName : comparisonColumns) {
                FieldSpec.DataType dt = schema.getFieldSpecFor(columnName).getDataType();
                if (!dt.isFixedWidth()) {
                    String msg = "Not support data types for the comparison column";
                    throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST);
                }
                if (comparisonColumns.size() == 1) {
                    bytesPerValue += dt.size();
                    continue;
                }
                bytesPerValue += bytesPerArrayElem + dt.size();
            }
            if (comparisonColumns.size() > 1) {
                bytesPerValue += 52;
            }
        }
        resultData.put("bytesPerKey", bytesPerKey);
        resultData.put("bytesPerValue", bytesPerValue);
        long totalKeySpace = (long)bytesPerKey * cardinality;
        long totalValueSpace = (long)bytesPerValue * cardinality;
        long totalSpace = totalKeySpace + totalValueSpace;
        resultData.put("totalKeySpace(bytes)", totalKeySpace);
        resultData.put("totalValueSpace(bytes)", totalValueSpace);
        resultData.put("totalSpace(bytes)", totalSpace);
        if (numPartitions > 0) {
            double totalSpacePerPartition = (double)totalSpace * 1.0 / (double)numPartitions;
            resultData.put("numPartitions", numPartitions);
            resultData.put("totalSpacePerPartition(bytes)", totalSpacePerPartition);
        }
        return resultData.toString();
    }
}

