/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotTableMetadataConfigs {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableMetadataConfigs.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @Deprecated
    @PUT
    @Path(value="/tables/{tableName}/metadataConfigs")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="UpdateTableConfig")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update table metadata", notes="Updates table configuration")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Table not found")})
    public SuccessResponse updateTableMetadata(@PathParam(value="tableName") String tableName, String tableConfigString) {
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigString, TableConfig.class);
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s", tableName);
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            this._pinotHelixResourceManager.updateMetadataConfigFor(tableConfig.getTableName(), tableConfig.getTableType(), tableConfig.getCustomConfig());
            return new SuccessResponse("Successfully updated " + tableName + " configuration");
        }
        catch (Exception e) {
            String errStr = "Error while updating table configuration, table: " + tableName;
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

