/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.InstanceInfo;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotTableInstances {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableInstances.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Path(value="/tables/{tableName}/instances")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetInstance")
    @Produces(value={"application/json"})
    @ApiOperation(value="List table instances", notes="List instances of the given table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public String getTableInstances(@ApiParam(value="Table name without type", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Instance type", example="broker", allowableValues="BROKER, SERVER") @DefaultValue(value="") @QueryParam(value="type") String type) {
        ArrayNode a;
        ObjectNode e;
        ObjectNode ret = JsonUtils.newObjectNode();
        ret.put("tableName", tableName);
        ArrayNode brokers = JsonUtils.newArrayNode();
        ArrayNode servers = JsonUtils.newArrayNode();
        if (type == null || type.isEmpty() || type.toLowerCase().equals("broker")) {
            if (this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "offline");
                a = JsonUtils.newArrayNode();
                for (String ins : this._pinotHelixResourceManager.getBrokerInstancesForTable(tableName, TableType.OFFLINE)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                brokers.add((JsonNode)e);
            }
            if (this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "realtime");
                a = JsonUtils.newArrayNode();
                for (String ins : this._pinotHelixResourceManager.getBrokerInstancesForTable(tableName, TableType.REALTIME)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                brokers.add((JsonNode)e);
            }
        }
        if (type == null || type.isEmpty() || type.toLowerCase().equals("server")) {
            if (this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "offline");
                a = JsonUtils.newArrayNode();
                for (String ins : this._pinotHelixResourceManager.getServerInstancesForTable(tableName, TableType.OFFLINE)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                servers.add((JsonNode)e);
            }
            if (this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "realtime");
                a = JsonUtils.newArrayNode();
                for (String ins : this._pinotHelixResourceManager.getServerInstancesForTable(tableName, TableType.REALTIME)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                servers.add((JsonNode)e);
            }
        }
        ret.set("brokers", (JsonNode)brokers);
        ret.set("server", (JsonNode)servers);
        return ret.toString();
    }

    @GET
    @Path(value="/tables/{tableName}/livebrokers")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetBroker")
    @Produces(value={"application/json"})
    @ApiOperation(value="List the brokers serving a table", notes="List live brokers of the given table based on EV")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public List<String> getLiveBrokersForTable(@ApiParam(value="Table name (with or without type)", required=true) @PathParam(value="tableName") String tableName) {
        try {
            return this._pinotHelixResourceManager.getLiveBrokersForTable(tableName);
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/tables/livebrokers")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @Produces(value={"application/json"})
    @ApiOperation(value="List tables to live brokers mappings", notes="List tables to live brokers mappings based on EV")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Map<String, List<InstanceInfo>> getLiveBrokers() {
        try {
            return this._pinotHelixResourceManager.getTableToLiveBrokersMapping();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.NOT_FOUND);
        }
    }
}

