/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.api.resources.TrackInflightRequestMetrics;
import org.apache.pinot.controller.api.resources.TrackedByGauge;

@Singleton
@Provider
@TrackInflightRequestMetrics
public class InflightRequestMetricsInterceptor
implements ContainerRequestFilter,
WriterInterceptor {
    @Inject
    ControllerMetrics _controllerMetrics;
    @Context
    ResourceInfo _resourceInfo;

    public InflightRequestMetricsInterceptor() {
    }

    @VisibleForTesting
    public InflightRequestMetricsInterceptor(ControllerMetrics controllerMetrics, ResourceInfo resourceInfo) {
        this._controllerMetrics = controllerMetrics;
        this._resourceInfo = resourceInfo;
    }

    public void filter(ContainerRequestContext req) throws IOException {
        TrackedByGauge trackedByGauge = this._resourceInfo.getResourceMethod().getAnnotation(TrackedByGauge.class);
        if (trackedByGauge != null) {
            this._controllerMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)trackedByGauge.gauge(), 1L);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        try {
            ctx.proceed();
        }
        finally {
            TrackedByGauge trackedByGauge = this._resourceInfo.getResourceMethod().getAnnotation(TrackedByGauge.class);
            if (trackedByGauge != null) {
                this._controllerMetrics.addValueToGlobalGauge((AbstractMetrics.Gauge)trackedByGauge.gauge(), -1L);
            }
        }
    }
}

