/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.user.ComponentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger LOGGER = LoggerFactory.getLogger(Constants.class);
    public static final String CLUSTER_TAG = "Cluster";
    public static final String TABLE_TAG = "Table";
    public static final String USER_TAG = "User";
    public static final String VERSION_TAG = "Version";
    public static final String HEALTH_TAG = "Health";
    public static final String INSTANCE_TAG = "Instance";
    public static final String QUERY_TAG = "Query";
    public static final String SCHEMA_TAG = "Schema";
    public static final String TENANT_TAG = "Tenant";
    public static final String BROKER_TAG = "Broker";
    public static final String SEGMENT_TAG = "Segment";
    public static final String TASK_TAG = "Task";
    public static final String LEAD_CONTROLLER_TAG = "Leader";
    public static final String TABLE_NAME = "tableName";
    public static final String ZOOKEEPER = "Zookeeper";
    public static final String APP_CONFIGS = "AppConfigs";
    public static final String PERIODIC_TASK_TAG = "PeriodicTask";
    public static final String UPSERT_RESOURCE_TAG = "Upsert";
    public static final String REALTIME_SEGMENT_VALIDATION_MANAGER = "RealtimeSegmentValidationManager";

    private Constants() {
    }

    public static TableType validateTableType(String tableTypeStr) {
        if (StringUtils.isBlank((CharSequence)tableTypeStr)) {
            return null;
        }
        try {
            return TableType.valueOf((String)tableTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Illegal table type '{}'", (Object)tableTypeStr);
            throw new WebApplicationException("Illegal table type '" + tableTypeStr + "'", Response.Status.BAD_REQUEST);
        }
    }

    public static ComponentType validateComponentType(String componentTypeStr) {
        if (StringUtils.isBlank((CharSequence)componentTypeStr)) {
            return null;
        }
        try {
            return ComponentType.valueOf((String)componentTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Illegal table type '{}'", (Object)componentTypeStr);
            throw new WebApplicationException("Illegal table type '" + componentTypeStr + "'", Response.Status.BAD_REQUEST);
        }
    }

    public static StateType validateState(String stateStr) {
        if (StringUtils.isBlank((CharSequence)stateStr)) {
            return null;
        }
        try {
            return StateType.valueOf(stateStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Illegal state '{}'", (Object)stateStr);
            throw new WebApplicationException("Illegal state '" + stateStr + "'", Response.Status.BAD_REQUEST);
        }
    }
}

