/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.tuner;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.tuner.TableConfigTuner;
import org.apache.pinot.controller.tuner.TableConfigTunerRegistry;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TunerConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigTunerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableConfigTunerUtils.class);

    private TableConfigTunerUtils() {
    }

    public static void applyTunerConfigs(PinotHelixResourceManager pinotHelixResourceManager, TableConfig tableConfig, Schema schema, Map<String, String> extraProperties) {
        List tunerConfigs = tableConfig.getTunerConfigsList();
        if (CollectionUtils.isNotEmpty((Collection)tunerConfigs)) {
            for (TunerConfig tunerConfig : tunerConfigs) {
                TableConfigTunerUtils.applyTunerConfig(pinotHelixResourceManager, tunerConfig, tableConfig, schema, extraProperties);
            }
        }
    }

    public static void applyTunerConfig(PinotHelixResourceManager pinotHelixResourceManager, TunerConfig tunerConfig, TableConfig tableConfig, Schema schema, Map<String, String> extraProperties) {
        if (tunerConfig != null && tunerConfig.getName() != null && !tunerConfig.getName().isEmpty()) {
            try {
                TableConfigTuner tuner = TableConfigTunerRegistry.getTuner(tunerConfig.getName());
                tuner.apply(pinotHelixResourceManager, tableConfig, schema, extraProperties);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Exception occur when applying tuner: %s", tunerConfig.getName()), (Throwable)e);
            }
        }
    }
}

