/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.helix.task.TaskState;
import org.apache.pinot.common.data.Segment;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.core.minion.PinotTaskConfig;

public class TaskGeneratorUtils {
    private static final long ONE_DAY_IN_MILLIS = 86400000L;

    private TaskGeneratorUtils() {
    }

    public static Set<Segment> getRunningSegments(@Nonnull String taskType, @Nonnull ClusterInfoAccessor clusterInfoAccessor) {
        HashSet<Segment> runningSegments = new HashSet<Segment>();
        Map<String, TaskState> taskStates = clusterInfoAccessor.getTaskStates(taskType);
        for (Map.Entry<String, TaskState> entry : taskStates.entrySet()) {
            String taskName;
            if (entry.getValue() == TaskState.COMPLETED || TaskGeneratorUtils.isTaskOlderThanOneDay(taskName = entry.getKey())) continue;
            for (PinotTaskConfig pinotTaskConfig : clusterInfoAccessor.getTaskConfigs(entry.getKey())) {
                Map configs = pinotTaskConfig.getConfigs();
                runningSegments.add(new Segment((String)configs.get("tableName"), (String)configs.get("segmentName")));
            }
        }
        return runningSegments;
    }

    public static Map<String, TaskState> getIncompleteTasks(String taskType, String tableNameWithType, ClusterInfoAccessor clusterInfoAccessor) {
        HashMap<String, TaskState> nonCompletedTasks = new HashMap<String, TaskState>();
        Map<String, TaskState> taskStates = clusterInfoAccessor.getTaskStates(taskType);
        for (Map.Entry<String, TaskState> entry : taskStates.entrySet()) {
            String taskName;
            if (entry.getValue() == TaskState.COMPLETED || TaskGeneratorUtils.isTaskOlderThanOneDay(taskName = entry.getKey())) continue;
            for (PinotTaskConfig pinotTaskConfig : clusterInfoAccessor.getTaskConfigs(entry.getKey())) {
                if (!tableNameWithType.equals(pinotTaskConfig.getConfigs().get("tableName"))) continue;
                nonCompletedTasks.put(entry.getKey(), entry.getValue());
            }
        }
        return nonCompletedTasks;
    }

    private static boolean isTaskOlderThanOneDay(String taskName) {
        long scheduleTimeMs = Long.parseLong(taskName.substring(taskName.lastIndexOf("_") + 1));
        return System.currentTimeMillis() - scheduleTimeMs > 86400000L;
    }
}

