/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentStatusChecker
extends ControllerPeriodicTask<Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentStatusChecker.class);
    private static final int MAX_OFFLINE_SEGMENTS_TO_LOG = 5;
    public static final String ONLINE = "ONLINE";
    public static final String ERROR = "ERROR";
    public static final String CONSUMING = "CONSUMING";
    private static final long DISABLED_TABLE_LOG_INTERVAL_MS = TimeUnit.DAYS.toMillis(1L);
    private static final ZNRecordSerializer RECORD_SERIALIZER = new ZNRecordSerializer();
    private final int _waitForPushTimeSeconds;
    private long _lastDisabledTableLogTimestamp = 0L;

    public SegmentStatusChecker(PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerConf config, ControllerMetrics controllerMetrics) {
        super("SegmentStatusChecker", config.getStatusCheckerFrequencyInSeconds(), config.getStatusCheckerInitialDelayInSeconds(), pinotHelixResourceManager, leadControllerManager, controllerMetrics);
        this._waitForPushTimeSeconds = config.getStatusCheckerWaitForPushTimeInSeconds();
    }

    protected void setUpTask() {
        LOGGER.info("Initializing table metrics for all the tables.");
        this.setStatusToDefault();
    }

    @Override
    protected Context preprocess() {
        Context context = new Context();
        long now = System.currentTimeMillis();
        if (now - this._lastDisabledTableLogTimestamp >= DISABLED_TABLE_LOG_INTERVAL_MS) {
            context._logDisabledTables = true;
            this._lastDisabledTableLogTimestamp = now;
        }
        return context;
    }

    @Override
    protected void processTable(String tableNameWithType, Context context) {
        try {
            this.updateSegmentMetrics(tableNameWithType, context);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while updating segment status for table {}", (Object)tableNameWithType, (Object)e);
            this.resetTableMetrics(tableNameWithType);
        }
    }

    @Override
    protected void postprocess(Context context) {
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.REALTIME_TABLE_COUNT, (long)context._realTimeTableCount);
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.OFFLINE_TABLE_COUNT, (long)context._offlineTableCount);
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.DISABLED_TABLE_COUNT, (long)context._disabledTableCount);
    }

    private void updateSegmentMetrics(String tableNameWithType, Context context) {
        if (TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType) == TableType.OFFLINE) {
            ++context._offlineTableCount;
        } else {
            ++context._realTimeTableCount;
        }
        IdealState idealState = this._pinotHelixResourceManager.getTableIdealState(tableNameWithType);
        if (idealState == null) {
            LOGGER.warn("Table {} has null ideal state. Skipping segment status checks", (Object)tableNameWithType);
            this.resetTableMetrics(tableNameWithType);
            return;
        }
        if (!idealState.isEnabled()) {
            if (context._logDisabledTables) {
                LOGGER.warn("Table {} is disabled. Skipping segment status checks", (Object)tableNameWithType);
            }
            this.resetTableMetrics(tableNameWithType);
            ++context._disabledTableCount;
            return;
        }
        if (idealState.getPartitionSet().isEmpty()) {
            int nReplicasFromIdealState = 1;
            try {
                nReplicasFromIdealState = Integer.valueOf(idealState.getReplicas());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.NUMBER_OF_REPLICAS, (long)nReplicasFromIdealState);
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_OF_REPLICAS, 100L);
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_SEGMENTS_AVAILABLE, 100L);
            return;
        }
        this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.IDEALSTATE_ZNODE_SIZE, (long)idealState.toString().length());
        this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.IDEALSTATE_ZNODE_BYTE_SIZE, (long)idealState.serialize((ZkSerializer)RECORD_SERIALIZER).length);
        this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.SEGMENT_COUNT, (long)idealState.getPartitionSet().size());
        ExternalView externalView = this._pinotHelixResourceManager.getTableExternalView(tableNameWithType);
        int nReplicasIdealMax = 0;
        int nReplicasExternal = -1;
        int nErrors = 0;
        int nOffline = 0;
        int nSegments = 0;
        for (String partitionName : idealState.getPartitionSet()) {
            int nReplicas = 0;
            int nIdeal = 0;
            ++nSegments;
            for (Map.Entry serverAndState : idealState.getInstanceStateMap(partitionName).entrySet()) {
                if (serverAndState == null) break;
                if (!((String)serverAndState.getValue()).equals(ONLINE)) continue;
                ++nIdeal;
                break;
            }
            if (nIdeal == 0) continue;
            int n = nReplicasIdealMax = idealState.getInstanceStateMap(partitionName).size() > nReplicasIdealMax ? idealState.getInstanceStateMap(partitionName).size() : nReplicasIdealMax;
            if (externalView == null || externalView.getStateMap(partitionName) == null) {
                SegmentZKMetadata segmentZKMetadata;
                TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
                if (tableType != null && tableType.equals((Object)TableType.OFFLINE) && (segmentZKMetadata = this._pinotHelixResourceManager.getSegmentZKMetadata(tableNameWithType, partitionName)) != null && segmentZKMetadata.getPushTime() > System.currentTimeMillis() - (long)(this._waitForPushTimeSeconds * 1000)) continue;
                if (++nOffline < 5) {
                    LOGGER.warn("Segment {} of table {} has no replicas", (Object)partitionName, (Object)tableNameWithType);
                }
                nReplicasExternal = 0;
                continue;
            }
            for (Map.Entry serverAndState : externalView.getStateMap(partitionName).entrySet()) {
                if (((String)serverAndState.getValue()).equals(ONLINE) || ((String)serverAndState.getValue()).equals(CONSUMING)) {
                    ++nReplicas;
                }
                if (!((String)serverAndState.getValue()).equals(ERROR)) continue;
                ++nErrors;
            }
            if (nReplicas == 0) {
                if (nOffline < 5) {
                    LOGGER.warn("Segment {} of table {} has no online replicas", (Object)partitionName, (Object)tableNameWithType);
                }
                ++nOffline;
            }
            nReplicasExternal = nReplicasExternal > nReplicas || nReplicasExternal == -1 ? nReplicas : nReplicasExternal;
        }
        if (nReplicasExternal == -1) {
            nReplicasExternal = nReplicasIdealMax == 0 ? 1 : 0;
        }
        this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.NUMBER_OF_REPLICAS, (long)nReplicasExternal);
        this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_OF_REPLICAS, nReplicasIdealMax > 0 ? (long)(nReplicasExternal * 100 / nReplicasIdealMax) : 100L);
        this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.SEGMENTS_IN_ERROR_STATE, (long)nErrors);
        this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_SEGMENTS_AVAILABLE, nSegments > 0 ? (long)(100 - nOffline * 100 / nSegments) : 100L);
        if (nOffline > 0) {
            LOGGER.warn("Table {} has {} segments with no online replicas", (Object)tableNameWithType, (Object)nOffline);
        }
        if (nReplicasExternal < nReplicasIdealMax) {
            LOGGER.warn("Table {} has {} replicas, below replication threshold :{}", new Object[]{tableNameWithType, nReplicasExternal, nReplicasIdealMax});
        }
    }

    @Override
    protected void nonLeaderCleanup(List<String> tableNamesWithType) {
        for (String tableNameWithType : tableNamesWithType) {
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.NUMBER_OF_REPLICAS);
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_OF_REPLICAS);
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_SEGMENTS_AVAILABLE);
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.IDEALSTATE_ZNODE_SIZE);
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.IDEALSTATE_ZNODE_BYTE_SIZE);
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.SEGMENT_COUNT);
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.SEGMENTS_IN_ERROR_STATE);
            this._controllerMetrics.removeTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_SEGMENTS_AVAILABLE);
        }
    }

    private void setStatusToDefault() {
        List<String> allTableNames = this._pinotHelixResourceManager.getAllTables();
        for (String tableName : allTableNames) {
            this.resetTableMetrics(tableName);
        }
    }

    private void resetTableMetrics(String tableName) {
        this._controllerMetrics.setValueOfTableGauge(tableName, (AbstractMetrics.Gauge)ControllerGauge.NUMBER_OF_REPLICAS, Long.MIN_VALUE);
        this._controllerMetrics.setValueOfTableGauge(tableName, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_OF_REPLICAS, Long.MIN_VALUE);
        this._controllerMetrics.setValueOfTableGauge(tableName, (AbstractMetrics.Gauge)ControllerGauge.SEGMENTS_IN_ERROR_STATE, Long.MIN_VALUE);
        this._controllerMetrics.setValueOfTableGauge(tableName, (AbstractMetrics.Gauge)ControllerGauge.PERCENT_SEGMENTS_AVAILABLE, Long.MIN_VALUE);
    }

    public void cleanUpTask() {
        LOGGER.info("Resetting table metrics for all the tables.");
        this.setStatusToDefault();
    }

    public static final class Context {
        private boolean _logDisabledTables;
        private int _realTimeTableCount;
        private int _offlineTableCount;
        private int _disabledTableCount;
    }
}

