/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.CIDType0FontValidator;
import org.apache.pdfbox.preflight.font.CIDType2FontValidator;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.container.Type0Container;

public class Type0FontValidator
extends FontValidator<Type0Container> {
    protected final PDFont font;

    public Type0FontValidator(PreflightContext context, PDFont font) {
        super(context, font.getCOSObject(), new Type0Container(font));
        this.font = font;
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryFields();
        this.processDescendantFont();
        this.checkEncoding();
        this.checkToUnicode();
    }

    protected void checkMandatoryFields() {
        COSDictionary fontDictionary = this.font.getCOSObject();
        boolean areFieldsPResent = fontDictionary.containsKey(COSName.TYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.SUBTYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.BASE_FONT);
        areFieldsPResent &= fontDictionary.containsKey(COSName.DESCENDANT_FONTS);
        if (!(areFieldsPResent &= fontDictionary.containsKey(COSName.ENCODING))) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Some keys are missing from composite font dictionary"));
        }
    }

    protected void processDescendantFont() throws ValidationException {
        COSDictionary fontDictionary = this.font.getCOSObject();
        COSArray array = fontDictionary.getCOSArray(COSName.DESCENDANT_FONTS);
        if (array == null || array.size() != 1) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", this.font.getName() + ": CIDFont is missing from the DescendantFonts array or the size of array is greater than 1"));
            return;
        }
        COSDictionary cidFont = (COSDictionary)array.getObject(0);
        if (cidFont == null) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", this.font.getName() + ": The DescendantFonts array should have one element with is a dictionary."));
            return;
        }
        FontValidator<? extends FontContainer<? extends PDCIDFont>> cidFontValidator = this.createDescendantValidator(cidFont);
        if (cidFontValidator != null) {
            ((Type0Container)this.fontContainer).setDelegateFontContainer(cidFontValidator.getFontContainer());
            cidFontValidator.validate();
        }
    }

    protected FontValidator<? extends FontContainer<? extends PDCIDFont>> createDescendantValidator(COSDictionary cidFont) {
        COSName subtype = cidFont.getCOSName(COSName.SUBTYPE);
        FontValidator<FontContainer<Object>> cidFontValidator = null;
        if (COSName.CID_FONT_TYPE0.equals((Object)subtype)) {
            cidFontValidator = this.createCIDType0FontValidator(cidFont);
        } else if (COSName.CID_FONT_TYPE2.equals((Object)subtype)) {
            cidFontValidator = this.createCIDType2FontValidator(cidFont);
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Type and/or Subtype keys are missing"));
        }
        return cidFontValidator;
    }

    protected FontValidator<? extends FontContainer<PDCIDFontType0>> createCIDType0FontValidator(COSDictionary fDict) {
        try {
            return new CIDType0FontValidator(this.context, new PDCIDFontType0(fDict, (PDType0Font)this.font));
        }
        catch (IOException e) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.3", this.font.getName() + ": The CIDType0 font is damaged", e));
            return null;
        }
    }

    protected FontValidator<? extends FontContainer<PDCIDFontType2>> createCIDType2FontValidator(COSDictionary fDict) {
        try {
            return new CIDType2FontValidator(this.context, new PDCIDFontType2(fDict, (PDType0Font)this.font));
        }
        catch (IOException e) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.3", this.font.getName() + ": The CIDType2 font is damaged", e));
            return null;
        }
    }

    @Override
    protected void checkEncoding() {
        COSBase encoding = this.font.getCOSObject().getDictionaryObject(COSName.ENCODING);
        this.checkCMapEncoding(encoding);
    }

    protected void checkCMapEncoding(COSBase encoding) {
        if (encoding instanceof COSName || encoding instanceof COSString) {
            String str;
            String string = str = encoding instanceof COSName ? ((COSName)encoding).getName() : ((COSString)encoding).getString();
            if (!"Identity-V".equals(str) && !"Identity-H".equals(str)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", this.font.getName() + ": The CMap is a string but it isn't an Identity-H/V"));
            }
        } else if (encoding instanceof COSStream) {
            this.processCMapAsStream((COSStream)encoding);
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": The CMap type is invalid"));
        }
    }

    private void processCMapAsStream(COSStream aCMap) {
        this.checkCIDSystemInfo(aCMap.getCOSDictionary(COSName.CIDSYSTEMINFO));
        try (COSInputStream cmapStream = aCMap.createInputStream();){
            CMap fontboxCMap = new CMapParser(true).parse((InputStream)cmapStream);
            int wmValue = fontboxCMap.getWMode();
            String cmnValue = fontboxCMap.getName();
            int wmode = aCMap.getInt(COSName.WMODE, 0);
            COSName type = aCMap.getCOSName(COSName.TYPE);
            String cmapName = aCMap.getNameAsString(COSName.CMAPNAME);
            if (cmapName == null || "".equals(cmapName) || wmode > 1) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": Some elements in the CMap dictionary are missing or invalid"));
            } else if (wmValue != wmode || !cmapName.equals(cmnValue)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": CMapName or WMode is inconsistent"));
            } else if (!COSName.CMAP.equals((Object)type)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": The CMap type is invalid"));
            }
        }
        catch (IOException e) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.5", this.font.getName() + ": The CMap type is damaged", e));
        }
        COSDictionary cmapUsed = (COSDictionary)aCMap.getDictionaryObject(COSName.USE_CMAP);
        if (cmapUsed != null) {
            this.checkCMapEncoding((COSBase)cmapUsed);
        }
        this.compareCIDSystemInfo((COSDictionary)aCMap);
    }

    protected boolean checkCIDSystemInfo(COSDictionary cidSysInfo) {
        boolean result = true;
        if (cidSysInfo != null) {
            String reg = cidSysInfo.getString(COSName.REGISTRY);
            String ord = cidSysInfo.getString(COSName.ORDERING);
            COSBase sup = cidSysInfo.getDictionaryObject(COSName.SUPPLEMENT);
            if (reg == null || ord == null || !(sup instanceof COSInteger)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8"));
                result = false;
            }
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8"));
            result = false;
        }
        return result;
    }

    private void compareCIDSystemInfo(COSDictionary cmap) {
        COSDictionary fontDictionary = this.font.getCOSObject();
        COSArray array = fontDictionary.getCOSArray(COSName.DESCENDANT_FONTS);
        if (array != null && array.size() > 0) {
            COSDictionary cidFont = (COSDictionary)array.getObject(0);
            COSDictionary cmsi = cmap.getCOSDictionary(COSName.CIDSYSTEMINFO);
            COSDictionary cfsi = cidFont.getCOSDictionary(COSName.CIDSYSTEMINFO);
            String regCM = cmsi.getString(COSName.REGISTRY);
            String ordCM = cmsi.getString(COSName.ORDERING);
            String regCF = cfsi.getString(COSName.REGISTRY);
            String ordCF = cfsi.getString(COSName.ORDERING);
            if (!regCF.equals(regCM) || !ordCF.equals(ordCM)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8", this.font.getName() + ": The CIDSystemInfo is inconsistent"));
            }
        }
    }
}

