/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.utils;

import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.ValidationProcess;

public class ContextHelper {
    public static void validateElement(PreflightContext context, Object element, String processName) throws ValidationException {
        if (element == null) {
            context.addValidationError(new ValidationResult.ValidationError("8.1", "Unable to process an element if it is null."));
        } else {
            ContextHelper.callValidation(context, element, processName);
        }
    }

    private static void callValidation(PreflightContext context, Object element, String processName) throws ValidationException {
        PreflightPath validationPath = context.getValidationPath();
        boolean needPop = validationPath.pushObject(element);
        PreflightConfiguration config = context.getConfig();
        ValidationProcess process = config.getInstanceOfProcess(processName);
        process.validate(context);
        if (needPop) {
            validationPath.pop();
        }
    }

    public static void validateElement(PreflightContext context, String processName) throws ValidationException {
        ContextHelper.callValidation(context, null, processName);
    }
}

