/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import java.io.IOException;
import java.util.List;
import org.apache.fontbox.cff.CFFParser;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.CIDType0Container;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;
import org.apache.pdfbox.preflight.utils.COSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIDType0DescriptorHelper
extends FontDescriptorHelper<CIDType0Container> {
    public CIDType0DescriptorHelper(PreflightContext context, PDFont font, CIDType0Container fontContainer) {
        super(context, font, fontContainer);
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptorDictionary fontDescriptor) {
        PDStream ff3 = fontDescriptor.getFontFile3();
        if (ff3 != null) {
            COSStream stream = ff3.getStream();
            if (stream == null) {
                ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "The FontFile is missing for " + fontDescriptor.getFontName()));
                ((CIDType0Container)this.fContainer).notEmbedded();
            } else {
                String st = stream.getNameAsString(COSName.SUBTYPE);
                if (!"CIDFontType0C".equals(st) && !"Type1C".equals(st)) {
                    ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "The FontFile3 stream doesn't have the right Subtype for " + fontDescriptor.getFontName()));
                }
                this.checkCIDSet(fontDescriptor);
            }
        }
        return ff3;
    }

    protected void checkCIDSet(PDFontDescriptorDictionary pfDescriptor) {
        if (FontValidator.isSubSet(pfDescriptor.getFontName())) {
            COSDocument cosDocument = this.context.getDocument().getDocument();
            COSBase cidset = pfDescriptor.getCOSDictionary().getItem(COSName.getPDFName((String)"CIDSet"));
            if (cidset == null || !COSUtils.isStream(cidset, cosDocument)) {
                ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.11", "The CIDSet entry is missing for the Composite Subset"));
            }
        }
    }

    @Override
    protected void processFontFile(PDFontDescriptorDictionary fontDescriptor, PDStream fontFile) {
        try {
            CFFParser cffParser = new CFFParser();
            List lCFonts = cffParser.parse(fontFile.getByteArray());
            if (lCFonts == null || lCFonts.isEmpty()) {
                ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.3", "The FontFile can't be read"));
            }
            ((CIDType0Container)this.fContainer).setlCFonts(lCFonts);
        }
        catch (IOException e) {
            ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.3", "The FontFile can't be read"));
        }
    }
}

