/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class PageTreeValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext context) throws ValidationException {
        PDDocumentCatalog catalog = context.getDocument().getDocumentCatalog();
        if (catalog != null) {
            List pages = catalog.getAllPages();
            for (int i = 0; i < pages.size(); ++i) {
                this.validatePage(context, (PDPage)pages.get(i));
            }
        } else {
            context.addValidationError(new ValidationResult.ValidationError("1.2.14", "There are no Catalog entry in the Document."));
        }
    }

    protected void validatePage(PreflightContext context, PDPage page) throws ValidationException {
        ContextHelper.validateElement(context, page, "page-process");
    }
}

