/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.annotation;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.annotation.AnnotationValidator;
import org.apache.pdfbox.preflight.exception.ValidationException;

public class WidgetAnnotationValidator
extends AnnotationValidator {
    protected PDAnnotationWidget pdWidget = null;

    public WidgetAnnotationValidator(PreflightContext ctx, COSDictionary annotDictionary) {
        super(ctx, annotDictionary);
        this.pdWidget = new PDAnnotationWidget(annotDictionary);
        this.pdAnnot = this.pdWidget;
    }

    public boolean validate() throws ValidationException {
        boolean isValide = super.validate();
        isValide = isValide && this.checkAAField();
        return isValide;
    }

    protected boolean checkAAField() {
        if (this.pdWidget.getActions() != null) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.5"));
            return false;
        }
        return true;
    }

    protected boolean checkMandatoryFields() {
        boolean result;
        boolean subtype = this.annotDictionary.containsKey(COSName.SUBTYPE);
        boolean rect = this.annotDictionary.containsKey(COSName.RECT);
        boolean f = this.annotDictionary.containsKey(COSName.F);
        boolean bl = result = subtype && rect && f;
        if (!result) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.1"));
        }
        return result;
    }
}

