/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.cert.CertificateVerificationException;
import org.apache.pdfbox.examples.signature.cert.CertificateVerifier;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.util.Charsets;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public final class ShowSignature {
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    private ShowSignature() {
    }

    public static void main(String[] args) throws IOException, TSPException, GeneralSecurityException, CertificateVerificationException {
        Security.addProvider(SecurityProvider.getProvider());
        ShowSignature show = new ShowSignature();
        show.showSignature(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSignature(String[] args) throws IOException, TSPException, GeneralSecurityException, CertificateVerificationException {
        if (args.length != 2) {
            ShowSignature.usage();
        } else {
            String password = args[0];
            File infile = new File(args[1]);
            PDDocument document = null;
            try {
                RandomAccessBufferedFileInputStream raFile = new RandomAccessBufferedFileInputStream(infile);
                PDFParser parser = new PDFParser((RandomAccessRead)raFile, password);
                parser.setLenient(false);
                parser.parse();
                document = parser.getPDDocument();
                for (PDSignature sig : document.getSignatureDictionaries()) {
                    String subFilter;
                    COSDictionary sigDict = sig.getCOSObject();
                    byte[] contents = sig.getContents();
                    FileInputStream fis = new FileInputStream(infile);
                    byte[] buf = null;
                    try {
                        buf = sig.getSignedContent((InputStream)fis);
                    }
                    finally {
                        fis.close();
                    }
                    System.out.println("Signature found");
                    if (sig.getName() != null) {
                        System.out.println("Name:     " + sig.getName());
                    }
                    if (sig.getSignDate() != null) {
                        System.out.println("Modified: " + this.sdf.format(sig.getSignDate().getTime()));
                    }
                    if ((subFilter = sig.getSubFilter()) != null) {
                        if (subFilter.equals("adbe.pkcs7.detached") || subFilter.equals("ETSI.CAdES.detached")) {
                            this.verifyPKCS7(buf, contents, sig);
                        } else if (subFilter.equals("adbe.pkcs7.sha1")) {
                            CertificateFactory factory = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream certStream = new ByteArrayInputStream(contents);
                            Collection<? extends Certificate> certs = factory.generateCertificates(certStream);
                            System.out.println("certs=" + certs);
                            byte[] hash = MessageDigest.getInstance("SHA1").digest(buf);
                            this.verifyPKCS7(hash, contents, sig);
                        } else if (subFilter.equals("adbe.x509.rsa_sha1")) {
                            COSString certString = (COSString)sigDict.getDictionaryObject(COSName.CERT);
                            if (certString == null) {
                                System.err.println("The /Cert certificate string is missing in the signature dictionary");
                                return;
                            }
                            byte[] certData = certString.getBytes();
                            CertificateFactory factory = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream certStream = new ByteArrayInputStream(certData);
                            Collection<? extends Certificate> certs = factory.generateCertificates(certStream);
                            System.out.println("certs=" + certs);
                            X509Certificate cert = (X509Certificate)certs.iterator().next();
                            try {
                                if (sig.getSignDate() != null) {
                                    cert.checkValidity(sig.getSignDate().getTime());
                                    System.out.println("Certificate valid at signing time");
                                } else {
                                    System.err.println("Certificate cannot be verified without signing time");
                                }
                            }
                            catch (CertificateExpiredException ex) {
                                System.err.println("Certificate expired at signing time");
                            }
                            catch (CertificateNotYetValidException ex) {
                                System.err.println("Certificate not yet valid at signing time");
                            }
                            if (CertificateVerifier.isSelfSigned(cert)) {
                                System.err.println("Certificate is self-signed, LOL!");
                            } else {
                                System.out.println("Certificate is not self-signed");
                                if (sig.getSignDate() != null) {
                                    JcaCertStore store = new JcaCertStore(certs);
                                    SigUtils.verifyCertificateChain((Store<X509CertificateHolder>)store, cert, sig.getSignDate().getTime());
                                }
                            }
                        } else if (subFilter.equals("ETSI.RFC3161")) {
                            this.verifyETSIdotRFC3161(buf, contents);
                        } else {
                            System.err.println("Unknown certificate type: " + subFilter);
                        }
                    } else {
                        throw new IOException("Missing subfilter for cert dictionary");
                    }
                    int[] byteRange = sig.getByteRange();
                    if (byteRange.length != 4) {
                        System.err.println("Signature byteRange must have 4 items");
                        continue;
                    }
                    long fileLen = infile.length();
                    long rangeMax = (long)byteRange[2] + (long)byteRange[3];
                    int contentLen = contents.length * 2 + 2;
                    if (fileLen != rangeMax || byteRange[0] != 0 || byteRange[1] + contentLen != byteRange[2]) {
                        System.out.println("Signature does not cover whole document");
                    } else {
                        System.out.println("Signature covers whole document");
                    }
                    this.checkContentValueWithFile(infile, byteRange, contents);
                }
                this.analyseDSS(document);
            }
            catch (CMSException ex) {
                throw new IOException(ex);
            }
            catch (OperatorCreationException ex) {
                throw new IOException(ex);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
            System.out.println("Analyzed: " + args[1]);
        }
    }

    private void checkContentValueWithFile(File file, int[] byteRange, byte[] contents) throws IOException {
        byte[] contentAsHex;
        byte[] contentFromFile;
        RandomAccessBufferedFileInputStream raf = new RandomAccessBufferedFileInputStream(file);
        raf.seek((long)byteRange[1]);
        int c = raf.read();
        if (c != 60) {
            System.err.println("'<' expected at offset " + byteRange[1] + ", but got " + (char)c);
        }
        if ((contentFromFile = raf.readFully(byteRange[2] - byteRange[1] - 2)).length != (contentAsHex = Hex.getString((byte[])contents).getBytes(Charsets.US_ASCII)).length) {
            System.err.println("Raw content length from file is " + contentFromFile.length + ", but internal content string in hex has length " + contentAsHex.length);
        }
        for (int i = 0; i < contentFromFile.length; ++i) {
            try {
                if (Integer.parseInt(String.valueOf((char)contentFromFile[i]), 16) == Integer.parseInt(String.valueOf((char)contentAsHex[i]), 16)) continue;
                System.err.println("Possible manipulation at file offset " + (byteRange[1] + i + 1) + " in signature content");
            }
            catch (NumberFormatException ex) {
                System.err.println("Incorrect hex value");
                System.err.println("Possible manipulation at file offset " + (byteRange[1] + i + 1) + " in signature content");
            }
            break;
        }
        if ((c = raf.read()) != 62) {
            System.err.println("'>' expected at offset " + byteRange[2] + ", but got " + (char)c);
        }
        raf.close();
    }

    private void verifyETSIdotRFC3161(byte[] buf, byte[] contents) throws CertificateException, CMSException, IOException, OperatorCreationException, TSPException, NoSuchAlgorithmException, CertificateVerificationException {
        TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(contents));
        TimeStampTokenInfo timeStampInfo = timeStampToken.getTimeStampInfo();
        System.out.println("Time stamp gen time: " + timeStampInfo.getGenTime());
        if (timeStampInfo.getTsa() != null) {
            System.out.println("Time stamp tsa name: " + timeStampInfo.getTsa().getName());
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream certStream = new ByteArrayInputStream(contents);
        Collection<? extends Certificate> certs = factory.generateCertificates(certStream);
        System.out.println("certs=" + certs);
        String hashAlgorithm = timeStampInfo.getMessageImprintAlgOID().getId();
        if (Arrays.equals(MessageDigest.getInstance(hashAlgorithm).digest(buf), timeStampInfo.getMessageImprintDigest())) {
            System.out.println("ETSI.RFC3161 timestamp signature verified");
        } else {
            System.err.println("ETSI.RFC3161 timestamp signature verification failed");
        }
        X509Certificate certFromTimeStamp = (X509Certificate)certs.iterator().next();
        SigUtils.checkTimeStampCertificateUsage(certFromTimeStamp);
        SigUtils.validateTimestampToken(timeStampToken);
        SigUtils.verifyCertificateChain((Store<X509CertificateHolder>)timeStampToken.getCertificates(), certFromTimeStamp, timeStampInfo.getGenTime());
    }

    private void verifyPKCS7(byte[] byteArray, byte[] contents, PDSignature sig) throws CMSException, OperatorCreationException, IOException, GeneralSecurityException, TSPException, CertificateVerificationException {
        Attribute signingTime;
        CMSProcessableByteArray signedContent = new CMSProcessableByteArray(byteArray);
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)signedContent, contents);
        Store certificatesStore = signedData.getCertificates();
        if (certificatesStore.getMatches(null).isEmpty()) {
            throw new IOException("No certificates in signature");
        }
        Collection signers = signedData.getSignerInfos().getSigners();
        if (signers.isEmpty()) {
            throw new IOException("No signers in signature");
        }
        SignerInformation signerInformation = (SignerInformation)signers.iterator().next();
        Collection matches = certificatesStore.getMatches((Selector)signerInformation.getSID());
        if (matches.isEmpty()) {
            throw new IOException("Signer '" + signerInformation.getSID().getIssuer() + ", serial# " + signerInformation.getSID().getSerialNumber() + " does not match any certificates");
        }
        X509CertificateHolder certificateHolder = (X509CertificateHolder)matches.iterator().next();
        X509Certificate certFromSignedData = new JcaX509CertificateConverter().getCertificate(certificateHolder);
        System.out.println("certFromSignedData: " + certFromSignedData);
        SigUtils.checkCertificateUsage(certFromSignedData);
        TimeStampToken timeStampToken = SigUtils.extractTimeStampTokenFromSignerInformation(signerInformation);
        if (timeStampToken != null) {
            SigUtils.validateTimestampToken(timeStampToken);
            Collection tstMatches = timeStampToken.getCertificates().getMatches((Selector)timeStampToken.getSID());
            X509CertificateHolder tstCertHolder = (X509CertificateHolder)tstMatches.iterator().next();
            X509Certificate certFromTimeStamp = new JcaX509CertificateConverter().getCertificate(tstCertHolder);
            HashSet certificateHolderSet = new HashSet();
            certificateHolderSet.addAll(certificatesStore.getMatches(null));
            certificateHolderSet.addAll(timeStampToken.getCertificates().getMatches(null));
            SigUtils.verifyCertificateChain((Store<X509CertificateHolder>)new CollectionStore(certificateHolderSet), certFromTimeStamp, timeStampToken.getTimeStampInfo().getGenTime());
            SigUtils.checkTimeStampCertificateUsage(certFromTimeStamp);
            byte[] tsMessageImprintDigest = timeStampToken.getTimeStampInfo().getMessageImprintDigest();
            String hashAlgorithm = timeStampToken.getTimeStampInfo().getMessageImprintAlgOID().getId();
            byte[] sigMessageImprintDigest = MessageDigest.getInstance(hashAlgorithm).digest(signerInformation.getSignature());
            if (Arrays.equals(tsMessageImprintDigest, sigMessageImprintDigest)) {
                System.out.println("timestamp signature verified");
            } else {
                System.err.println("timestamp signature verification failed");
            }
        }
        try {
            if (sig.getSignDate() != null) {
                certFromSignedData.checkValidity(sig.getSignDate().getTime());
                System.out.println("Certificate valid at signing time");
            } else {
                System.err.println("Certificate cannot be verified without signing time");
            }
        }
        catch (CertificateExpiredException ex) {
            System.err.println("Certificate expired at signing time");
        }
        catch (CertificateNotYetValidException ex) {
            System.err.println("Certificate not yet valid at signing time");
        }
        if (signerInformation.getSignedAttributes() != null && (signingTime = signerInformation.getSignedAttributes().get(CMSAttributes.signingTime)) != null) {
            Time timeInstance = Time.getInstance((Object)signingTime.getAttrValues().getObjectAt(0));
            try {
                certFromSignedData.checkValidity(timeInstance.getDate());
                System.out.println("Certificate valid at signing time: " + timeInstance.getDate());
            }
            catch (CertificateExpiredException ex) {
                System.err.println("Certificate expired at signing time");
            }
            catch (CertificateNotYetValidException ex) {
                System.err.println("Certificate not yet valid at signing time");
            }
        }
        if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(SecurityProvider.getProvider()).build(certFromSignedData))) {
            System.out.println("Signature verified");
        } else {
            System.out.println("Signature verification failed");
        }
        if (CertificateVerifier.isSelfSigned(certFromSignedData)) {
            System.err.println("Certificate is self-signed, LOL!");
        } else {
            System.out.println("Certificate is not self-signed");
            if (sig.getSignDate() != null) {
                SigUtils.verifyCertificateChain((Store<X509CertificateHolder>)certificatesStore, certFromSignedData, sig.getSignDate().getTime());
            } else {
                System.err.println("Certificate cannot be verified without signing time");
            }
        }
    }

    private void analyseDSS(PDDocument document) throws IOException {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        COSBase dssElement = catalog.getCOSObject().getDictionaryObject(COSName.DSS);
        if (dssElement instanceof COSDictionary) {
            COSBase crlElement;
            COSBase ocspsElement;
            COSDictionary dss = (COSDictionary)dssElement;
            System.out.println("DSS Dictionary: " + dss);
            COSBase certsElement = dss.getDictionaryObject(COSName.CERTS);
            if (certsElement instanceof COSArray) {
                this.printStreamsFromArray((COSArray)certsElement, "Cert");
            }
            if ((ocspsElement = dss.getDictionaryObject(COSName.OCSPS)) instanceof COSArray) {
                this.printStreamsFromArray((COSArray)ocspsElement, "Ocsp");
            }
            if ((crlElement = dss.getDictionaryObject(COSName.CRLS)) instanceof COSArray) {
                this.printStreamsFromArray((COSArray)crlElement, "CRL");
            }
        }
    }

    private void printStreamsFromArray(COSArray elements, String description) throws IOException {
        for (COSBase baseElem : elements) {
            COSObject streamObj = (COSObject)baseElem;
            if (!(streamObj.getObject() instanceof COSStream)) continue;
            COSStream cosStream = (COSStream)streamObj.getObject();
            COSInputStream input = cosStream.createInputStream();
            byte[] streamBytes = IOUtils.toByteArray((InputStream)input);
            input.close();
            System.out.println(description + " (" + elements.indexOf((COSBase)streamObj) + "): " + Hex.getString((byte[])streamBytes));
        }
    }

    private static void usage() {
        System.err.println("usage: java " + ShowSignature.class.getName() + " <password (usually empty)> <inputfile>");
    }
}

