/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class AddImageToPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDFFromImage(String inputFile, String imagePath, String outputFile) throws IOException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load((File)new File(inputFile));
            PDPage page = doc.getPage(0);
            PDImageXObject pdImage = PDImageXObject.createFromFile((String)imagePath, (PDDocument)doc);
            PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
            float scale = 1.0f;
            contentStream.drawImage(pdImage, 20.0f, 20.0f, (float)pdImage.getWidth() * scale, (float)pdImage.getHeight() * scale);
            contentStream.close();
            doc.save(outputFile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        AddImageToPDF app = new AddImageToPDF();
        if (args.length != 3) {
            app.usage();
        } else {
            app.createPDFFromImage(args[0], args[1], args[2]);
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-pdf> <image> <output-pdf>");
    }
}

