/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdfparser.FDFParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.util.XMLUtil;

public class Loader {
    private Loader() {
    }

    public static FDFDocument loadFDF(String filename) throws IOException {
        return Loader.loadFDF(new File(filename));
    }

    public static FDFDocument loadFDF(File file) throws IOException {
        RandomAccessReadBufferedFile raFile = null;
        try {
            raFile = new RandomAccessReadBufferedFile(file);
            FDFParser parser = new FDFParser(raFile);
            return parser.parse();
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(raFile);
            throw ioe;
        }
    }

    public static FDFDocument loadFDF(InputStream input) throws IOException {
        try (RandomAccessReadBuffer readBuffer = new RandomAccessReadBuffer(input);){
            FDFParser parser = new FDFParser(readBuffer);
            FDFDocument fDFDocument = parser.parse();
            return fDFDocument;
        }
    }

    public static FDFDocument loadXFDF(String filename) throws IOException {
        return Loader.loadXFDF(new BufferedInputStream(new FileInputStream(filename)));
    }

    public static FDFDocument loadXFDF(File file) throws IOException {
        return Loader.loadXFDF(new BufferedInputStream(new FileInputStream(file)));
    }

    public static FDFDocument loadXFDF(InputStream input) throws IOException {
        return new FDFDocument(XMLUtil.parse(input));
    }

    public static PDDocument loadPDF(byte[] input) throws IOException {
        return Loader.loadPDF(input, "");
    }

    public static PDDocument loadPDF(byte[] input, String password) throws IOException {
        return Loader.loadPDF(input, password, null, null);
    }

    public static PDDocument loadPDF(byte[] input, String password, InputStream keyStore, String alias) throws IOException {
        return Loader.loadPDF(input, password, keyStore, alias, IOUtils.createMemoryOnlyStreamCache());
    }

    public static PDDocument loadPDF(byte[] input, String password, InputStream keyStore, String alias, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        RandomAccessReadBuffer source = null;
        try {
            source = new RandomAccessReadBuffer(input);
            PDFParser parser = new PDFParser(source, password, keyStore, alias, streamCacheCreateFunction);
            return parser.parse();
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(source);
            throw ioe;
        }
    }

    public static PDDocument loadPDF(File file) throws IOException {
        return Loader.loadPDF(file, "", IOUtils.createMemoryOnlyStreamCache());
    }

    public static PDDocument loadPDF(File file, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        return Loader.loadPDF(file, "", null, null, streamCacheCreateFunction);
    }

    public static PDDocument loadPDF(File file, String password) throws IOException {
        return Loader.loadPDF(file, password, null, null, IOUtils.createMemoryOnlyStreamCache());
    }

    public static PDDocument loadPDF(File file, String password, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        return Loader.loadPDF(file, password, null, null, streamCacheCreateFunction);
    }

    public static PDDocument loadPDF(File file, String password, InputStream keyStore, String alias) throws IOException {
        return Loader.loadPDF(file, password, keyStore, alias, IOUtils.createMemoryOnlyStreamCache());
    }

    public static PDDocument loadPDF(File file, String password, InputStream keyStore, String alias, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        RandomAccessReadBufferedFile raFile = null;
        try {
            raFile = new RandomAccessReadBufferedFile(file);
            return Loader.loadPDF(raFile, password, keyStore, alias, streamCacheCreateFunction);
        }
        catch (IOException ioe) {
            IOUtils.closeQuietly(raFile);
            throw ioe;
        }
    }

    public static PDDocument loadPDF(RandomAccessRead randomAccessRead) throws IOException {
        return Loader.loadPDF(randomAccessRead, "", null, null, IOUtils.createMemoryOnlyStreamCache());
    }

    public static PDDocument loadPDF(RandomAccessRead randomAccessRead, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        return Loader.loadPDF(randomAccessRead, "", null, null, streamCacheCreateFunction);
    }

    public static PDDocument loadPDF(RandomAccessRead randomAccessRead, String password) throws IOException {
        return Loader.loadPDF(randomAccessRead, password, null, null, IOUtils.createMemoryOnlyStreamCache());
    }

    public static PDDocument loadPDF(RandomAccessRead randomAccessRead, String password, InputStream keyStore, String alias) throws IOException {
        return Loader.loadPDF(randomAccessRead, password, keyStore, alias, IOUtils.createMemoryOnlyStreamCache());
    }

    public static PDDocument loadPDF(RandomAccessRead randomAccessRead, String password, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        return Loader.loadPDF(randomAccessRead, password, null, null, streamCacheCreateFunction);
    }

    public static PDDocument loadPDF(RandomAccessRead randomAccessRead, String password, InputStream keyStore, String alias, RandomAccessStreamCache.StreamCacheCreateFunction streamCacheCreateFunction) throws IOException {
        PDFParser parser = new PDFParser(randomAccessRead, password, keyStore, alias, streamCacheCreateFunction);
        return parser.parse();
    }
}

