/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.GraphicsEnvironment;
import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.tools.Decrypt;
import org.apache.pdfbox.tools.Encrypt;
import org.apache.pdfbox.tools.ExportFDF;
import org.apache.pdfbox.tools.ExportXFDF;
import org.apache.pdfbox.tools.ExtractImages;
import org.apache.pdfbox.tools.ExtractText;
import org.apache.pdfbox.tools.ImageToPDF;
import org.apache.pdfbox.tools.ImportFDF;
import org.apache.pdfbox.tools.ImportXFDF;
import org.apache.pdfbox.tools.OverlayPDF;
import org.apache.pdfbox.tools.PDFMerger;
import org.apache.pdfbox.tools.PDFSplit;
import org.apache.pdfbox.tools.PDFToImage;
import org.apache.pdfbox.tools.PrintPDF;
import org.apache.pdfbox.tools.TextToPDF;
import org.apache.pdfbox.tools.Version;
import org.apache.pdfbox.tools.WriteDecodedDoc;
import picocli.CommandLine;

@CommandLine.Command(name="pdfbox", customSynopsis={"pdfbox [COMMAND] [OPTIONS]"}, footer={"See 'pdfbox help <command>' to read about a specific subcommand"}, versionProvider=Version.class)
public final class PDFBox
implements Runnable {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        CommandLine commandLine = new CommandLine(new PDFBox()).setSubcommandsCaseInsensitive(true);
        if (!GraphicsEnvironment.isHeadless()) {
            commandLine.addSubcommand("debug", PDFDebugger.class);
        }
        commandLine.addSubcommand("decrypt", Decrypt.class);
        commandLine.addSubcommand("encrypt", Encrypt.class);
        commandLine.addSubcommand("decode", WriteDecodedDoc.class);
        commandLine.addSubcommand("export:images", ExtractImages.class);
        commandLine.addSubcommand("export:text", ExtractText.class);
        commandLine.addSubcommand("export:fdf", ExportFDF.class);
        commandLine.addSubcommand("export:xfdf", ExportXFDF.class);
        commandLine.addSubcommand("import:fdf", ImportFDF.class);
        commandLine.addSubcommand("import:xfdf", ImportXFDF.class);
        commandLine.addSubcommand("overlay", OverlayPDF.class);
        commandLine.addSubcommand("print", PrintPDF.class);
        commandLine.addSubcommand("render", PDFToImage.class);
        commandLine.addSubcommand("merge", PDFMerger.class);
        commandLine.addSubcommand("split", PDFSplit.class);
        commandLine.addSubcommand("fromimage", ImageToPDF.class);
        commandLine.addSubcommand("fromtext", TextToPDF.class);
        commandLine.addSubcommand("version", Version.class);
        commandLine.addSubcommand("help", CommandLine.HelpCommand.class);
        commandLine.execute(args);
    }

    @Override
    public void run() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Error: Subcommand required");
    }
}

