/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.blend;

import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.blend.SeparableBlendMode;

public abstract class BlendMode {
    public static final SeparableBlendMode NORMAL;
    public static final SeparableBlendMode COMPATIBLE;
    public static final SeparableBlendMode MULTIPLY;
    public static final SeparableBlendMode SCREEN;
    public static final SeparableBlendMode OVERLAY;
    public static final SeparableBlendMode DARKEN;
    public static final SeparableBlendMode LIGHTEN;
    public static final SeparableBlendMode COLOR_DODGE;
    public static final SeparableBlendMode COLOR_BURN;
    public static final SeparableBlendMode HARD_LIGHT;
    public static final SeparableBlendMode SOFT_LIGHT;
    public static final SeparableBlendMode DIFFERENCE;
    public static final SeparableBlendMode EXCLUSION;
    private static final Map<COSName, BlendMode> BLEND_MODES;

    public static BlendMode getInstance(COSBase cosBlendMode) {
        BlendMode result = null;
        if (cosBlendMode instanceof COSName) {
            result = BLEND_MODES.get(cosBlendMode);
        } else if (cosBlendMode instanceof COSArray) {
            COSArray cosBlendModeArray = (COSArray)cosBlendMode;
            for (int i = 0; i < cosBlendModeArray.size() && (result = BLEND_MODES.get(cosBlendModeArray.get(i))) == null; ++i) {
            }
        }
        if (result != null) {
            return result;
        }
        return COMPATIBLE;
    }

    private static Map<COSName, BlendMode> createBlendModeMap() {
        HashMap<COSName, BlendMode> map = new HashMap<COSName, BlendMode>(13);
        map.put(COSName.NORMAL, NORMAL);
        map.put(COSName.COMPATIBLE, COMPATIBLE);
        map.put(COSName.MULTIPLY, MULTIPLY);
        map.put(COSName.SCREEN, SCREEN);
        map.put(COSName.OVERLAY, OVERLAY);
        map.put(COSName.DARKEN, DARKEN);
        map.put(COSName.LIGHTEN, LIGHTEN);
        map.put(COSName.COLOR_DODGE, COLOR_DODGE);
        map.put(COSName.COLOR_BURN, COLOR_BURN);
        map.put(COSName.HARD_LIGHT, HARD_LIGHT);
        map.put(COSName.SOFT_LIGHT, SOFT_LIGHT);
        map.put(COSName.DIFFERENCE, DIFFERENCE);
        map.put(COSName.EXCLUSION, EXCLUSION);
        return map;
    }

    BlendMode() {
    }

    static {
        COMPATIBLE = NORMAL = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue;
            }
        };
        MULTIPLY = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue * dstValue;
            }
        };
        SCREEN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue + dstValue - srcValue * dstValue;
            }
        };
        OVERLAY = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return (double)dstValue <= 0.5 ? 2.0f * dstValue * srcValue : 2.0f * (srcValue + dstValue - srcValue * dstValue) - 1.0f;
            }
        };
        DARKEN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return Math.min(srcValue, dstValue);
            }
        };
        LIGHTEN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return Math.max(srcValue, dstValue);
            }
        };
        COLOR_DODGE = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue < 1.0f ? Math.min(1.0f, dstValue / (1.0f - srcValue)) : 1.0f;
            }
        };
        COLOR_BURN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue > 0.0f ? 1.0f - Math.min(1.0f, (1.0f - dstValue) / srcValue) : 0.0f;
            }
        };
        HARD_LIGHT = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return (double)srcValue <= 0.5 ? 2.0f * dstValue * srcValue : 2.0f * (srcValue + dstValue - srcValue * dstValue) - 1.0f;
            }
        };
        SOFT_LIGHT = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                if ((double)srcValue <= 0.5) {
                    return dstValue - (1.0f - 2.0f * srcValue) * dstValue * (1.0f - dstValue);
                }
                float d = (double)dstValue <= 0.25 ? ((16.0f * dstValue - 12.0f) * dstValue + 4.0f) * dstValue : (float)Math.sqrt(dstValue);
                return dstValue + (2.0f * srcValue - 1.0f) * (d - dstValue);
            }
        };
        DIFFERENCE = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return Math.abs(dstValue - srcValue);
            }
        };
        EXCLUSION = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return dstValue + srcValue - 2.0f * dstValue * srcValue;
            }
        };
        BLEND_MODES = BlendMode.createBlendModeMap();
    }
}

