/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.graphics.shading.AxialShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.util.Matrix;

public class AxialShadingPaint
implements Paint {
    private static final Log LOG = LogFactory.getLog(AxialShadingPaint.class);
    private PDShadingType2 shading;
    private Matrix ctm;
    private int pageHeight;

    public AxialShadingPaint(PDShadingType2 shadingType2, Matrix ctm, int pageHeight) {
        this.shading = shadingType2;
        this.ctm = ctm;
        this.pageHeight = pageHeight;
    }

    public int getTransparency() {
        return 0;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        try {
            return new AxialShadingContext(this.shading, cm, xform, this.ctm, this.pageHeight, deviceBounds);
        }
        catch (IOException ex) {
            LOG.error(ex);
            return null;
        }
    }
}

