/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.DefaultGsubWorker;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.gsub.GsubWorkerForBengali;
import org.apache.fontbox.ttf.gsub.GsubWorkerForDevanagari;
import org.apache.fontbox.ttf.gsub.GsubWorkerForGujarati;
import org.apache.fontbox.ttf.gsub.GsubWorkerForLatin;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GsubWorkerFactory {
    private static final Logger LOG = LogManager.getLogger(GsubWorkerFactory.class);

    public GsubWorker getGsubWorker(CmapLookup cmapLookup, GsubData gsubData) {
        LOG.debug("Language: {}", (Object)gsubData.getLanguage());
        switch (gsubData.getLanguage()) {
            case BENGALI: {
                return new GsubWorkerForBengali(cmapLookup, gsubData);
            }
            case DEVANAGARI: {
                return new GsubWorkerForDevanagari(cmapLookup, gsubData);
            }
            case GUJARATI: {
                return new GsubWorkerForGujarati(cmapLookup, gsubData);
            }
            case LATIN: {
                return new GsubWorkerForLatin(cmapLookup, gsubData);
            }
        }
        return new DefaultGsubWorker();
    }
}

