/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class MapBackedScriptFeature
implements ScriptFeature {
    private final String name;
    private final Map<List<Integer>, List<Integer>> featureMap;

    public MapBackedScriptFeature(String name, Map<List<Integer>, List<Integer>> featureMap) {
        this.name = name;
        this.featureMap = featureMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<List<Integer>> getAllGlyphIdsForSubstitution() {
        return this.featureMap.keySet();
    }

    @Override
    public boolean canReplaceGlyphs(List<Integer> glyphIds) {
        return this.featureMap.containsKey(glyphIds);
    }

    @Override
    public List<Integer> getReplacementForGlyphs(List<Integer> glyphIds) {
        if (!this.canReplaceGlyphs(glyphIds)) {
            throw new UnsupportedOperationException("The glyphs " + glyphIds + " cannot be replaced");
        }
        return this.featureMap.get(glyphIds);
    }

    public int hashCode() {
        return Objects.hash(this.featureMap, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapBackedScriptFeature other = (MapBackedScriptFeature)obj;
        return Objects.equals(other.name, this.name) && Objects.equals(other.featureMap, this.featureMap);
    }
}

