/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitterRegexImpl;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.ScriptFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GsubWorkerForDevanagari
implements GsubWorker {
    private static final Logger LOG = LogManager.getLogger(GsubWorkerForDevanagari.class);
    private static final String RKRF_FEATURE = "rkrf";
    private static final String VATU_FEATURE = "vatu";
    private static final List<String> FEATURES_IN_ORDER = Arrays.asList("locl", "nukt", "akhn", "rphf", "rkrf", "blwf", "half", "vatu", "cjct", "pres", "abvs", "blws", "psts", "haln", "calt");
    private static final char[] REPH_CHARS = new char[]{'\u0930', '\u094d'};
    private static final char[] BEFORE_REPH_CHARS = new char[]{'\u093e', '\u0940'};
    private static final char BEFORE_HALF_CHAR = '\u093f';
    private final CmapLookup cmapLookup;
    private final GsubData gsubData;
    private final List<Integer> rephGlyphIds;
    private final List<Integer> beforeRephGlyphIds;
    private final List<Integer> beforeHalfGlyphIds;

    GsubWorkerForDevanagari(CmapLookup cmapLookup, GsubData gsubData) {
        this.cmapLookup = cmapLookup;
        this.gsubData = gsubData;
        this.beforeHalfGlyphIds = this.getBeforeHalfGlyphIds();
        this.rephGlyphIds = this.getRephGlyphIds();
        this.beforeRephGlyphIds = this.getbeforeRephGlyphIds();
    }

    @Override
    public List<Integer> applyTransforms(List<Integer> originalGlyphIds) {
        List<Integer> intermediateGlyphsFromGsub = this.adjustRephPosition(originalGlyphIds);
        intermediateGlyphsFromGsub = this.repositionGlyphs(intermediateGlyphsFromGsub);
        for (String feature : FEATURES_IN_ORDER) {
            if (!this.gsubData.isFeatureSupported(feature)) {
                if (feature.equals(RKRF_FEATURE) && this.gsubData.isFeatureSupported(VATU_FEATURE)) {
                    intermediateGlyphsFromGsub = this.applyRKRFFeature(this.gsubData.getFeature(VATU_FEATURE), intermediateGlyphsFromGsub);
                }
                LOG.debug("the feature {} was not found", (Object)feature);
                continue;
            }
            LOG.debug("applying the feature {}", (Object)feature);
            ScriptFeature scriptFeature = this.gsubData.getFeature(feature);
            intermediateGlyphsFromGsub = this.applyGsubFeature(scriptFeature, intermediateGlyphsFromGsub);
        }
        return Collections.unmodifiableList(intermediateGlyphsFromGsub);
    }

    private List<Integer> applyRKRFFeature(ScriptFeature rkrfGlyphsForSubstitution, List<Integer> originalGlyphIds) {
        Set<List<Integer>> rkrfGlyphIds = rkrfGlyphsForSubstitution.getAllGlyphIdsForSubstitution();
        if (rkrfGlyphIds.isEmpty()) {
            LOG.debug("Glyph substitution list for {} is empty.", (Object)rkrfGlyphsForSubstitution.getName());
            return originalGlyphIds;
        }
        int rkrfReplacement = 0;
        for (List<Integer> firstList : rkrfGlyphIds) {
            if (firstList.size() <= 1) continue;
            rkrfReplacement = firstList.get(1);
            break;
        }
        if (rkrfReplacement == 0) {
            LOG.debug("Cannot find rkrf candidate. The rkrfGlyphIds doesn't contain lists of two elements.");
            return originalGlyphIds;
        }
        ArrayList<Integer> rkrfList = new ArrayList<Integer>(originalGlyphIds);
        for (int index = originalGlyphIds.size() - 1; index > 1; --index) {
            int viramaGlyph;
            int raGlyph = originalGlyphIds.get(index);
            if (raGlyph != this.rephGlyphIds.get(0) || (viramaGlyph = originalGlyphIds.get(index - 1).intValue()) != this.rephGlyphIds.get(1)) continue;
            rkrfList.set(index - 1, rkrfReplacement);
            rkrfList.remove(index);
        }
        return rkrfList;
    }

    private List<Integer> adjustRephPosition(List<Integer> originalGlyphIds) {
        ArrayList<Integer> rephAdjustedList = new ArrayList<Integer>(originalGlyphIds);
        for (int index = 0; index < originalGlyphIds.size() - 2; ++index) {
            int matraGlyph;
            int raGlyph = originalGlyphIds.get(index);
            int viramaGlyph = originalGlyphIds.get(index + 1);
            if (raGlyph != this.rephGlyphIds.get(0) || viramaGlyph != this.rephGlyphIds.get(1)) continue;
            int nextConsonantGlyph = originalGlyphIds.get(index + 2);
            rephAdjustedList.set(index, nextConsonantGlyph);
            rephAdjustedList.set(index + 1, raGlyph);
            rephAdjustedList.set(index + 2, viramaGlyph);
            if (index + 3 >= originalGlyphIds.size() || !this.beforeRephGlyphIds.contains(matraGlyph = originalGlyphIds.get(index + 3).intValue())) continue;
            rephAdjustedList.set(index + 1, matraGlyph);
            rephAdjustedList.set(index + 2, raGlyph);
            rephAdjustedList.set(index + 3, viramaGlyph);
        }
        return rephAdjustedList;
    }

    private List<Integer> repositionGlyphs(List<Integer> originalGlyphIds) {
        ArrayList<Integer> repositionedGlyphIds = new ArrayList<Integer>(originalGlyphIds);
        int listSize = repositionedGlyphIds.size();
        int foundIndex = listSize - 1;
        int nextIndex = listSize - 2;
        while (nextIndex > -1) {
            int prevGlyph;
            int glyph = (Integer)repositionedGlyphIds.get(foundIndex);
            int prevIndex = foundIndex + 1;
            if (this.beforeHalfGlyphIds.contains(glyph)) {
                repositionedGlyphIds.remove(foundIndex);
                repositionedGlyphIds.add(nextIndex--, glyph);
            } else if (this.rephGlyphIds.get(1).equals(glyph) && prevIndex < listSize && this.beforeHalfGlyphIds.contains(prevGlyph = ((Integer)repositionedGlyphIds.get(prevIndex)).intValue())) {
                repositionedGlyphIds.remove(prevIndex);
                repositionedGlyphIds.add(nextIndex--, prevGlyph);
            }
            foundIndex = nextIndex--;
        }
        return repositionedGlyphIds;
    }

    private List<Integer> applyGsubFeature(ScriptFeature scriptFeature, List<Integer> originalGlyphs) {
        Set<List<Integer>> allGlyphIdsForSubstitution = scriptFeature.getAllGlyphIdsForSubstitution();
        if (allGlyphIdsForSubstitution.isEmpty()) {
            LOG.debug("getAllGlyphIdsForSubstitution() for {} is empty", (Object)scriptFeature.getName());
            return originalGlyphs;
        }
        GlyphArraySplitterRegexImpl glyphArraySplitter = new GlyphArraySplitterRegexImpl(allGlyphIdsForSubstitution);
        List<List<Integer>> tokens = glyphArraySplitter.split(originalGlyphs);
        ArrayList<Integer> gsubProcessedGlyphs = new ArrayList<Integer>(tokens.size());
        tokens.forEach(chunk -> {
            if (scriptFeature.canReplaceGlyphs((List<Integer>)chunk)) {
                List<Integer> replacementForGlyphs = scriptFeature.getReplacementForGlyphs((List<Integer>)chunk);
                gsubProcessedGlyphs.addAll(replacementForGlyphs);
            } else {
                gsubProcessedGlyphs.addAll((Collection<Integer>)chunk);
            }
        });
        LOG.debug("originalGlyphs: {}, gsubProcessedGlyphs: {}", originalGlyphs, gsubProcessedGlyphs);
        return gsubProcessedGlyphs;
    }

    private List<Integer> getBeforeHalfGlyphIds() {
        return List.of(this.getGlyphId('\u093f'));
    }

    private List<Integer> getRephGlyphIds() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (char character : REPH_CHARS) {
            result.add(this.getGlyphId(character));
        }
        return Collections.unmodifiableList(result);
    }

    private List<Integer> getbeforeRephGlyphIds() {
        ArrayList<Integer> glyphIds = new ArrayList<Integer>();
        for (char character : BEFORE_REPH_CHARS) {
            glyphIds.add(this.getGlyphId(character));
        }
        return Collections.unmodifiableList(glyphIds);
    }

    private Integer getGlyphId(char character) {
        return this.cmapLookup.getGlyphId(character);
    }
}

