/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.FontHeaders;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.RandomAccessReadUnbufferedDataStream;
import org.apache.fontbox.ttf.TTCDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;

public class TrueTypeCollection
implements Closeable {
    private final TTFDataStream stream;
    private final int numFonts;
    private final long[] fontOffsets;

    public TrueTypeCollection(File file) throws IOException {
        this(TrueTypeCollection.createBufferedDataStream((RandomAccessRead)new RandomAccessReadBufferedFile(file), true));
    }

    public TrueTypeCollection(InputStream stream) throws IOException {
        this(TrueTypeCollection.createBufferedDataStream((RandomAccessRead)new RandomAccessReadBuffer(stream), false));
    }

    private TrueTypeCollection(TTFDataStream stream) throws IOException {
        this.stream = stream;
        String tag = stream.readTag();
        if (!tag.equals("ttcf")) {
            throw new IOException("Missing TTC header");
        }
        float version = stream.read32Fixed();
        this.numFonts = (int)stream.readUnsignedInt();
        if (this.numFonts <= 0 || this.numFonts > 1024) {
            throw new IOException("Invalid number of fonts " + this.numFonts);
        }
        this.fontOffsets = new long[this.numFonts];
        for (int i = 0; i < this.numFonts; ++i) {
            this.fontOffsets[i] = stream.readUnsignedInt();
        }
        if (version >= 2.0f) {
            int ulDsigTag = stream.readUnsignedShort();
            int ulDsigLength = stream.readUnsignedShort();
            int n = stream.readUnsignedShort();
        }
    }

    private static TTFDataStream createBufferedDataStream(RandomAccessRead randomAccessRead, boolean closeAfterReading) throws IOException {
        try {
            RandomAccessReadDataStream randomAccessReadDataStream = new RandomAccessReadDataStream(randomAccessRead);
            return randomAccessReadDataStream;
        }
        finally {
            if (closeAfterReading) {
                IOUtils.closeQuietly((Closeable)randomAccessRead);
            }
        }
    }

    public void processAllFonts(TrueTypeFontProcessor trueTypeFontProcessor) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont font = this.getFontAtIndex(i);
            trueTypeFontProcessor.process(font);
        }
    }

    public static void processAllFontHeaders(File ttcFile, TrueTypeFontHeadersProcessor trueTypeFontProcessor) throws IOException {
        try (RandomAccessReadBufferedFile read = new RandomAccessReadBufferedFile(ttcFile);
             RandomAccessReadUnbufferedDataStream stream = new RandomAccessReadUnbufferedDataStream((RandomAccessRead)read);
             TrueTypeCollection ttc = new TrueTypeCollection(stream);){
            for (int i = 0; i < ttc.numFonts; ++i) {
                TTFParser parser = ttc.createFontParserAtIndexAndSeek(i);
                FontHeaders headers = parser.parseTableHeaders(new TTCDataStream(ttc.stream));
                trueTypeFontProcessor.process(headers);
            }
        }
    }

    private TrueTypeFont getFontAtIndex(int idx) throws IOException {
        TTFParser parser = this.createFontParserAtIndexAndSeek(idx);
        return parser.parse(new TTCDataStream(this.stream));
    }

    private TTFParser createFontParserAtIndexAndSeek(int idx) throws IOException {
        this.stream.seek(this.fontOffsets[idx]);
        TTFParser parser = this.stream.readTag().equals("OTTO") ? new OTFParser(false) : new TTFParser(false);
        this.stream.seek(this.fontOffsets[idx]);
        return parser;
    }

    public TrueTypeFont getFontByName(String name) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont font = this.getFontAtIndex(i);
            if (!font.getName().equals(name)) continue;
            return font;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @FunctionalInterface
    public static interface TrueTypeFontProcessor {
        public void process(TrueTypeFont var1) throws IOException;
    }

    @FunctionalInterface
    public static interface TrueTypeFontHeadersProcessor {
        public void process(FontHeaders var1);
    }
}

