/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;

public class NonSeekableRandomAccessReadInputStream
implements RandomAccessRead {
    private static final Log LOG = LogFactory.getLog(NonSeekableRandomAccessReadInputStream.class);
    protected long position = 0L;
    protected int currentBufferPointer = 0;
    protected long size = 0L;
    private final InputStream is;
    private static final int BUFFER_SIZE = 4096;
    private static final int CURRENT = 0;
    private static final int LAST = 1;
    private static final int NEXT = 2;
    private final byte[][] buffers = new byte[][]{new byte[4096], new byte[4096], new byte[4096]};
    private final int[] bufferBytes = new int[]{-1, -1, -1};
    private boolean isClosed = false;
    private boolean isEOF = false;

    public NonSeekableRandomAccessReadInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.isClosed = true;
    }

    @Override
    public void seek(long position) throws IOException {
        throw new IOException(this.getClass().getName() + ".seek isn't supported.");
    }

    @Override
    public void skip(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.read();
        }
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.position;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.isEOF()) {
            return -1;
        }
        if (this.currentBufferPointer >= this.bufferBytes[0] && !this.fetch()) {
            this.isEOF = true;
            return -1;
        }
        ++this.position;
        return this.buffers[0][this.currentBufferPointer++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        this.checkClosed();
        if (this.isEOF()) {
            return -1;
        }
        int numberOfBytesRead = 0;
        while (numberOfBytesRead < length) {
            int available = this.bufferBytes[0] - this.currentBufferPointer;
            if (available > 0) {
                int bytes2Copy = Math.min(length - numberOfBytesRead, available);
                System.arraycopy(this.buffers[0], this.currentBufferPointer, b, numberOfBytesRead + offset, bytes2Copy);
                this.currentBufferPointer += bytes2Copy;
                this.position += (long)bytes2Copy;
                numberOfBytesRead += bytes2Copy;
                continue;
            }
            if (this.fetch()) continue;
            this.isEOF = true;
            break;
        }
        return numberOfBytesRead;
    }

    private void switchBuffers(int firstBuffer, int secondBuffer) {
        byte[] tmpBuffer = this.buffers[firstBuffer];
        this.buffers[firstBuffer] = this.buffers[secondBuffer];
        this.buffers[secondBuffer] = tmpBuffer;
        int tmpBufferBytes = this.bufferBytes[firstBuffer];
        this.bufferBytes[firstBuffer] = this.bufferBytes[secondBuffer];
        this.bufferBytes[secondBuffer] = tmpBufferBytes;
    }

    private boolean fetch() throws IOException {
        this.checkClosed();
        this.currentBufferPointer = 0;
        if (this.bufferBytes[2] > -1) {
            this.switchBuffers(0, 1);
            this.switchBuffers(0, 2);
            this.bufferBytes[2] = -1;
            return true;
        }
        try {
            if (this.bufferBytes[1] == 4096 && this.bufferBytes[0] > 0 && this.bufferBytes[0] < 4096) {
                System.arraycopy(this.buffers[1], this.bufferBytes[0], this.buffers[1], 0, 4096 - this.bufferBytes[0]);
                System.arraycopy(this.buffers[0], 0, this.buffers[1], 4096 - this.bufferBytes[0], this.bufferBytes[0]);
                this.bufferBytes[1] = 4096;
            } else {
                this.switchBuffers(0, 1);
            }
            this.bufferBytes[0] = this.is.read(this.buffers[0]);
            if (this.bufferBytes[0] <= 0) {
                this.bufferBytes[0] = -1;
                return false;
            }
            this.size += (long)this.bufferBytes[0];
        }
        catch (IOException exception) {
            LOG.warn("FlateFilter: premature end of stream due to a DataFormatException");
            this.isEOF = true;
            throw exception;
        }
        return true;
    }

    @Override
    public long length() throws IOException {
        this.checkClosed();
        return this.size;
    }

    @Override
    public void rewind(int bytes) throws IOException {
        if (this.currentBufferPointer >= bytes) {
            this.currentBufferPointer -= bytes;
            this.position -= (long)bytes;
        } else if (this.bufferBytes[1] > 0) {
            int remainingBytesToRewind = bytes - this.currentBufferPointer;
            this.switchBuffers(0, 2);
            this.switchBuffers(0, 1);
            this.bufferBytes[1] = -1;
            this.currentBufferPointer = this.bufferBytes[0] - remainingBytesToRewind;
            this.position -= (long)bytes;
            this.isEOF = false;
        } else {
            throw new IOException("not enough bytes available to perform the rewind operation");
        }
    }

    protected void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(this.getClass().getSimpleName() + " already closed");
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isEOF() throws IOException {
        this.checkClosed();
        return this.isEOF;
    }

    @Override
    public RandomAccessReadView createView(long startPosition, long streamLength) throws IOException {
        throw new IOException(this.getClass().getName() + ".createView isn't supported.");
    }
}

