/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift.transport;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import shaded.parquet.org.apache.thrift.transport.TTransport;
import shaded.parquet.org.apache.thrift.transport.TTransportException;

public final class TByteBuffer
extends TTransport {
    private final ByteBuffer byteBuffer;

    public TByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int n = Math.min(this.byteBuffer.remaining(), len);
        if (n > 0) {
            try {
                this.byteBuffer.get(buf, off, n);
            }
            catch (BufferUnderflowException e) {
                throw new TTransportException("Unexpected end of input buffer", (Throwable)e);
            }
        }
        return n;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.byteBuffer.put(buf, off, len);
        }
        catch (BufferOverflowException e) {
            throw new TTransportException("Not enough room in output buffer", (Throwable)e);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public TByteBuffer clear() {
        this.byteBuffer.clear();
        return this;
    }

    public TByteBuffer flip() {
        this.byteBuffer.flip();
        return this;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.slice().get(data);
        return data;
    }
}

