/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift.transport;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.parquet.org.apache.thrift.transport.TSaslTransport;
import shaded.parquet.org.apache.thrift.transport.TTransport;
import shaded.parquet.org.apache.thrift.transport.TTransportException;

public class TSaslClientTransport
extends TSaslTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSaslClientTransport.class);
    private final String mechanism;

    public TSaslClientTransport(SaslClient saslClient, TTransport transport) {
        super(saslClient, transport);
        this.mechanism = saslClient.getMechanismName();
    }

    public TSaslClientTransport(String mechanism, String authorizationId, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport) throws SaslException {
        super(Sasl.createSaslClient(new String[]{mechanism}, authorizationId, protocol, serverName, props, cbh), transport);
        this.mechanism = mechanism;
    }

    @Override
    protected TSaslTransport.SaslRole getRole() {
        return TSaslTransport.SaslRole.CLIENT;
    }

    @Override
    protected void handleSaslStartMessage() throws TTransportException, SaslException {
        byte[] mechanismBytes;
        SaslClient saslClient = this.getSaslClient();
        byte[] initialResponse = new byte[]{};
        if (saslClient.hasInitialResponse()) {
            initialResponse = saslClient.evaluateChallenge(initialResponse);
        }
        LOGGER.debug("Sending mechanism name {} and initial response of length {}", (Object)this.mechanism, (Object)initialResponse.length);
        try {
            mechanismBytes = this.mechanism.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TTransportException(e);
        }
        this.sendSaslMessage(TSaslTransport.NegotiationStatus.START, mechanismBytes);
        this.sendSaslMessage(saslClient.isComplete() ? TSaslTransport.NegotiationStatus.COMPLETE : TSaslTransport.NegotiationStatus.OK, initialResponse);
        this.underlyingTransport.flush();
    }
}

