/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.text.TextStringBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.Util;
import org.apache.parquet.column.statistics.SizeStatistics;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;

@Parameters(commandDescription="Print size statistics for a Parquet file")
public class ShowSizeStatisticsCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> targets;

    public ShowSizeStatisticsCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && !this.targets.isEmpty() ? 1 : 0) != 0, (Object)"A Parquet file is required.");
        Preconditions.checkArgument((this.targets.size() == 1 ? 1 : 0) != 0, (Object)"Cannot process multiple Parquet files.");
        String source = this.targets.get(0);
        try (ParquetFileReader reader = ParquetFileReader.open((Configuration)this.getConf(), (Path)this.qualifiedPath(source));){
            ParquetMetadata footer = reader.getFooter();
            MessageType schema = footer.getFileMetaData().getSchema();
            this.console.info("\nFile path: {}", (Object)source);
            List rowGroups = footer.getBlocks();
            int n = rowGroups.size();
            for (int index = 0; index < n; ++index) {
                this.printRowGroupSizeStats(this.console, index, (BlockMetaData)rowGroups.get(index), schema);
                this.console.info("");
            }
        }
        return 0;
    }

    private void printRowGroupSizeStats(Logger console, int index, BlockMetaData rowGroup, MessageType schema) {
        int maxColumnWidth = Math.max("column".length(), rowGroup.getColumns().stream().map(col -> col.getPath().toString().length()).max(Integer::compare).orElse(0));
        console.info(String.format("\nRow group %d\n%s", index, new TextStringBuilder(80).appendPadding(80, '-')));
        String formatString = String.format("%%-%ds %%-15s %%-40s %%-40s", maxColumnWidth);
        console.info(String.format(formatString, "column", "unencoded bytes", "rep level histogram", "def level histogram"));
        for (ColumnChunkMetaData column : rowGroup.getColumns()) {
            this.printColumnSizeStats(console, column, schema, maxColumnWidth);
        }
    }

    private void printColumnSizeStats(Logger console, ColumnChunkMetaData column, MessageType schema, int columnWidth) {
        SizeStatistics stats = column.getSizeStatistics();
        if (stats != null && stats.isValid()) {
            String unencodedBytes = stats.getUnencodedByteArrayDataBytes().isPresent() ? Util.humanReadable((Long)stats.getUnencodedByteArrayDataBytes().get()) : "-";
            List repLevels = stats.getRepetitionLevelHistogram();
            String repLevelsString = repLevels != null && !repLevels.isEmpty() ? repLevels.toString() : "-";
            List defLevels = stats.getDefinitionLevelHistogram();
            String defLevelsString = defLevels != null && !defLevels.isEmpty() ? defLevels.toString() : "-";
            String formatString = String.format("%%-%ds %%-15s %%-40s %%-40s", columnWidth);
            console.info(String.format(formatString, column.getPath(), unencodedBytes, repLevelsString, defLevelsString));
        } else {
            String formatString = String.format("%%-%ds %%-15s %%-40s %%-40s", columnWidth);
            console.info(String.format(formatString, column.getPath(), "-", "-", "-"));
        }
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Show size statistics for a Parquet file", "sample.parquet"});
    }
}

