/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.file.SeekableInput;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SeekableFSDataInputStream
extends InputStream
implements SeekableInput {
    private final FSDataInputStream in;
    private final FileStatus stat;

    public SeekableFSDataInputStream(FileSystem fs, Path file) throws IOException {
        this.in = fs.open(file);
        this.stat = fs.getFileStatus(file);
    }

    public void seek(long p) throws IOException {
        this.in.seek(p);
    }

    public long tell() throws IOException {
        return this.in.getPos();
    }

    public long length() throws IOException {
        return this.stat.getLen();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

