/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.csv;

import javax.annotation.concurrent.Immutable;
import org.apache.commons.text.StringEscapeUtils;

@Immutable
public class CSVProperties {
    public static final String DEFAULT_CHARSET = "utf8";
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_QUOTE = "\"";
    public static final String DEFAULT_ESCAPE = "\\";
    public static final String DEFAULT_HAS_HEADER = "false";
    public static final int DEFAULT_LINES_TO_SKIP = 0;
    public final String charset;
    public final String delimiter;
    public final String quote;
    public final String escape;
    public final String header;
    public final boolean useHeader;
    public final int linesToSkip;

    private CSVProperties(String charset, String delimiter, String quote, String escape, String header, boolean useHeader, int linesToSkip) {
        this.charset = charset;
        this.delimiter = delimiter;
        this.quote = quote;
        this.escape = escape;
        this.header = header;
        this.useHeader = useHeader;
        this.linesToSkip = linesToSkip;
    }

    public static class Builder {
        private String charset = "utf8";
        private String delimiter = ",";
        private String quote = "\"";
        private String escape = "\\";
        private boolean useHeader = Boolean.parseBoolean("false");
        private int linesToSkip = 0;
        private String header = null;

        private static String unescapeJava(String str) {
            if (str == CSVProperties.DEFAULT_ESCAPE) {
                return str;
            }
            return StringEscapeUtils.unescapeJava((String)str);
        }

        public Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = Builder.unescapeJava(delimiter);
            return this;
        }

        public Builder quote(String quote) {
            this.quote = Builder.unescapeJava(quote);
            return this;
        }

        public Builder escape(String escape) {
            this.escape = Builder.unescapeJava(escape);
            return this;
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder hasHeader() {
            this.useHeader = true;
            return this;
        }

        public Builder hasHeader(boolean hasHeader) {
            this.useHeader = hasHeader;
            return this;
        }

        public Builder linesToSkip(int linesToSkip) {
            this.linesToSkip = linesToSkip;
            return this;
        }

        public CSVProperties build() {
            return new CSVProperties(this.charset, this.delimiter, this.quote, this.escape, this.header, this.useHeader, this.linesToSkip);
        }
    }
}

