/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.rawpages;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.parquet.cli.util.RawUtils;
import org.apache.parquet.format.CliUtils;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;
import shaded.parquet.org.apache.thrift.TBase;

public class RawPagesReader
implements AutoCloseable {
    private final SeekableInputStream input;
    private final FileMetaData footer;
    private final Set<String> columns;

    public RawPagesReader(InputFile file) throws IOException {
        this(file, null);
    }

    public RawPagesReader(InputFile file, List<String> cols) throws IOException {
        long fileLen = file.getLength();
        if (fileLen < (long)(ParquetFileWriter.MAGIC.length + 4 + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException("Not a Parquet file (length is too low: " + fileLen + ")");
        }
        this.input = file.newStream();
        this.footer = RawUtils.readFooter(this.input, fileLen);
        this.columns = cols == null || cols.isEmpty() ? null : new HashSet<String>(cols);
    }

    public void listPages(Logger console) throws IOException {
        int n = this.footer.getRow_groupsSize();
        for (int i = 0; i < n; ++i) {
            RowGroup rowGroup = (RowGroup)this.footer.getRow_groups().get(i);
            for (ColumnChunk columnChunk : rowGroup.getColumns()) {
                ColumnMetaData metaData = columnChunk.getMeta_data();
                String path = String.join((CharSequence)".", metaData.getPath_in_schema());
                if (this.columns != null && !this.columns.contains(path)) continue;
                long totalSize = metaData.getTotal_compressed_size();
                long dictOffset = metaData.getDictionary_page_offset();
                long seekTo = metaData.getData_page_offset();
                console.info("Start of chunk (rowGroup: {}, columnName: {}, dictPageOffset: {}, dataPageOffset: {}, numValues: {}, totalSize: {})", new Object[]{i, path, metaData.isSetDictionary_page_offset() ? Long.valueOf(dictOffset) : "-", seekTo, metaData.getNum_values(), totalSize});
                if (metaData.isSetDictionary_page_offset() && dictOffset > 0L && dictOffset < seekTo) {
                    seekTo = metaData.getDictionary_page_offset();
                }
                this.input.seek(seekTo);
                long endPos = seekTo + totalSize;
                int pageIndex = 0;
                long offset = this.input.getPos();
                while (offset < endPos) {
                    PageHeader pageHeader = Util.readPageHeader((InputStream)this.input);
                    console.info("Page {}. (offset: {}, headerSize: {})\n{}", new Object[]{pageIndex++, offset, this.input.getPos() - offset, RawUtils.prettifyJson(CliUtils.toJson((TBase)pageHeader))});
                    this.input.skip((long)pageHeader.getCompressed_page_size());
                    offset = this.input.getPos();
                }
                if (this.input.getPos() != endPos) {
                    console.warn("!!! Current file offset does not match with the total size of the chunk in the footer: {}", (Object)this.input.getPos());
                    continue;
                }
                console.info("End of chunk (offset: {})", (Object)(endPos - 1L));
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

