/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.parquet.cli.Command;
import org.slf4j.Logger;

@Parameters(commandDescription="Retrieves details on the functions of other commands")
public class Help
implements Command {
    @Parameter(description="<commands>")
    List<String> helpCommands = Lists.newArrayList();
    private final JCommander jc;
    private final Logger console;
    private String programName;

    public Help(JCommander jc, Logger console) {
        this.jc = jc;
        this.console = console;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    @Override
    public int run() {
        if (this.helpCommands.isEmpty()) {
            this.printGenericHelp();
        } else {
            for (String cmd : this.helpCommands) {
                List<String> examples;
                JCommander commander = (JCommander)this.jc.getCommands().get(cmd);
                if (commander == null) {
                    this.console.error("\nUnknown command: {}\n", (Object)cmd);
                    this.printGenericHelp();
                    return 1;
                }
                boolean hasRequired = false;
                if (commander.getParameters().stream().anyMatch(p -> p.getNames().isEmpty())) {
                    this.console.info("\nUsage: {} [general options] {} {} [command options]", new Object[]{this.programName, cmd, commander.getMainParameterDescription()});
                } else {
                    this.console.info("\nUsage: {} [general options] {} [command options]", new Object[]{this.programName, cmd});
                }
                this.console.info("\n  Description:");
                this.console.info("\n    {}", (Object)this.jc.getCommandDescription(cmd));
                if (!commander.getParameters().isEmpty()) {
                    this.console.info("\n  Command options:\n");
                    for (ParameterDescription param : commander.getParameters()) {
                        hasRequired = this.printOption(this.console, param) || hasRequired;
                    }
                    if (hasRequired) {
                        this.console.info("\n  * = required");
                    }
                }
                if ((examples = ((Command)commander.getObjects().get(0)).getExamples()) != null) {
                    this.console.info("\n  Examples:");
                    for (String example : examples) {
                        if (example.startsWith("#")) {
                            this.console.info("\n    {}", (Object)example);
                            continue;
                        }
                        this.console.info("    {} {} {}", new Object[]{this.programName, cmd, example});
                    }
                }
                this.console.info("");
            }
        }
        return 0;
    }

    public void printGenericHelp() {
        boolean hasRequired = false;
        this.console.info("\nUsage: {} [options] [command] [command options]", (Object)this.programName);
        this.console.info("\n  Options:\n");
        for (ParameterDescription param : this.jc.getParameters()) {
            hasRequired = this.printOption(this.console, param) || hasRequired;
        }
        if (hasRequired) {
            this.console.info("\n  * = required");
        }
        this.console.info("\n  Commands:\n");
        for (String command2 : this.jc.getCommands().keySet()) {
            this.console.info("    {}\n\t{}", (Object)command2, (Object)this.jc.getCommandDescription(command2));
        }
        this.jc.getCommands().keySet().stream().filter(s -> !s.equals("help")).findFirst().ifPresent(command -> {
            this.console.info("\n  Examples:");
            this.console.info("\n    # print information for {}\n    {} help {}", new Object[]{command, this.programName, command});
            this.console.info("\n  See '{} help <command>' for more information on a specific command.", (Object)this.programName);
        });
    }

    private boolean printOption(Logger console, ParameterDescription param) {
        boolean required = param.getParameter().required();
        if (!param.getParameter().hidden()) {
            console.info("  {} {}\n\t{}{}", new Object[]{required ? "*" : " ", param.getNames().trim(), param.getDescription(), this.formatDefault(param)});
        }
        return required;
    }

    private String formatDefault(ParameterDescription param) {
        Object defaultValue = param.getDefault();
        if (defaultValue == null || param.getParameter().arity() < 1) {
            return "";
        }
        return " (default: " + (defaultValue instanceof String ? "\"" + defaultValue + "\"" : defaultValue.toString()) + ")";
    }

    @Override
    public List<String> getExamples() {
        return null;
    }
}

