/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.util;

import java.util.Locale;
import org.apache.avro.file.CodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class Codecs {
    public static CompressionCodecName parquetCodec(String codec) {
        try {
            return CompressionCodecName.valueOf((String)codec.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown compression codec: " + codec);
        }
    }

    public static CodecFactory avroCodec(String codec) {
        CompressionCodecName parquetCodec = Codecs.parquetCodec(codec);
        switch (parquetCodec) {
            case UNCOMPRESSED: {
                return CodecFactory.nullCodec();
            }
            case SNAPPY: {
                return CodecFactory.snappyCodec();
            }
            case GZIP: {
                return CodecFactory.deflateCodec((int)9);
            }
            case ZSTD: {
                return CodecFactory.zstandardCodec((int)3);
            }
        }
        throw new IllegalArgumentException("Codec incompatible with Avro: " + codec);
    }
}

