/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.avro.file.SeekableInput;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.Formats;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.slf4j.Logger;

@Parameters(commandDescription="Print the Avro schema for a file")
public class SchemaCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> targets;
    @Parameter(names={"-o", "--output"}, description="Output file path")
    String outputPath = null;
    @Parameter(names={"--overwrite"}, description="Overwrite the output file if it exists")
    boolean overwrite = false;
    @Parameter(names={"--parquet"}, description="Print a Parquet schema, without converting to Avro", hidden=true)
    boolean parquetSchema = false;

    public SchemaCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 1 ? 1 : 0) != 0, (Object)"Parquet file is required.");
        if (this.targets.size() > 1) {
            Preconditions.checkArgument((this.outputPath == null ? 1 : 0) != 0, (Object)("Cannot output multiple schemas to file " + this.outputPath));
            for (String source : this.targets) {
                this.console.info("{}: {}", (Object)source, (Object)this.getSchema(source));
            }
        } else {
            String source = this.targets.get(0);
            if (this.outputPath != null) {
                try (FSDataOutputStream out = this.overwrite ? this.create(this.outputPath) : this.createWithNoOverwrite(this.outputPath);){
                    out.write(this.getSchema(source).getBytes(StandardCharsets.UTF_8));
                }
            } else {
                this.console.info(this.getSchema(source));
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print the Avro schema for a Parquet file", "sample.parquet", "# Print the Avro schema for an Avro file", "sample.avro", "# Print the Avro schema for a JSON file", "sample.json"});
    }

    private String getSchema(String source) throws IOException {
        if (this.parquetSchema) {
            return this.getParquetSchema(source);
        }
        return this.getAvroSchema(source).toString(true);
    }

    private String getParquetSchema(String source) throws IOException {
        SeekableInput in = this.openSeekable(source);
        Formats.Format format = Formats.detectFormat((InputStream)in);
        in.seek(0L);
        switch (format) {
            case PARQUET: {
                try (ParquetFileReader reader = new ParquetFileReader(this.getConf(), this.qualifiedPath(source), ParquetMetadataConverter.NO_FILTER);){
                    String string = reader.getFileMetaData().getSchema().toString();
                    return string;
                }
            }
        }
        throw new IllegalArgumentException(String.format("Could not get a Parquet schema for format %s: %s", new Object[]{format, source}));
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

